/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.util;

import chumbanotz.mutantbeasts.MutantBeasts;
import chumbanotz.mutantbeasts.packet.MBPacketHandler;
import chumbanotz.mutantbeasts.packet.SpawnParticlePacket;
import chumbanotz.mutantbeasts.particles.MBParticleTypes;
import java.lang.reflect.Field;
import java.util.Collection;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.RavagerEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.passive.OcelotEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.network.PacketDistributor;

public class EntityUtil {
    private static final Field STUN_TICK = ObfuscationReflectionHelper.findField(RavagerEntity.class, (String)"field_213692_bA");

    public static boolean canBlockDamageSource(LivingEntity livingEntity, DamageSource damageSource) {
        Vector3d vec3d2;
        AbstractArrowEntity abstractarrowentity;
        Entity entity = damageSource.func_76364_f();
        boolean flag = false;
        if (entity instanceof AbstractArrowEntity && (abstractarrowentity = (AbstractArrowEntity)entity).func_213874_s() > 0) {
            flag = true;
        }
        if (!damageSource.func_76363_c() && livingEntity.func_184585_cz() && !flag && (vec3d2 = damageSource.func_188404_v()) != null) {
            Vector3d vec3d = livingEntity.func_70676_i(1.0f);
            Vector3d vec3d1 = vec3d2.func_72444_a(new Vector3d(livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_(), livingEntity.func_226281_cx_())).func_72432_b();
            vec3d1 = new Vector3d(vec3d1.field_72450_a, 0.0, vec3d1.field_72449_c);
            if (vec3d1.func_72430_b(vec3d) < 0.0) {
                return true;
            }
        }
        return false;
    }

    public static void spawnLingeringCloud(LivingEntity livingEntity) {
        Collection collection = livingEntity.func_70651_bq();
        if (!collection.isEmpty()) {
            AreaEffectCloudEntity areaeffectcloudentity = new AreaEffectCloudEntity(livingEntity.field_70170_p, livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_(), livingEntity.func_226281_cx_());
            areaeffectcloudentity.func_184483_a(2.5f);
            areaeffectcloudentity.func_184495_b(-0.5f);
            areaeffectcloudentity.func_184485_d(10);
            areaeffectcloudentity.func_184486_b(areaeffectcloudentity.func_184489_o() / 2);
            areaeffectcloudentity.func_184487_c(-areaeffectcloudentity.func_184490_j() / (float)areaeffectcloudentity.func_184489_o());
            for (EffectInstance effectinstance : collection) {
                areaeffectcloudentity.func_184496_a(new EffectInstance(effectinstance));
            }
            livingEntity.field_70170_p.func_217376_c((Entity)areaeffectcloudentity);
        }
    }

    public static void stunRavager(LivingEntity livingEntity) {
        if (livingEntity instanceof RavagerEntity) {
            try {
                STUN_TICK.setInt(livingEntity, 40);
                livingEntity.func_184185_a(SoundEvents.field_219649_fi, 1.0f, 1.0f);
                livingEntity.field_70170_p.func_72960_a((Entity)livingEntity, (byte)39);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                MutantBeasts.LOGGER.warn("Failed to access ravager stunTick", (Throwable)e);
            }
        }
    }

    public static void disableShield(LivingEntity livingEntity, DamageSource damageSource, int ticks) {
        if (livingEntity instanceof PlayerEntity && EntityUtil.canBlockDamageSource(livingEntity, damageSource)) {
            ((PlayerEntity)livingEntity).func_184811_cZ().func_185145_a(livingEntity.func_184607_cu().func_77973_b(), ticks);
            livingEntity.func_184602_cy();
            livingEntity.field_70170_p.func_72960_a((Entity)livingEntity, (byte)30);
        }
    }

    public static void sendPlayerVelocityPacket(Entity entity) {
        if (entity instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)entity).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket(entity));
        }
    }

    public static boolean isFeline(LivingEntity livingEntity) {
        return livingEntity instanceof OcelotEntity || livingEntity instanceof CatEntity;
    }

    public static boolean shouldAttackEntity(TameableEntity tameableEntity, LivingEntity target, LivingEntity owner, boolean canTargetCreepers) {
        if (owner instanceof PlayerEntity) {
            if (target instanceof CreeperEntity) {
                return canTargetCreepers;
            }
            if (target instanceof TameableEntity && target.func_200600_R() == tameableEntity.func_200600_R()) {
                return !((TameableEntity)target).func_70909_n() || ((TameableEntity)target).func_70902_q() != owner;
            }
            if (target instanceof PlayerEntity && !((PlayerEntity)owner).func_96122_a((PlayerEntity)target)) {
                return false;
            }
            if (target instanceof GolemEntity && !(target instanceof IMob)) {
                return false;
            }
            if (target instanceof AbstractHorseEntity && ((AbstractHorseEntity)target).func_110248_bS()) {
                return false;
            }
            return !(target instanceof TameableEntity) || !((TameableEntity)target).func_70909_n();
        }
        return true;
    }

    public static boolean isFacing(LivingEntity livingEntity, double x, double z, float maxDifference) {
        float rot;
        for (rot = (float)(Math.atan2(z, x) * 180.0 / Math.PI) + 90.0f; rot > livingEntity.field_70759_as + 180.0f; rot -= 360.0f) {
        }
        while (rot <= livingEntity.field_70759_as - 180.0f) {
            rot += 360.0f;
        }
        return Math.abs(livingEntity.field_70759_as - rot) < maxDifference;
    }

    public static void copyNBT(Entity oldEntity, Entity newEntity, boolean resetAttributes) {
        if (oldEntity == newEntity) {
            throw new IllegalArgumentException("Old entity is the same as the new entity");
        }
        CompoundNBT copiedNBT = oldEntity.func_189511_e(new CompoundNBT());
        copiedNBT.func_186854_a("UUID", newEntity.func_110124_au());
        if (oldEntity instanceof LivingEntity && newEntity instanceof LivingEntity) {
            LivingEntity newLiving = (LivingEntity)newEntity;
            if (resetAttributes) {
                copiedNBT.func_218657_a("Attributes", (INBT)newLiving.func_233645_dx_().func_233794_c_());
                copiedNBT.func_74776_a("Health", newLiving.func_110143_aJ());
            }
            if (oldEntity.func_96124_cp() != null) {
                copiedNBT.func_74778_a("Team", oldEntity.func_96124_cp().func_96661_b());
            }
            if (copiedNBT.func_150297_b("ActiveEffects", 9)) {
                ListNBT listnbt = copiedNBT.func_150295_c("ActiveEffects", 10);
                for (int i = 0; i < listnbt.size(); ++i) {
                    CompoundNBT compoundnbt = listnbt.func_150305_b(i);
                    EffectInstance effectinstance = EffectInstance.func_82722_b((CompoundNBT)compoundnbt);
                    if (newLiving.func_70687_e(effectinstance)) continue;
                    listnbt.remove(i);
                }
            }
        }
        copiedNBT.func_74778_a("id", newEntity.func_70022_Q());
        newEntity.deserializeNBT(copiedNBT);
    }

    public static void spawnParticlesAtEntity(Entity entity, IParticleData particleData, int amount) {
        for (int i = 0; i < amount; ++i) {
            double posX = entity.func_226277_ct_() + (double)(entity.field_70170_p.field_73012_v.nextFloat() * entity.func_213311_cf() * 2.0f) - (double)entity.func_213311_cf();
            double posY = entity.func_226278_cu_() + 0.5 + (double)(entity.field_70170_p.field_73012_v.nextFloat() * entity.func_213302_cg());
            double posZ = entity.func_226281_cx_() + (double)(entity.field_70170_p.field_73012_v.nextFloat() * entity.func_213311_cf() * 2.0f) - (double)entity.func_213311_cf();
            double x = entity.field_70170_p.field_73012_v.nextGaussian() * 0.02;
            double y = entity.field_70170_p.field_73012_v.nextGaussian() * 0.02;
            double z = entity.field_70170_p.field_73012_v.nextGaussian() * 0.02;
            entity.field_70170_p.func_195594_a(particleData, posX, posY, posZ, x, y, z);
        }
    }

    public static void spawnEndersoulParticles(Entity entity, int amount, float speed) {
        for (int i = 0; i < amount; ++i) {
            float f = (entity.field_70170_p.field_73012_v.nextFloat() - 0.5f) * speed;
            float f1 = (entity.field_70170_p.field_73012_v.nextFloat() - 0.5f) * speed;
            float f2 = (entity.field_70170_p.field_73012_v.nextFloat() - 0.5f) * speed;
            double tempX = entity.func_226277_ct_() + (double)((entity.field_70170_p.field_73012_v.nextFloat() - 0.5f) * entity.func_213311_cf());
            double tempY = entity.func_226278_cu_() + (double)((entity.field_70170_p.field_73012_v.nextFloat() - 0.5f) * entity.func_213302_cg()) + 0.5;
            double tempZ = entity.func_226281_cx_() + (double)((entity.field_70170_p.field_73012_v.nextFloat() - 0.5f) * entity.func_213311_cf());
            entity.field_70170_p.func_195594_a((IParticleData)MBParticleTypes.ENDERSOUL, tempX, tempY, tempZ, (double)f, (double)f1, (double)f2);
        }
    }

    public static void sendParticlePacket(Entity entity, IParticleData particleData, int amount) {
        MBPacketHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 1024.0, entity.field_70170_p.func_234923_W_())), (Object)new SpawnParticlePacket(particleData, entity.func_145782_y(), amount));
    }

    public static Vector3d getDirVector(float rotation, float scale) {
        float rad = rotation * ((float)Math.PI / 180);
        return new Vector3d((double)(-MathHelper.func_76126_a((float)rad) * scale), 0.0, (double)(MathHelper.func_76134_b((float)rad) * scale));
    }

    public static boolean teleportTo(MobEntity mob, double x, double y, double z) {
        double oldX = mob.func_226277_ct_();
        double oldY = mob.func_226278_cu_();
        double oldZ = mob.func_226281_cx_();
        double newY = y;
        BlockPos pos = new BlockPos(x, y, z);
        boolean success = false;
        if (mob.field_70170_p.func_195588_v(pos)) {
            boolean temp = false;
            while (!temp && pos.func_177956_o() > 0) {
                BlockPos posDown = pos.func_177977_b();
                if (mob.field_70170_p.func_180495_p(posDown).func_185904_a().func_76230_c()) {
                    temp = true;
                    continue;
                }
                newY -= 1.0;
                pos = posDown;
            }
            if (temp) {
                mob.func_70107_b(x, newY, z);
                if (mob.field_70170_p.func_226669_j_((Entity)mob) && !mob.field_70170_p.func_72953_d(mob.func_174813_aQ())) {
                    success = true;
                }
            }
        }
        if (!success) {
            mob.func_70107_b(oldX, oldY, oldZ);
            return false;
        }
        mob.func_70661_as().func_75499_g();
        return true;
    }

    public static void divertAttackers(MobEntity targetedMob, LivingEntity newTarget) {
        if (targetedMob == newTarget) {
            return;
        }
        for (MobEntity attacker : targetedMob.field_70170_p.func_217357_a(MobEntity.class, targetedMob.func_174813_aQ().func_72314_b(16.0, 10.0, 16.0))) {
            if (attacker == targetedMob || attacker.func_70638_az() != targetedMob) continue;
            attacker.func_70624_b(newTarget);
        }
    }

    public static boolean isBlockUnbreakable(BlockState blockState) {
        return blockState.func_185887_b(null, null) == -1.0f;
    }
}

