/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.util;

import chumbanotz.mutantbeasts.entity.ai.goal.TrackSummonerGoal;
import chumbanotz.mutantbeasts.entity.mutant.MutantZombieEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class ZombieResurrection
extends BlockPos {
    private int tick;

    public ZombieResurrection(World world, int x, int y, int z) {
        super(x, y, z);
        this.tick = 100 + world.field_73012_v.nextInt(40);
    }

    public ZombieResurrection(World world, BlockPos pos, int tick) {
        super((Vector3i)pos);
        this.tick = tick;
    }

    public int getTick() {
        return this.tick;
    }

    public boolean update(MutantZombieEntity mutantZombie) {
        World world = mutantZombie.field_70170_p;
        if (world.func_175623_d((BlockPos)this)) {
            return false;
        }
        if (mutantZombie.func_70681_au().nextInt(15) == 0) {
            world.func_217379_c(2001, this.func_177984_a(), Block.func_196246_j((BlockState)world.func_180495_p((BlockPos)this)));
        }
        if (--this.tick <= 0) {
            ZombieEntity zombieEntity = (ZombieEntity)ZombieResurrection.getZombieByLocation(world, this).func_200721_a(world);
            ILivingEntityData ilivingentitydata = null;
            ilivingentitydata = zombieEntity.func_213386_a((IWorld)world, world.func_175649_E((BlockPos)this), SpawnReason.MOB_SUMMONED, ilivingentitydata, null);
            zombieEntity.func_70606_j(zombieEntity.func_110138_aP() * (0.6f + 0.4f * zombieEntity.func_70681_au().nextFloat()));
            zombieEntity.func_70642_aH();
            zombieEntity.func_184210_p();
            world.func_217379_c(2001, this.func_177984_a(), Block.func_196246_j((BlockState)world.func_180495_p((BlockPos)this)));
            if (!world.field_72995_K) {
                zombieEntity.func_174828_a(this.func_177984_a(), mutantZombie.field_70177_z, mutantZombie.field_70125_A);
                zombieEntity.field_70714_bg.func_75776_a(0, (Goal)new TrackSummonerGoal(zombieEntity, mutantZombie));
                zombieEntity.field_70714_bg.func_75776_a(3, (Goal)new MoveTowardsRestrictionGoal((CreatureEntity)zombieEntity, 1.0));
                world.func_217376_c((Entity)zombieEntity);
            }
            if (mutantZombie.func_96124_cp() != null) {
                Scoreboard scoreboard = world.func_96441_U();
                scoreboard.func_197901_a(zombieEntity.func_195047_I_(), scoreboard.func_96508_e(mutantZombie.func_96124_cp().func_96661_b()));
            }
            return false;
        }
        return true;
    }

    public static int getSuitableGround(World world, int x, int y, int z) {
        return ZombieResurrection.getSuitableGround(world, x, y, z, 4, true);
    }

    public static int getSuitableGround(World world, int x, int y, int z, int range, boolean checkDay) {
        BlockPos.Mutable mutable = new BlockPos.Mutable(x, y, z);
        int i = y;
        while (Math.abs(y - i) <= range) {
            mutable.func_181079_c(x, i, z);
            BlockPos posUp = mutable.func_177984_a();
            BlockState blockState = world.func_180495_p((BlockPos)mutable);
            if (!blockState.func_235714_a_((ITag)BlockTags.field_232872_am_)) {
                if (checkDay && !world.func_204610_c((BlockPos)mutable).func_206884_a((ITag)FluidTags.field_206960_b) || world.func_204610_c((BlockPos)mutable).func_206888_e()) {
                    if (world.func_175623_d((BlockPos)mutable)) {
                        --i;
                        continue;
                    }
                    if (!world.func_175623_d((BlockPos)mutable) && world.func_175623_d(posUp) && blockState.func_196952_d((IBlockReader)world, (BlockPos)mutable).func_197766_b()) {
                        --i;
                    } else if (!(world.func_175623_d((BlockPos)mutable) || world.func_175623_d(posUp) || world.func_180495_p(posUp).func_196952_d((IBlockReader)world, posUp).func_197766_b())) {
                        ++i;
                        continue;
                    }
                }
                if (checkDay && world.func_72935_r()) {
                    BlockPos lightPos = new BlockPos(x, y + 1, z);
                    float f = world.func_230315_m_().func_236021_a_(world.func_201696_r(lightPos));
                    if (f > 0.5f && world.func_175710_j(lightPos) && world.field_73012_v.nextInt(3) != 0) {
                        return -1;
                    }
                }
                return i;
            }
            return -1;
        }
        return -1;
    }

    public static EntityType<? extends ZombieEntity> getZombieByLocation(World world, BlockPos pos) {
        Biome biome = world.func_226691_t_(pos);
        int chance = world.field_73012_v.nextInt(100);
        if (biome.func_201856_r() == Biome.Category.DESERT) {
            return chance < 80 && world.func_226660_f_(pos) ? EntityType.field_200763_C : (chance < 1 ? EntityType.field_200727_aF : EntityType.field_200725_aD);
        }
        if ((biome.func_201856_r() == Biome.Category.OCEAN || biome.func_201856_r() == Biome.Category.RIVER) && world.func_201671_F(pos.func_177984_a())) {
            return EntityType.field_204724_o;
        }
        return chance < 95 ? EntityType.field_200725_aD : EntityType.field_200727_aF;
    }
}

