/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.tileentity.reprocessor;

import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.util.VanillaPacketDispatcher;
import com.blakebr0.mysticalagriculture.crafting.ReprocessorManager;
import com.blakebr0.mysticalagriculture.util.TileEntityUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.SlotFurnaceFuel;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public abstract class TileEssenceReprocessor
extends TileEntityUtil
implements ISidedInventory,
ITickable,
ICapabilityProvider {
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    private int progress;
    private int fuel;
    private int fuelLeft;
    private int fuelItemValue;
    private int packetCount;
    private boolean packet;

    @Override
    public NBTTagCompound writeCustomNBT(NBTTagCompound tag) {
        tag.func_74768_a("Progress", this.progress);
        tag.func_74768_a("Fuel", this.fuel);
        tag.func_74768_a("FuelLeft", this.fuelLeft);
        tag.func_74768_a("FuelItemValue", this.fuelItemValue);
        ItemStackHelper.func_191282_a((NBTTagCompound)tag, this.inventory);
        return tag;
    }

    @Override
    public void readCustomNBT(NBTTagCompound tag) {
        this.progress = tag.func_74762_e("Progress");
        this.fuel = tag.func_74762_e("Fuel");
        this.fuelLeft = tag.func_74762_e("FuelLeft");
        this.fuelItemValue = tag.func_74762_e("FuelItemValue");
        ItemStackHelper.func_191283_b((NBTTagCompound)tag, this.inventory);
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        boolean mark = false;
        int fuelPerTick = Math.min(Math.min(this.fuelLeft, this.getFuelUsage() * 2), this.getFuelCapacity() - this.fuel);
        if (this.fuel < this.getFuelCapacity()) {
            ItemStack fuel = this.func_70301_a(1);
            if (this.fuelLeft <= 0 && !fuel.func_190926_b()) {
                this.fuelLeft = this.fuelItemValue = TileEntityFurnace.func_145952_a((ItemStack)fuel);
                this.func_70298_a(1, 1);
            }
            if (this.fuelLeft > 0) {
                this.fuel += fuelPerTick;
                this.fuelLeft -= fuelPerTick;
                if (this.fuelLeft <= 0) {
                    this.fuelItemValue = 0;
                }
                mark = true;
            }
        }
        if (this.fuel >= this.getFuelUsage()) {
            ItemStack input = this.func_70301_a(0);
            ItemStack output = this.func_70301_a(2);
            if (!input.func_190926_b()) {
                ItemStack recipeOutput = ReprocessorManager.getOutput(input);
                if (!recipeOutput.func_190926_b() && (output.func_190926_b() || StackHelper.canCombineStacks((ItemStack)output, (ItemStack)recipeOutput))) {
                    ++this.progress;
                    this.fuel -= this.getFuelUsage();
                    if (this.progress >= this.getOperationTime()) {
                        this.func_70298_a(0, 1);
                        if (output.func_190926_b()) {
                            this.func_70299_a(2, recipeOutput.func_77946_l());
                        } else {
                            output.func_190917_f(recipeOutput.func_190916_E());
                        }
                        this.progress = 0;
                    }
                    mark = true;
                }
            } else if (this.progress > 0) {
                this.progress = 0;
                mark = true;
            }
        }
        if (mark) {
            this.func_70296_d();
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers((TileEntity)this);
    }

    public int func_70302_i_() {
        return 3;
    }

    public ItemStack func_70301_a(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    public ItemStack func_70298_a(int slot, int decrement) {
        return ItemStackHelper.func_188382_a(this.inventory, (int)slot, (int)decrement);
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && player.func_174818_b(this.func_174877_v().func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 2) {
            return false;
        }
        if (index != 1) {
            return true;
        }
        ItemStack itemstack = (ItemStack)this.inventory.get(1);
        return TileEntityFurnace.func_145954_b((ItemStack)stack) || SlotFurnaceFuel.func_178173_c_((ItemStack)stack) && itemstack.func_77973_b() != Items.field_151133_ar;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.inventory.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.inventory.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.inventory, (int)index);
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public String func_70005_c_() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] nArray;
        if (side == EnumFacing.UP) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else if (side == EnumFacing.DOWN) {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 1;
        } else {
            int[] nArray4 = new int[2];
            nArray4[0] = 0;
            nArray = nArray4;
            nArray4[1] = 1;
        }
        return nArray;
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing facing) {
        return this.func_94041_b(index, stack);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing facing) {
        return index == 1;
    }

    public boolean func_191420_l() {
        return !this.inventory.stream().anyMatch(s -> !s.func_190926_b());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing side) {
        return this.getCapability(capability, side) != null;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)new SidedInvWrapper((ISidedInventory)this, facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    public int getProgress() {
        return this.progress;
    }

    public abstract int getOperationTime();

    public boolean isWorking() {
        return this.progress > 0 && this.fuelLeft >= this.getFuelUsage();
    }

    public int getFuel() {
        return this.fuel;
    }

    public abstract int getFuelUsage();

    public abstract int getFuelCapacity();

    public int getFuelLeft() {
        return this.fuelLeft;
    }

    public int getFuelItemValue() {
        return this.fuelItemValue;
    }
}

