/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.augment;

import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.mysticalagriculture.api.lib.AbilityCache;
import com.blakebr0.mysticalagriculture.api.tinkering.Augment;
import com.blakebr0.mysticalagriculture.api.tinkering.AugmentType;
import java.util.EnumSet;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class SpeedAugment
extends Augment {
    private final int amplifier;

    public SpeedAugment(ResourceLocation id, int tier, int amplifier) {
        super(id, tier, EnumSet.of(AugmentType.LEGGINGS), SpeedAugment.getColor(11358797, tier), SpeedAugment.getColor(2361349, tier));
        this.amplifier = amplifier;
    }

    @Override
    public void onPlayerTick(World world, PlayerEntity player, AbilityCache cache) {
        boolean flying = player.field_71075_bZ.field_75100_b;
        boolean swimming = player.func_203007_ba();
        if (player.field_70122_E || flying || swimming) {
            boolean sneaking = player.func_70093_af();
            boolean sprinting = player.func_70051_ag();
            float speed = 0.1f * (flying ? 0.6f : 1.0f) * (sneaking ? 0.1f : 1.0f) * (!sprinting ? 0.6f : 1.2f) * (float)this.amplifier;
            if (player.field_191988_bg > 0.0f) {
                player.func_213309_a(1.0f, new Vec3d(0.0, 0.0, (double)speed));
            } else if (player.field_191988_bg < 0.0f) {
                player.func_213309_a(1.0f, new Vec3d(0.0, 0.0, (double)(-speed * 0.3f)));
            }
            if (player.field_70702_br != 0.0f) {
                player.func_213309_a(1.0f, new Vec3d((double)(speed * 0.5f * Math.signum(player.field_70702_br)), 0.0, 0.0));
            }
        }
    }

    private static int getColor(int color, int tier) {
        return Utils.saturate((int)color, (float)Math.min((float)tier / 4.0f, 1.0f));
    }
}

