/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture;

import com.blakebr0.cucumber.helper.ConfigHelper;
import com.blakebr0.mysticalagriculture.MAItemGroup;
import com.blakebr0.mysticalagriculture.api.MysticalAgricultureAPI;
import com.blakebr0.mysticalagriculture.client.ModelHandler;
import com.blakebr0.mysticalagriculture.config.ModConfigs;
import com.blakebr0.mysticalagriculture.crafting.DynamicRecipeManager;
import com.blakebr0.mysticalagriculture.data.ModDataGenerators;
import com.blakebr0.mysticalagriculture.handler.AugmentHandler;
import com.blakebr0.mysticalagriculture.handler.ColorHandler;
import com.blakebr0.mysticalagriculture.handler.ExperienceCapsuleHandler;
import com.blakebr0.mysticalagriculture.handler.MobDropHandler;
import com.blakebr0.mysticalagriculture.handler.MobSoulHandler;
import com.blakebr0.mysticalagriculture.init.ModBlocks;
import com.blakebr0.mysticalagriculture.init.ModContainerTypes;
import com.blakebr0.mysticalagriculture.init.ModItems;
import com.blakebr0.mysticalagriculture.init.ModRecipeSerializers;
import com.blakebr0.mysticalagriculture.init.ModTileEntities;
import com.blakebr0.mysticalagriculture.lib.ModCorePlugin;
import com.blakebr0.mysticalagriculture.network.NetworkHandler;
import com.blakebr0.mysticalagriculture.registry.AugmentRegistry;
import com.blakebr0.mysticalagriculture.registry.CropRegistry;
import com.blakebr0.mysticalagriculture.registry.MobSoulTypeRegistry;
import com.blakebr0.mysticalagriculture.registry.PluginRegistry;
import com.blakebr0.mysticalagriculture.world.ModWorldFeatures;
import net.minecraft.item.ItemGroup;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="mysticalagriculture")
public final class MysticalAgriculture {
    public static final String MOD_ID = "mysticalagriculture";
    public static final String NAME = "Mystical Agriculture";
    public static final ItemGroup ITEM_GROUP = new MAItemGroup();

    public MysticalAgriculture() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.register((Object)this);
        bus.register((Object)new ModBlocks());
        bus.register((Object)new ModItems());
        bus.register((Object)new ModRecipeSerializers());
        bus.register((Object)new ModTileEntities());
        bus.register((Object)new ModContainerTypes());
        bus.register((Object)new ModDataGenerators());
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            bus.register((Object)new ColorHandler());
            bus.register((Object)new ModelHandler());
        });
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, ModConfigs.CLIENT);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ModConfigs.COMMON);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, ModConfigs.SERVER);
        PluginRegistry.getInstance().loadPlugins();
        MysticalAgricultureAPI.setCropRegistry(CropRegistry.getInstance());
        MysticalAgricultureAPI.setAugmentRegistry(AugmentRegistry.getInstance());
        MysticalAgricultureAPI.setMobSoulTypeRegistry(MobSoulTypeRegistry.getInstance());
        ConfigHelper.load((ForgeConfigSpec)ModConfigs.COMMON, (String)"mysticalagriculture-common.toml");
    }

    @SubscribeEvent
    public void onCommonSetup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new DynamicRecipeManager());
        MinecraftForge.EVENT_BUS.register((Object)new MobDropHandler());
        MinecraftForge.EVENT_BUS.register((Object)new MobSoulHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ExperienceCapsuleHandler());
        MinecraftForge.EVENT_BUS.register((Object)new AugmentHandler());
        ModCorePlugin.onCommonSetup();
        ModRecipeSerializers.onCommonSetup();
        DeferredWorkQueue.runLater(() -> {
            ModWorldFeatures.onCommonSetup();
            NetworkHandler.onCommonSetup();
        });
    }

    @SubscribeEvent
    public void onClientSetup(FMLClientSetupEvent event) {
        ModelHandler.onClientSetup();
        ModTileEntities.onClientSetup();
        ModContainerTypes.onClientSetup();
    }
}

