/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.data;

import com.blakebr0.mysticalagriculture.api.crop.CropType;
import com.blakebr0.mysticalagriculture.registry.AugmentRegistry;
import com.blakebr0.mysticalagriculture.registry.CropRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.CropsBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ExistingFileHelper;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;

public final class ModelJsonGenerator {

    public static class Items
    extends ItemModelProvider {
        public Items(DataGenerator generator, String modid, ExistingFileHelper existingFileHelper) {
            super(generator, modid, existingFileHelper);
        }

        protected void registerModels() {
            ModelFile.UncheckedModelFile generatedModel = new ModelFile.UncheckedModelFile("item/generated");
            CropRegistry.getInstance().getCrops().forEach(crop -> {
                ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(crop.getNameWithSuffix("essence"))).parent((ModelFile)generatedModel)).texture("layer0", crop.getTextures().getEssenceTexture());
                ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(crop.getNameWithSuffix("seeds"))).parent((ModelFile)generatedModel)).texture("layer0", crop.getTextures().getSeedTexture());
            });
            ModelFile.UncheckedModelFile augmentModel = new ModelFile.UncheckedModelFile(new ResourceLocation("mysticalagriculture", "item/augment"));
            AugmentRegistry.getInstance().getAugments().forEach(augment -> ((ItemModelBuilder)this.getBuilder(augment.getNameWithSuffix("augment"))).parent((ModelFile)augmentModel));
        }

        public String func_200397_b() {
            return "Mystical Agriculture item model generator";
        }
    }

    public static class Blocks
    extends BlockStateProvider {
        public Blocks(DataGenerator generator, String modid, ExistingFileHelper existingFileHelper) {
            super(generator, modid, existingFileHelper);
        }

        protected void registerStatesAndModels() {
            ModelFile[] resourceCrops = new ModelFile[7];
            ModelFile[] mobCrops = new ModelFile[7];
            for (int i = 0; i < 7; ++i) {
                resourceCrops[i] = new ModelFile.UncheckedModelFile(new ResourceLocation("mysticalagriculture", "block/mystical_resource_crop_" + i));
                mobCrops[i] = new ModelFile.UncheckedModelFile(new ResourceLocation("mysticalagriculture", "block/mystical_mob_crop_" + i));
            }
            ModelFile.UncheckedModelFile resourceCropModel = new ModelFile.UncheckedModelFile(new ResourceLocation("mysticalagriculture", "block/mystical_resource_crop_7"));
            ModelFile.UncheckedModelFile mobCropModel = new ModelFile.UncheckedModelFile(new ResourceLocation("mysticalagriculture", "block/mystical_mob_crop_7"));
            CropRegistry.getInstance().getCrops().forEach(crop -> {
                CropsBlock block = crop.getCrop();
                if (crop.getType() == CropType.MOB) {
                    this.getVariantBuilder((Block)block).forAllStates(state -> {
                        Integer age = (Integer)state.func_177229_b((Property)CropsBlock.field_176488_a);
                        if (age.intValue() == block.func_185526_g()) {
                            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(crop.getNameWithSuffix("crop"))).parent((ModelFile)mobCropModel)).texture("flower", crop.getTextures().getFlowerTexture());
                            return ConfiguredModel.builder().modelFile((ModelFile)model).build();
                        }
                        return ConfiguredModel.builder().modelFile(mobCrops[age]).build();
                    });
                } else {
                    this.getVariantBuilder((Block)block).forAllStates(state -> {
                        Integer age = (Integer)state.func_177229_b((Property)CropsBlock.field_176488_a);
                        if (age.intValue() == block.func_185526_g()) {
                            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(crop.getNameWithSuffix("crop"))).parent((ModelFile)resourceCropModel)).texture("flower", crop.getTextures().getFlowerTexture());
                            return ConfiguredModel.builder().modelFile((ModelFile)model).build();
                        }
                        return ConfiguredModel.builder().modelFile(resourceCrops[age]).build();
                    });
                }
            });
        }

        public String func_200397_b() {
            return "Mystical Agriculture block model generator";
        }
    }
}

