/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.registry;

import com.blakebr0.mysticalagriculture.api.IMysticalAgriculturePlugin;
import com.blakebr0.mysticalagriculture.api.MysticalAgriculturePlugin;
import com.blakebr0.mysticalagriculture.lib.ModCorePlugin;
import com.blakebr0.mysticalagriculture.registry.MobSoulTypeRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraftforge.fml.ModList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class PluginRegistry {
    private static final Logger LOGGER = LogManager.getLogger((String)"Mystical Agriculture");
    private static final PluginRegistry INSTANCE = new PluginRegistry();
    private final List<IMysticalAgriculturePlugin> plugins = new ArrayList<IMysticalAgriculturePlugin>();

    public void loadPlugins() {
        this.plugins.add(new ModCorePlugin());
        LOGGER.info("Registered plugin: {}", (Object)ModCorePlugin.class.getName());
        ModList.get().getAllScanData().forEach((? super T data) -> data.getAnnotations().forEach((? super T annotation) -> {
            if (annotation.getAnnotationType().getClassName().equals(MysticalAgriculturePlugin.class.getName())) {
                try {
                    Class<?> clazz = Class.forName(annotation.getMemberName());
                    if (IMysticalAgriculturePlugin.class.isAssignableFrom(clazz)) {
                        IMysticalAgriculturePlugin plugin = (IMysticalAgriculturePlugin)clazz.newInstance();
                        this.plugins.add(plugin);
                        LOGGER.info("Registered plugin: {}", (Object)annotation.getMemberName());
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error loading plugin: {}", (Object)annotation.getMemberName(), (Object)e);
                }
            }
        }));
        this.plugins.forEach((? super T plugin) -> plugin.onRegisterMobSoulTypes(MobSoulTypeRegistry.getInstance()));
        this.plugins.forEach((? super T plugin) -> plugin.onPostRegisterMobSoulTypes(MobSoulTypeRegistry.getInstance()));
    }

    public void forEach(Consumer<IMysticalAgriculturePlugin> action) {
        this.plugins.forEach(action);
    }

    public static PluginRegistry getInstance() {
        return INSTANCE;
    }
}

