/*
 * Decompiled with CFR 0.152.
 */
package com.endlesnights.naturalslabsmod;

import com.endlesnights.naturalslabsmod.INaturalSlabsCompat;
import com.endlesnights.naturalslabsmod.WorldTickHandler;
import com.endlesnights.naturalslabsmod.config.Config;
import com.endlesnights.naturalslabsmod.events.FallEvent;
import com.endlesnights.naturalslabsmod.init.ModBlocks;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod(value="naturalslabsmod")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class NaturalSlabsMod {
    public static final String MODID = "naturalslabsmod";
    public static final String NAME = "Natural Slabs Mod";
    private static List<Supplier<INaturalSlabsCompat>> compatList = new ArrayList<Supplier<INaturalSlabsCompat>>();
    public static NaturalSlabsMod instance;
    public final ItemGroup creativeTab;

    public NaturalSlabsMod() {
        instance = this;
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, Config.SERVER, "naturalslabsmod-server.toml");
        Config.loadConfig(Config.SERVER, FMLPaths.CONFIGDIR.get().resolve("naturalslabsmod-server.toml").toString());
        this.creativeTab = new CreativeTab();
        compatList.add(ModBlocks::new);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::loadComplete);
        MinecraftForge.EVENT_BUS.register((Object)new WorldTickHandler());
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new FallEvent());
    }

    @SubscribeEvent
    public static void onRegisterBiome(RegistryEvent.Register<Biome> event) {
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        for (Supplier<INaturalSlabsCompat> compat : compatList) {
            compat.get().registerBlocks(event);
        }
    }

    @SubscribeEvent
    public static void onInterModEnqueue(InterModEnqueueEvent event) {
        for (Supplier<INaturalSlabsCompat> compat : compatList) {
            compat.get().registerPlaceEntries();
        }
    }

    public ItemGroup getTab() {
        return this.creativeTab;
    }

    private class CreativeTab
    extends ItemGroup {
        public CreativeTab() {
            super(NaturalSlabsMod.MODID);
        }

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)ModBlocks.block_grass_slab);
        }
    }
}

