/*
 * Decompiled with CFR 0.152.
 */
package com.endlesnights.naturalslabsmod;

import com.endlesnights.naturalslabsmod.blocks.slabs.BlockSnowSlab;
import com.endlesnights.naturalslabsmod.blocks.slabs.BlockSnowStairs;
import com.endlesnights.naturalslabsmod.init.ModBlocks;
import java.lang.reflect.Method;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SnowBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.LightType;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.apache.logging.log4j.LogManager;

public class WorldTickHandler {
    boolean stackingSnow = false;
    int randLCG = new Random().nextInt();

    @SubscribeEvent
    public void worldTickEvent(WorldEvent event) {
        ServerWorld world;
        if (event.getWorld() instanceof ServerWorld && (world = (ServerWorld)event.getWorld()).func_72896_J()) {
            try {
                Method getChunkHolderIterator = ObfuscationReflectionHelper.findMethod(ChunkManager.class, (String)"func_223491_f", (Class[])new Class[0]);
                getChunkHolderIterator.setAccessible(true);
                Iterable chunkContainer = (Iterable)getChunkHolderIterator.invoke((Object)world.func_72863_F().field_217237_a, new Object[0]);
                if (world.field_73012_v.nextInt(16) > 0) {
                    return;
                }
                for (ChunkHolder chunkHolder : chunkContainer) {
                    Chunk chunk = chunkHolder.func_219298_c();
                    if (chunk == null || !world.func_72863_F().func_222865_a(chunk.func_76632_l())) continue;
                    int chunk_min_x = chunk.func_76632_l().func_180334_c();
                    int chunk_min_y = chunk.func_76632_l().func_180333_d();
                    if (!world.field_73011_w.canDoRainSnowIce(chunk) || world.field_73012_v.nextInt(64) != 0) continue;
                    this.randLCG = this.randLCG * 3 + 1013904223;
                    int j2 = this.randLCG >> 2;
                    BlockPos pos = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, new BlockPos(chunk_min_x + (j2 & 0xF), 0, chunk_min_y + (j2 >> 8 & 0xF))).func_177977_b();
                    BlockState state = world.func_180495_p(pos);
                    if (pos.func_177956_o() < 0 || pos.func_177956_o() >= 256 || world.func_226658_a_(LightType.BLOCK, pos) >= 10 || !(world.func_226691_t_(pos).func_225486_c(pos) < 0.15f)) continue;
                    if (this.stackingSnow && state.func_177230_c() instanceof SnowBlock) {
                        int height = (Integer)state.func_177229_b((IProperty)SnowBlock.field_176315_a);
                        if (height == 8) {
                            return;
                        }
                        BlockState north = world.func_180495_p(pos.func_177978_c());
                        BlockState south = world.func_180495_p(pos.func_177968_d());
                        BlockState east = world.func_180495_p(pos.func_177974_f());
                        BlockState west = world.func_180495_p(pos.func_177976_e());
                        float surroundings = 0.0f;
                        if (north.func_177230_c() instanceof SnowBlock) {
                            surroundings += (float)((Integer)north.func_177229_b((IProperty)SnowBlock.field_176315_a)).intValue();
                        } else if (north.func_200132_m()) {
                            surroundings += 8.0f;
                        }
                        if (south.func_177230_c() instanceof SnowBlock) {
                            surroundings += (float)((Integer)south.func_177229_b((IProperty)SnowBlock.field_176315_a)).intValue();
                        } else if (south.func_200132_m()) {
                            surroundings += 8.0f;
                        }
                        if (east.func_177230_c() instanceof SnowBlock) {
                            surroundings += (float)((Integer)east.func_177229_b((IProperty)SnowBlock.field_176315_a)).intValue();
                        } else if (east.func_200132_m()) {
                            surroundings += 8.0f;
                        }
                        if (west.func_177230_c() instanceof SnowBlock) {
                            surroundings += (float)((Integer)west.func_177229_b((IProperty)SnowBlock.field_176315_a)).intValue();
                        } else if (west.func_200132_m()) {
                            surroundings += 8.0f;
                        }
                        if (!((surroundings /= 4.0f) >= (float)height)) continue;
                        float weight = (surroundings - (float)height) / 2.0f + 0.05f;
                        if (!(world.field_73012_v.nextFloat() <= weight)) continue;
                        world.func_175656_a(pos, (BlockState)Blocks.field_150433_aE.func_176223_P().func_206870_a((IProperty)SnowBlock.field_176315_a, (Comparable)Integer.valueOf(height + 1)));
                        continue;
                    }
                    if (world.func_180495_p(pos).func_177230_c() instanceof SlabBlock && world.func_180495_p(pos).func_177229_b((IProperty)SlabBlock.field_196505_a) == SlabType.BOTTOM) {
                        if (this.stackingSnow && world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockSnowSlab) {
                            world.func_175656_a(pos.func_177984_a(), (BlockState)ModBlocks.block_snow_slab.func_176223_P().func_206870_a((IProperty)BlockSnowSlab.LAYERS, (Comparable)Integer.valueOf((Integer)world.func_180495_p(pos.func_177984_a()).func_177229_b((IProperty)BlockSnowSlab.LAYERS) + 1)));
                            continue;
                        }
                        world.func_175656_a(pos.func_177984_a(), ModBlocks.block_snow_slab.func_176223_P());
                        continue;
                    }
                    if (!(world.func_180495_p(pos).func_177230_c() instanceof StairsBlock) || world.func_180495_p(pos).func_177229_b((IProperty)StairsBlock.field_176308_b) != Half.BOTTOM) continue;
                    if (this.stackingSnow && world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockSnowStairs) {
                        world.func_175656_a(pos.func_177984_a(), (BlockState)((BlockState)((BlockState)ModBlocks.block_snow_stair.func_176223_P().func_206870_a((IProperty)StairsBlock.field_176309_a, world.func_180495_p(pos).func_177229_b((IProperty)StairsBlock.field_176309_a))).func_206870_a((IProperty)StairsBlock.field_176310_M, world.func_180495_p(pos).func_177229_b((IProperty)StairsBlock.field_176310_M))).func_206870_a((IProperty)BlockSnowSlab.LAYERS, (Comparable)Integer.valueOf((Integer)world.func_180495_p(pos.func_177984_a()).func_177229_b((IProperty)BlockSnowSlab.LAYERS) + 1)));
                        continue;
                    }
                    world.func_175656_a(pos.func_177984_a(), (BlockState)((BlockState)ModBlocks.block_snow_stair.func_176223_P().func_206870_a((IProperty)StairsBlock.field_176309_a, world.func_180495_p(pos).func_177229_b((IProperty)StairsBlock.field_176309_a))).func_206870_a((IProperty)StairsBlock.field_176310_M, world.func_180495_p(pos).func_177229_b((IProperty)StairsBlock.field_176310_M)));
                }
            }
            catch (Exception ex) {
                LogManager.getLogger().fatal("COULD NOT ACCESS LOADED CHUNKS!");
                LogManager.getLogger().fatal(ex.getMessage());
            }
        }
    }
}

