/*
 * Decompiled with CFR 0.152.
 */
package com.endlesnights.naturalslabsmod.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.HoeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.ShovelItem;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="naturalslabsmod", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class TutorialBlock
extends Block {
    public TutorialBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151577_b).func_200944_c().func_200943_b(0.6f).func_200947_a(SoundType.field_185850_c));
        this.func_180632_j((BlockState)this.field_176227_L.func_177621_b());
        this.setRegistryName("naturalslabsmod", "tutorial_block");
    }

    public void func_225534_a_(BlockState blockState, ServerWorld world, BlockPos blockPos, Random random) {
        super.func_225534_a_(blockState, world, blockPos, random);
    }

    public boolean isToolEffective(BlockState state, ToolType tool) {
        return tool == ToolType.SHOVEL;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult p_225533_6_) {
        ItemStack itemStack = playerIn.func_184586_b(hand);
        if (itemStack.func_77973_b() instanceof HoeItem && !worldIn.field_72995_K) {
            return TutorialBlock.onItemUseHoe(state, worldIn, pos, playerIn, hand, p_225533_6_);
        }
        if (itemStack.func_77973_b() instanceof ShovelItem && !worldIn.field_72995_K) {
            return TutorialBlock.onItemUseSpade(state, worldIn, pos, playerIn, hand, p_225533_6_);
        }
        return ActionResultType.FAIL;
    }

    public boolean Test() {
        return false;
    }

    public static ActionResultType onItemUseHoe(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult p_225533_6_) {
        BlockState blockstate;
        ItemUseContext context = new ItemUseContext(playerIn, hand, p_225533_6_);
        World world = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        if (context.func_196000_l() != Direction.DOWN && world.func_180495_p(blockpos.func_177984_a()).func_196958_f() && (blockstate = Blocks.field_150458_ak.func_176223_P()) != null) {
            PlayerEntity playerentity = context.func_195999_j();
            world.func_184133_a(playerentity, blockpos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
            world.func_175656_a(blockpos, blockstate);
            if (playerentity != null) {
                context.func_195996_i().func_222118_a(1, (LivingEntity)playerentity, p_220043_1_ -> p_220043_1_.func_213334_d(context.func_221531_n()));
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public static ActionResultType onItemUseSpade(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult p_225533_6_) {
        BlockState blockstate;
        ItemUseContext context = new ItemUseContext(playerIn, hand, p_225533_6_);
        World world = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        if (context.func_196000_l() != Direction.DOWN && world.func_180495_p(blockpos.func_177984_a()).func_196958_f() && (blockstate = Blocks.field_185774_da.func_176223_P()) != null) {
            PlayerEntity playerentity = context.func_195999_j();
            world.func_184133_a(playerentity, blockpos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
            world.func_175656_a(blockpos, blockstate);
            if (playerentity != null) {
                context.func_195996_i().func_222118_a(1, (LivingEntity)playerentity, p_220043_1_ -> p_220043_1_.func_213334_d(context.func_221531_n()));
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public void grassGrow(BlockState blockState, World world, BlockPos blockPos, Random random) {
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos check;
                    if (x == 0 && y == 0 & z == 0 || random.nextInt(10) != 0 || world.func_180495_p(check = blockPos.func_177982_a(x, y, z)).func_177230_c() != Blocks.field_196658_i || !world.func_180495_p(blockPos.func_177984_a()).func_196958_f()) continue;
                    world.func_175656_a(blockPos, Blocks.field_196658_i.func_176223_P());
                }
            }
        }
    }

    public boolean canSustainPlant(BlockState state, IBlockReader world, BlockPos pos, Direction facing, IPlantable plantable) {
        BlockState plant = plantable.getPlant(world, pos.func_177972_a(facing));
        if (plant.func_177230_c() == Blocks.field_196608_cF) {
            if (world.func_204610_c(pos.func_177982_a(1, 0, 0)).func_206884_a(FluidTags.field_206959_a)) {
                return true;
            }
            if (world.func_204610_c(pos.func_177982_a(-1, 0, 0)).func_206884_a(FluidTags.field_206959_a)) {
                return true;
            }
            if (world.func_204610_c(pos.func_177982_a(0, 0, 1)).func_206884_a(FluidTags.field_206959_a)) {
                return true;
            }
            return world.func_204610_c(pos.func_177982_a(1, 0, -1)).func_206884_a(FluidTags.field_206959_a);
        }
        if (plant.func_177230_c() == Blocks.field_222404_kP || plant.func_177230_c() == Blocks.field_222405_kQ) {
            return true;
        }
        return super.canSustainPlant(Blocks.field_196658_i.func_176223_P(), world, pos, facing, plantable);
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        System.out.println("\nFALL DISTANCE: " + fallDistance);
        super.func_180658_a(worldIn, pos, entityIn, fallDistance /= 2.0f);
    }
}

