/*
 * Decompiled with CFR 0.152.
 */
package com.endlesnights.naturalslabsmod.blocks.slabs;

import com.endlesnights.naturalslabsmod.blocks.slabs.BlockFarmlandSlab;
import com.endlesnights.naturalslabsmod.init.ModBlocks;
import com.endlesnights.naturalslabsmod.placehandler.SlabHelper;
import com.endlesnights.naturalslabsmod.util.SlabAction;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SnowBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.HoeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShovelItem;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.SlabType;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.lighting.LightEngine;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="naturalslabsmod", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class BlockDirtSlab
extends SlabBlock
implements IWaterLoggable {
    private static final VoxelShape BOTTOM_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape TOP_SHAPE = Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public BlockDirtSlab() {
        super(Block.Properties.func_200950_a((Block)Blocks.field_150346_d).func_200944_c());
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)SlabBlock.field_196505_a, (Comparable)SlabType.BOTTOM)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public void func_225534_a_(BlockState blockState, ServerWorld world, BlockPos blockPos, Random random) {
        super.func_225534_a_(blockState, world, blockPos, random);
        this.SpreadableSnowyDirtBlock(blockState, world, blockPos, random);
    }

    private void SpreadableSnowyDirtBlock(BlockState state, ServerWorld world, BlockPos blockPos, Random random) {
        if (!BlockDirtSlab.func_220257_b(state, (IWorldReader)world, blockPos)) {
            return;
        }
        if (world.func_201696_r(blockPos.func_177984_a()) >= 9) {
            BlockState blockstate = this.func_176223_P();
            for (int i = 0; i < 4; ++i) {
                BlockPos blockpos = blockPos.func_177982_a(random.nextInt(3) - 1, 3 - random.nextInt(5), random.nextInt(3) - 1);
                if (world.func_180495_p(blockpos).func_177230_c() != Blocks.field_196658_i || !BlockDirtSlab.func_220256_c(blockstate, (IWorldReader)world, blockpos)) continue;
                if (world.func_180495_p(blockPos).func_177229_b((IProperty)SlabBlock.field_196505_a) == SlabType.TOP && world.func_180495_p(blockPos.func_177984_a()).func_204520_s() != Fluids.field_204546_a) {
                    blockstate = (BlockState)ModBlocks.block_grass_slab.func_176223_P().func_206870_a((IProperty)SlabBlock.field_196505_a, (Comparable)SlabType.TOP);
                    world.func_175656_a(blockPos, blockstate);
                    continue;
                }
                if (world.func_180495_p(blockPos).func_177229_b((IProperty)SlabBlock.field_196505_a) != SlabType.BOTTOM || ((Boolean)world.func_180495_p(blockPos).func_177229_b((IProperty)WATERLOGGED)).booleanValue()) continue;
                blockstate = ModBlocks.block_grass_slab.func_176223_P();
                world.func_175656_a(blockPos, blockstate);
            }
        }
    }

    private static boolean func_220257_b(BlockState state, IWorldReader reader, BlockPos pos) {
        BlockPos blockpos = pos.func_177984_a();
        BlockState blockstate = reader.func_180495_p(blockpos);
        if (blockstate.func_177230_c() == Blocks.field_150433_aE && (Integer)blockstate.func_177229_b((IProperty)SnowBlock.field_176315_a) == 1) {
            return true;
        }
        int i = LightEngine.func_215613_a((IBlockReader)reader, (BlockState)state, (BlockPos)pos, (BlockState)blockstate, (BlockPos)blockpos, (Direction)Direction.UP, (int)blockstate.func_200016_a((IBlockReader)reader, blockpos));
        if (state.func_177230_c() == ModBlocks.block_dirt_slab && state.func_177229_b((IProperty)SlabBlock.field_196505_a) == SlabType.TOP) {
            i = LightEngine.func_215613_a((IBlockReader)reader, (BlockState)Blocks.field_196658_i.func_176223_P(), (BlockPos)pos, (BlockState)blockstate, (BlockPos)blockpos, (Direction)Direction.UP, (int)blockstate.func_200016_a((IBlockReader)reader, blockpos));
        }
        return i < reader.func_201572_C();
    }

    private static boolean func_220256_c(BlockState p_220256_0_, IWorldReader p_220256_1_, BlockPos p_220256_2_) {
        BlockPos blockpos = p_220256_2_.func_177984_a();
        return BlockDirtSlab.func_220257_b(p_220256_0_, p_220256_1_, p_220256_2_) && !p_220256_1_.func_204610_c(blockpos).func_206884_a(FluidTags.field_206959_a);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{SlabBlock.field_196505_a, WATERLOGGED});
    }

    public boolean func_220074_n(BlockState state) {
        return state.func_177229_b((IProperty)SlabBlock.field_196505_a) != SlabType.DOUBLE;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        SlabType slabtype = (SlabType)state.func_177229_b((IProperty)SlabBlock.field_196505_a);
        switch (slabtype) {
            case DOUBLE: {
                return VoxelShapes.func_197868_b();
            }
            case TOP: {
                return TOP_SHAPE;
            }
        }
        return BOTTOM_SHAPE;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        BlockState blockstate = context.func_195991_k().func_180495_p(blockpos);
        SlabType slabtype = null;
        if (blockstate.func_206869_a().contains(SlabBlock.field_196505_a)) {
            slabtype = (SlabType)blockstate.func_177229_b((IProperty)SlabBlock.field_196505_a);
        }
        if (blockstate.func_177230_c() == this || slabtype == SlabType.BOTTOM && (blockstate.func_177230_c() == ModBlocks.block_farmland_slab || blockstate.func_177230_c() == ModBlocks.block_grass_slab || blockstate.func_177230_c() == ModBlocks.block_path_slab || blockstate.func_177230_c() == ModBlocks.block_coarse_dirt_slab)) {
            return Blocks.field_150346_d.func_176223_P();
        }
        if (slabtype == SlabType.TOP && blockstate.func_177230_c() == ModBlocks.block_farmland_slab) {
            int moistLevel = (Integer)blockstate.func_177229_b((IProperty)BlockFarmlandSlab.MOISTURE);
            return (BlockState)Blocks.field_150458_ak.func_176223_P().func_206870_a((IProperty)FarmlandBlock.field_176531_a, (Comparable)Integer.valueOf(moistLevel));
        }
        if (slabtype == SlabType.TOP && blockstate.func_177230_c() == ModBlocks.block_grass_slab) {
            return Blocks.field_196658_i.func_176223_P();
        }
        if (slabtype == SlabType.TOP && blockstate.func_177230_c() == ModBlocks.block_path_slab) {
            return Blocks.field_185774_da.func_176223_P();
        }
        if (slabtype == SlabType.TOP && blockstate.func_177230_c() == ModBlocks.block_coarse_dirt_slab) {
            return Blocks.field_196660_k.func_176223_P();
        }
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(blockpos);
        BlockState blockstate1 = (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)SlabBlock.field_196505_a, (Comparable)SlabType.BOTTOM)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
        Direction direction = context.func_196000_l();
        return !(direction == Direction.DOWN || direction != Direction.UP && context.func_221532_j().field_72448_b - (double)blockpos.func_177956_o() > 0.5) ? blockstate1 : (BlockState)blockstate1.func_206870_a((IProperty)SlabBlock.field_196505_a, (Comparable)SlabType.TOP);
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        ItemStack itemstack = useContext.func_195996_i();
        SlabType slabtype = (SlabType)state.func_177229_b((IProperty)field_196505_a);
        if (slabtype != SlabType.DOUBLE && (itemstack.func_77973_b() == this.func_199767_j() || itemstack.func_77973_b() == ModBlocks.block_path_slab.func_199767_j() || itemstack.func_77973_b() == ModBlocks.block_grass_slab.func_199767_j() || itemstack.func_77973_b() == ModBlocks.block_farmland_slab.func_199767_j() || itemstack.func_77973_b() == ModBlocks.block_coarse_dirt_slab.func_199767_j())) {
            if (useContext.func_196012_c()) {
                boolean flag = useContext.func_221532_j().field_72448_b - (double)useContext.func_195995_a().func_177956_o() > 0.5;
                Direction direction = useContext.func_196000_l();
                if (slabtype == SlabType.BOTTOM) {
                    return direction == Direction.UP || flag && direction.func_176740_k().func_176722_c();
                }
                return direction == Direction.DOWN || !flag && direction.func_176740_k().func_176722_c();
            }
            return true;
        }
        return false;
    }

    public boolean canSustainPlant(BlockState state, IBlockReader world, BlockPos pos, Direction facing, IPlantable plantable) {
        BlockState plant = plantable.getPlant(world, pos.func_177972_a(facing));
        if (plant.func_177230_c() == Blocks.field_196608_cF || plant.func_177230_c() == ModBlocks.sugar_cane_slab) {
            if (state.func_177229_b((IProperty)SlabBlock.field_196505_a) == SlabType.BOTTOM && plant.func_177230_c() == Blocks.field_196608_cF || state.func_177229_b((IProperty)SlabBlock.field_196505_a) == SlabType.TOP && plant.func_177230_c() == ModBlocks.sugar_cane_slab) {
                return false;
            }
            int waterLevelMin = 0;
            if (state.func_206869_a().contains(SlabBlock.field_196505_a) && state.func_177229_b((IProperty)SlabBlock.field_196505_a) == SlabType.BOTTOM) {
                waterLevelMin = -1;
            }
            if (world.func_204610_c(pos).func_206884_a(FluidTags.field_206959_a) && state.func_177229_b((IProperty)SlabBlock.field_196505_a) == SlabType.TOP) {
                return true;
            }
            while (waterLevelMin < 1) {
                if (world.func_204610_c(pos.func_177982_a(1, waterLevelMin, 0)).func_206884_a(FluidTags.field_206959_a)) {
                    return true;
                }
                if (world.func_204610_c(pos.func_177982_a(-1, waterLevelMin, 0)).func_206884_a(FluidTags.field_206959_a)) {
                    return true;
                }
                if (world.func_204610_c(pos.func_177982_a(0, waterLevelMin, 1)).func_206884_a(FluidTags.field_206959_a)) {
                    return true;
                }
                if (world.func_204610_c(pos.func_177982_a(1, waterLevelMin, -1)).func_206884_a(FluidTags.field_206959_a)) {
                    return true;
                }
                ++waterLevelMin;
            }
            return true;
        }
        if (plant.func_177230_c() == Blocks.field_222404_kP || plant.func_177230_c() == Blocks.field_222405_kQ) {
            return true;
        }
        return super.canSustainPlant(Blocks.field_150346_d.func_176223_P(), world, pos, facing, plantable);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult p_225533_6_) {
        ItemStack itemStack = playerIn.func_184586_b(hand);
        if (itemStack.func_77973_b() instanceof HoeItem) {
            return SlabAction.onItemUseHoe(state, worldIn, pos, playerIn, hand, p_225533_6_);
        }
        if (itemStack.func_77973_b() instanceof ShovelItem) {
            return SlabAction.onItemUseSpade(state, worldIn, pos, playerIn, hand, p_225533_6_);
        }
        return ActionResultType.FAIL;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (stateIn.func_177229_b((IProperty)field_196505_a) == SlabType.BOTTOM) {
            SlabHelper.slabCheck(worldIn, currentPos);
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }
}

