/*
 * Decompiled with CFR 0.152.
 */
package com.endlesnights.naturalslabsmod.blocks.slabs;

import com.endlesnights.naturalslabsmod.init.ModBlocks;
import com.endlesnights.naturalslabsmod.placehandler.SlabHelper;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.MovingPistonBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.SlabType;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;

public class BlockFarmlandSlab
extends SlabBlock
implements IWaterLoggable {
    private static final VoxelShape BOTTOM_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape TOP_SHAPE = Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    private static final VoxelShape DOUBLE_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final IntegerProperty MOISTURE = BlockStateProperties.field_208133_ah;

    public BlockFarmlandSlab() {
        super(Block.Properties.func_200950_a((Block)Blocks.field_150458_ak));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)SlabBlock.field_196505_a, (Comparable)SlabType.BOTTOM)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.FALSE)).func_206870_a((IProperty)MOISTURE, (Comparable)Integer.valueOf(0)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{SlabBlock.field_196505_a, WATERLOGGED, MOISTURE});
    }

    public boolean func_220074_n(BlockState state) {
        return state.func_177229_b((IProperty)SlabBlock.field_196505_a) != SlabType.DOUBLE;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        SlabType slabtype = (SlabType)state.func_177229_b((IProperty)SlabBlock.field_196505_a);
        switch (slabtype) {
            case DOUBLE: {
                return DOUBLE_SHAPE;
            }
            case TOP: {
                return TOP_SHAPE;
            }
        }
        return BOTTOM_SHAPE;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        BlockState blockstate = context.func_195991_k().func_180495_p(blockpos);
        SlabType slabtype = null;
        if (blockstate.func_206869_a().contains(SlabBlock.field_196505_a)) {
            slabtype = (SlabType)blockstate.func_177229_b((IProperty)SlabBlock.field_196505_a);
        }
        if (blockstate.func_177230_c() == this || slabtype == SlabType.BOTTOM && (blockstate.func_177230_c() == ModBlocks.block_dirt_slab || blockstate.func_177230_c() == ModBlocks.block_grass_slab || blockstate.func_177230_c() == ModBlocks.block_path_slab || blockstate.func_177230_c() == ModBlocks.block_coarse_dirt_slab)) {
            return Blocks.field_150458_ak.func_176223_P();
        }
        if (slabtype == SlabType.TOP && blockstate.func_177230_c() == ModBlocks.block_dirt_slab) {
            return Blocks.field_150346_d.func_176223_P();
        }
        if (slabtype == SlabType.TOP && blockstate.func_177230_c() == ModBlocks.block_grass_slab) {
            return Blocks.field_196658_i.func_176223_P();
        }
        if (slabtype == SlabType.TOP && blockstate.func_177230_c() == ModBlocks.block_path_slab) {
            return Blocks.field_185774_da.func_176223_P();
        }
        if (slabtype == SlabType.TOP && blockstate.func_177230_c() == ModBlocks.block_coarse_dirt_slab) {
            return Blocks.field_196660_k.func_176223_P();
        }
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(blockpos);
        BlockState blockstate1 = (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)SlabBlock.field_196505_a, (Comparable)SlabType.BOTTOM)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
        Direction direction = context.func_196000_l();
        return !(direction == Direction.DOWN || direction != Direction.UP && context.func_221532_j().field_72448_b - (double)blockpos.func_177956_o() > 0.5) ? blockstate1 : (BlockState)blockstate1.func_206870_a((IProperty)SlabBlock.field_196505_a, (Comparable)SlabType.TOP);
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        ItemStack itemstack = useContext.func_195996_i();
        SlabType slabtype = (SlabType)state.func_177229_b((IProperty)field_196505_a);
        if (slabtype != SlabType.DOUBLE && (itemstack.func_77973_b() == this.func_199767_j() || itemstack.func_77973_b() == ModBlocks.block_dirt_slab.func_199767_j() || itemstack.func_77973_b() == ModBlocks.block_grass_slab.func_199767_j() || itemstack.func_77973_b() == ModBlocks.block_path_slab.func_199767_j() || itemstack.func_77973_b() == ModBlocks.block_coarse_dirt_slab.func_199767_j())) {
            if (useContext.func_196012_c()) {
                boolean flag = useContext.func_221532_j().field_72448_b - (double)useContext.func_195995_a().func_177956_o() > 0.5;
                Direction direction = useContext.func_196000_l();
                if (slabtype == SlabType.BOTTOM) {
                    return direction == Direction.UP || flag && direction.func_176740_k().func_176722_c();
                }
                return direction == Direction.DOWN || !flag && direction.func_176740_k().func_176722_c();
            }
            return true;
        }
        return false;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockState blockstate = worldIn.func_180495_p(pos.func_177984_a());
        return !blockstate.func_185904_a().func_76220_a() || blockstate.func_177230_c() instanceof FenceGateBlock || blockstate.func_177230_c() instanceof MovingPistonBlock;
    }

    public void func_225534_a_(BlockState p_225534_1_, ServerWorld p_225534_2_, BlockPos p_225534_3_, Random p_225534_4_) {
        if (!p_225534_1_.func_196955_c((IWorldReader)p_225534_2_, p_225534_3_)) {
            BlockFarmlandSlab.turnToDirt(p_225534_1_, (World)p_225534_2_, p_225534_3_);
        } else {
            int i = (Integer)p_225534_1_.func_177229_b((IProperty)MOISTURE);
            if (!BlockFarmlandSlab.hasWater((IWorldReader)p_225534_2_, p_225534_3_, p_225534_1_) && !p_225534_2_.func_175727_C(p_225534_3_.func_177984_a())) {
                if (i > 0) {
                    p_225534_2_.func_180501_a(p_225534_3_, (BlockState)p_225534_1_.func_206870_a((IProperty)MOISTURE, (Comparable)Integer.valueOf(i - 1)), 2);
                } else if (!this.hasCrops((IBlockReader)p_225534_2_, p_225534_3_)) {
                    BlockFarmlandSlab.turnToDirt(p_225534_1_, (World)p_225534_2_, p_225534_3_);
                }
            } else if (i < 7) {
                p_225534_2_.func_180501_a(p_225534_3_, (BlockState)p_225534_1_.func_206870_a((IProperty)MOISTURE, (Comparable)Integer.valueOf(7)), 2);
            }
        }
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        if (!worldIn.field_72995_K && ForgeHooks.onFarmlandTrample((World)worldIn, (BlockPos)pos, (BlockState)Blocks.field_150346_d.func_176223_P(), (float)fallDistance, (Entity)entityIn)) {
            BlockFarmlandSlab.turnToDirt(worldIn.func_180495_p(pos), worldIn, pos);
        }
        super.func_180658_a(worldIn, pos, entityIn, fallDistance);
    }

    public static void turnToDirt(BlockState state, World worldIn, BlockPos pos) {
        if (state.func_177229_b((IProperty)SlabBlock.field_196505_a) == SlabType.TOP) {
            worldIn.func_175656_a(pos, BlockFarmlandSlab.func_199601_a((BlockState)state, (BlockState)((BlockState)((BlockState)ModBlocks.block_dirt_slab.func_176223_P().func_206870_a((IProperty)SlabBlock.field_196505_a, state.func_177229_b((IProperty)SlabBlock.field_196505_a))).func_206870_a((IProperty)SlabBlock.field_204512_b, state.func_177229_b((IProperty)SlabBlock.field_204512_b))), (World)worldIn, (BlockPos)pos));
        } else if (state.func_177229_b((IProperty)SlabBlock.field_196505_a) == SlabType.BOTTOM) {
            worldIn.func_175656_a(pos, (BlockState)((BlockState)ModBlocks.block_dirt_slab.func_176223_P().func_206870_a((IProperty)SlabBlock.field_196505_a, state.func_177229_b((IProperty)SlabBlock.field_196505_a))).func_206870_a((IProperty)SlabBlock.field_204512_b, state.func_177229_b((IProperty)SlabBlock.field_204512_b)));
        }
    }

    private boolean hasCrops(IBlockReader worldIn, BlockPos pos) {
        BlockState state = worldIn.func_180495_p(pos.func_177984_a());
        return state.func_177230_c() instanceof IPlantable && this.canSustainPlant(state, worldIn, pos, Direction.UP, (IPlantable)state.func_177230_c());
    }

    private static boolean hasWater(IWorldReader worldIn, BlockPos pos, BlockState state) {
        int waterLevelMin = 0;
        if (state.func_206869_a().contains(SlabBlock.field_196505_a) && state.func_177229_b((IProperty)SlabBlock.field_196505_a) == SlabType.BOTTOM) {
            waterLevelMin = -1;
        }
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-4, waterLevelMin, -4), (BlockPos)pos.func_177982_a(4, 1, 4))) {
            if (!worldIn.func_204610_c(blockpos).func_206884_a(FluidTags.field_206959_a)) continue;
            return true;
        }
        return FarmlandWaterManager.hasBlockWaterTicket((IWorldReader)worldIn, (BlockPos)pos);
    }

    public boolean canSustainPlant(BlockState state, IBlockReader world, BlockPos pos, Direction facing, IPlantable plantable) {
        return super.canSustainPlant(Blocks.field_150458_ak.func_176223_P(), world, pos, facing, plantable);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (stateIn.func_177229_b((IProperty)field_196505_a) == SlabType.BOTTOM) {
            SlabHelper.slabCheck(worldIn, currentPos);
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }
}

