/*
 * Decompiled with CFR 0.152.
 */
package com.endlesnights.naturalslabsmod.blocks.slabs;

import com.endlesnights.naturalslabsmod.blocks.slabs.BlockFarmlandSlab;
import com.endlesnights.naturalslabsmod.init.ModBlocks;
import com.endlesnights.naturalslabsmod.util.SlabAction;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SlabBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.HoeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="naturalslabsmod", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class BlockPathSlab
extends SlabBlock
implements IWaterLoggable {
    private static final VoxelShape BOTTOM_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape TOP_SHAPE = Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    private static final VoxelShape DOUBLE_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public BlockPathSlab() {
        super(Block.Properties.func_200950_a((Block)Blocks.field_185774_da));
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)SlabBlock.field_196505_a, (Comparable)SlabType.BOTTOM)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{SlabBlock.field_196505_a, WATERLOGGED});
    }

    public boolean func_220074_n(BlockState state) {
        return state.func_177229_b((IProperty)SlabBlock.field_196505_a) != SlabType.DOUBLE;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        SlabType slabtype = (SlabType)state.func_177229_b((IProperty)SlabBlock.field_196505_a);
        switch (slabtype) {
            case DOUBLE: {
                return DOUBLE_SHAPE;
            }
            case TOP: {
                return TOP_SHAPE;
            }
        }
        return BOTTOM_SHAPE;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        BlockState blockstate = context.func_195991_k().func_180495_p(blockpos);
        SlabType slabtype = null;
        if (blockstate.func_206869_a().contains(SlabBlock.field_196505_a)) {
            slabtype = (SlabType)blockstate.func_177229_b((IProperty)SlabBlock.field_196505_a);
        }
        if (blockstate.func_177230_c() == this || slabtype == SlabType.BOTTOM && (blockstate.func_177230_c() == ModBlocks.block_dirt_slab || blockstate.func_177230_c() == ModBlocks.block_grass_slab || blockstate.func_177230_c() == ModBlocks.block_farmland_slab || blockstate.func_177230_c() == ModBlocks.block_coarse_dirt_slab)) {
            return Blocks.field_185774_da.func_176223_P();
        }
        if (slabtype == SlabType.TOP && blockstate.func_177230_c() == ModBlocks.block_dirt_slab) {
            return Blocks.field_150346_d.func_176223_P();
        }
        if (slabtype == SlabType.TOP && blockstate.func_177230_c() == ModBlocks.block_grass_slab) {
            return Blocks.field_196658_i.func_176223_P();
        }
        if (slabtype == SlabType.TOP && blockstate.func_177230_c() == ModBlocks.block_farmland_slab) {
            int moistLevel = (Integer)blockstate.func_177229_b((IProperty)BlockFarmlandSlab.MOISTURE);
            return (BlockState)Blocks.field_150458_ak.func_176223_P().func_206870_a((IProperty)FarmlandBlock.field_176531_a, (Comparable)Integer.valueOf(moistLevel));
        }
        if (slabtype == SlabType.TOP && blockstate.func_177230_c() == ModBlocks.block_coarse_dirt_slab) {
            return Blocks.field_196660_k.func_176223_P();
        }
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(blockpos);
        BlockState blockstate1 = (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)SlabBlock.field_196505_a, (Comparable)SlabType.BOTTOM)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
        Direction direction = context.func_196000_l();
        return !(direction == Direction.DOWN || direction != Direction.UP && context.func_221532_j().field_72448_b - (double)blockpos.func_177956_o() > 0.5) ? blockstate1 : (BlockState)blockstate1.func_206870_a((IProperty)SlabBlock.field_196505_a, (Comparable)SlabType.TOP);
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        ItemStack itemstack = useContext.func_195996_i();
        SlabType slabtype = (SlabType)state.func_177229_b((IProperty)field_196505_a);
        if (slabtype != SlabType.DOUBLE && (itemstack.func_77973_b() == this.func_199767_j() || itemstack.func_77973_b() == ModBlocks.block_dirt_slab.func_199767_j() || itemstack.func_77973_b() == ModBlocks.block_grass_slab.func_199767_j() || itemstack.func_77973_b() == ModBlocks.block_farmland_slab.func_199767_j() || itemstack.func_77973_b() == ModBlocks.block_coarse_dirt_slab.func_199767_j())) {
            if (useContext.func_196012_c()) {
                boolean flag = useContext.func_221532_j().field_72448_b - (double)useContext.func_195995_a().func_177956_o() > 0.5;
                Direction direction = useContext.func_196000_l();
                if (slabtype == SlabType.BOTTOM) {
                    return direction == Direction.UP || flag && direction.func_176740_k().func_176722_c();
                }
                return direction == Direction.DOWN || !flag && direction.func_176740_k().func_176722_c();
            }
            return true;
        }
        return false;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockState blockstate = worldIn.func_180495_p(pos.func_177984_a());
        return !blockstate.func_185904_a().func_76220_a() || blockstate.func_177230_c() instanceof FenceGateBlock;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_229870_f_(BlockState p_229870_1_, IBlockReader p_229870_2_, BlockPos p_229870_3_) {
        return true;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random p_225534_4_) {
        BlockState stateTo = Blocks.field_150346_d.func_176223_P();
        if (state.func_177229_b((IProperty)SlabBlock.field_196505_a) == SlabType.BOTTOM) {
            stateTo = ModBlocks.block_dirt_slab.func_176223_P();
        } else if (state.func_177229_b((IProperty)SlabBlock.field_196505_a) == SlabType.TOP) {
            stateTo = (BlockState)ModBlocks.block_dirt_slab.func_176223_P().func_206870_a((IProperty)SlabBlock.field_196505_a, (Comparable)SlabType.TOP);
        }
        worldIn.func_175656_a(pos, BlockPathSlab.func_199601_a((BlockState)state, (BlockState)Blocks.field_150346_d.func_176223_P(), (World)worldIn, (BlockPos)pos));
        worldIn.func_175656_a(pos, stateTo);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.UP && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos)) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult p_225533_6_) {
        ItemStack itemStack = playerIn.func_184586_b(hand);
        if (itemStack.func_77973_b() instanceof HoeItem) {
            return SlabAction.onItemUseHoe(state, worldIn, pos, playerIn, hand, p_225533_6_);
        }
        return ActionResultType.FAIL;
    }
}

