/*
 * Decompiled with CFR 0.152.
 */
package com.endlesnights.naturalslabsmod.blocks.slabs;

import com.endlesnights.naturalslabsmod.blocks.slabs.BlockSnowSlab;
import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BlockSnowStairs
extends Block {
    public static final IntegerProperty LAYERS = BlockSnowSlab.LAYERS_1_12;
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.field_208146_au;
    protected static VoxelShape TOP_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    protected static VoxelShape BOTTOM_SHAPE = Block.func_208617_a((double)0.0, (double)-8.0, (double)0.0, (double)16.0, (double)-6.0, (double)16.0);
    protected static VoxelShape NWD_CORNER = Block.func_208617_a((double)0.0, (double)-8.0, (double)0.0, (double)8.0, (double)-6.0, (double)8.0);
    protected static VoxelShape SWD_CORNER = Block.func_208617_a((double)0.0, (double)-8.0, (double)8.0, (double)8.0, (double)-6.0, (double)16.0);
    protected static VoxelShape NWU_CORNER = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)2.0, (double)8.0);
    protected static VoxelShape SWU_CORNER = Block.func_208617_a((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)2.0, (double)16.0);
    protected static VoxelShape NED_CORNER = Block.func_208617_a((double)8.0, (double)-8.0, (double)0.0, (double)16.0, (double)-6.0, (double)8.0);
    protected static VoxelShape SED_CORNER = Block.func_208617_a((double)8.0, (double)-8.0, (double)8.0, (double)16.0, (double)-6.0, (double)16.0);
    protected static VoxelShape NEU_CORNER = Block.func_208617_a((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)8.0);
    protected static VoxelShape SEU_CORNER = Block.func_208617_a((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)2.0, (double)16.0);
    protected static VoxelShape[] SLAB_TOP_SHAPES = BlockSnowStairs.makeShapes(TOP_SHAPE, NWD_CORNER, NED_CORNER, SWD_CORNER, SED_CORNER);
    protected static VoxelShape[] SLAB_BOTTOM_SHAPES = BlockSnowStairs.makeShapes(BOTTOM_SHAPE, NWU_CORNER, NEU_CORNER, SWU_CORNER, SEU_CORNER);
    private static final int[] field_196522_K = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};

    public BlockSnowStairs(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a(SHAPE, (Comparable)StairsShape.STRAIGHT)).func_206870_a((IProperty)LAYERS, (Comparable)Integer.valueOf(1)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, SHAPE, LAYERS});
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof StairsBlock && worldIn.func_180495_p(pos.func_177977_b()).func_177229_b((IProperty)StairsBlock.field_176308_b) == Half.BOTTOM;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (worldIn.func_180495_p(currentPos.func_177977_b()).func_177230_c() instanceof StairsBlock && worldIn.func_180495_p(currentPos.func_177977_b()).func_177229_b((IProperty)StairsBlock.field_176308_b) == Half.BOTTOM) {
            return (BlockState)((BlockState)stateIn.func_206870_a((IProperty)StairsBlock.field_176309_a, worldIn.func_180495_p(currentPos.func_177977_b()).func_177229_b((IProperty)StairsBlock.field_176309_a))).func_206870_a((IProperty)StairsBlock.field_176310_M, worldIn.func_180495_p(currentPos.func_177977_b()).func_177229_b((IProperty)StairsBlock.field_176310_M));
        }
        return !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    private static VoxelShape[] makeShapes(VoxelShape slabShape, VoxelShape nwCorner, VoxelShape neCorner, VoxelShape swCorner, VoxelShape seCorner) {
        return (VoxelShape[])IntStream.range(0, 16).mapToObj(p_199780_5_ -> BlockSnowStairs.combineShapes(p_199780_5_, slabShape, nwCorner, neCorner, swCorner, seCorner)).toArray(VoxelShape[]::new);
    }

    public boolean func_220074_n(BlockState state) {
        return true;
    }

    private static VoxelShape combineShapes(int bitfield, VoxelShape slabShape, VoxelShape nwCorner, VoxelShape neCorner, VoxelShape swCorner, VoxelShape seCorner) {
        VoxelShape voxelshape = slabShape;
        if ((bitfield & 1) != 0) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)slabShape, (VoxelShape)nwCorner);
        }
        if ((bitfield & 2) != 0) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)neCorner);
        }
        if ((bitfield & 4) != 0) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)swCorner);
        }
        if ((bitfield & 8) != 0) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)seCorner);
        }
        return voxelshape;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        BOTTOM_SHAPE = Block.func_208617_a((double)0.0, (double)-8.0, (double)0.0, (double)16.0, (double)(-6.0 + (double)(2 * ((Integer)state.func_177229_b((IProperty)LAYERS) - 1))), (double)16.0);
        double offset = Math.round(1.2727272727272727 * (double)((Integer)state.func_177229_b((IProperty)LAYERS) - 1));
        NWU_CORNER = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)(2.0 + offset), (double)8.0);
        NEU_CORNER = Block.func_208617_a((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)(2.0 + offset), (double)8.0);
        SWU_CORNER = Block.func_208617_a((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)(2.0 + offset), (double)16.0);
        SEU_CORNER = Block.func_208617_a((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)(2.0 + offset), (double)16.0);
        SLAB_BOTTOM_SHAPES = BlockSnowStairs.makeShapes(BOTTOM_SHAPE, NWU_CORNER, NEU_CORNER, SWU_CORNER, SEU_CORNER);
        return SLAB_BOTTOM_SHAPES[field_196522_K[this.func_196511_x(state)]];
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if ((Integer)state.func_177229_b((IProperty)LAYERS) == 12) {
            return this.func_220053_a(state, worldIn, pos, context);
        }
        BOTTOM_SHAPE = Block.func_208617_a((double)0.0, (double)-8.0, (double)0.0, (double)16.0, (double)(-7.0 + (double)(2 * ((Integer)state.func_177229_b((IProperty)LAYERS) - 1))), (double)16.0);
        double offset = Math.round(1.2727272727272727 * (double)((Integer)state.func_177229_b((IProperty)LAYERS) - 1));
        NWU_CORNER = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)(1.0 + offset), (double)8.0);
        NEU_CORNER = Block.func_208617_a((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)(1.0 + offset), (double)8.0);
        SWU_CORNER = Block.func_208617_a((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)(1.0 + offset), (double)16.0);
        SEU_CORNER = Block.func_208617_a((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)(1.0 + offset), (double)16.0);
        SLAB_BOTTOM_SHAPES = BlockSnowStairs.makeShapes(BOTTOM_SHAPE, NWU_CORNER, NEU_CORNER, SWU_CORNER, SEU_CORNER);
        return SLAB_BOTTOM_SHAPES[field_196522_K[this.func_196511_x(state)]];
    }

    private int func_196511_x(BlockState state) {
        return ((StairsShape)state.func_177229_b(SHAPE)).ordinal() * 4 + ((Direction)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        switch (type) {
            case LAND: {
                return (Integer)state.func_177229_b((IProperty)LAYERS) < 5;
            }
            case WATER: {
                return false;
            }
            case AIR: {
                return false;
            }
        }
        return false;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos blockPos, Random rand) {
        if (worldIn.func_226658_a_(LightType.BLOCK, blockPos) > 7) {
            BlockSnowStairs.func_220075_c((BlockState)state, (World)worldIn, (BlockPos)blockPos);
            worldIn.func_217377_a(blockPos, false);
        }
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        int i = (Integer)state.func_177229_b((IProperty)LAYERS);
        if (useContext.func_195996_i().func_77973_b() == this.func_199767_j() && i < 12) {
            if (useContext.func_196012_c()) {
                return useContext.func_196000_l() == Direction.UP;
            }
            return true;
        }
        return i == 1;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return new ItemStack((IItemProvider)Items.field_221768_ct);
    }
}

