/*
 * Decompiled with CFR 0.152.
 */
package com.endlesnights.naturalslabsmod.blocks.slabs;

import com.endlesnights.naturalslabsmod.entities.FallingSlabEntity;
import com.endlesnights.naturalslabsmod.init.ModBlocks;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.SlabType;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;

public class FallinglSlab
extends SlabBlock {
    private static final VoxelShape BOTTOM_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final EnumProperty<SlabType> TYPE = BlockStateProperties.field_208145_at;
    public final int DustColor;
    public final Block ParentBlock;

    public FallinglSlab(Block.Properties properties, int dust, Block parentBlock) {
        super(properties);
        this.DustColor = dust;
        this.ParentBlock = parentBlock;
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)SlabBlock.field_196505_a, (Comparable)SlabType.BOTTOM)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{SlabBlock.field_196505_a, WATERLOGGED});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return BOTTOM_SHAPE;
    }

    public boolean canSustainPlant(BlockState state, IBlockReader world, BlockPos pos, Direction facing, IPlantable plantable) {
        BlockState plant;
        if (!(this.ParentBlock != Blocks.field_150354_m && this.ParentBlock != Blocks.field_196611_F || (plant = plantable.getPlant(world, pos.func_177972_a(facing))).func_177230_c() != Blocks.field_196608_cF && plant.func_177230_c() != ModBlocks.sugar_cane_slab)) {
            if (state.func_177229_b((IProperty)SlabBlock.field_196505_a) == SlabType.BOTTOM && plant.func_177230_c() == Blocks.field_196608_cF || state.func_177229_b((IProperty)SlabBlock.field_196505_a) == SlabType.TOP && plant.func_177230_c() == ModBlocks.sugar_cane_slab) {
                return false;
            }
            int waterLevelMin = 0;
            if (state.func_206869_a().contains(SlabBlock.field_196505_a) && state.func_177229_b((IProperty)SlabBlock.field_196505_a) == SlabType.BOTTOM) {
                waterLevelMin = -1;
            }
            if (world.func_204610_c(pos).func_206884_a(FluidTags.field_206959_a) && state.func_177229_b((IProperty)SlabBlock.field_196505_a) == SlabType.TOP) {
                return true;
            }
            while (waterLevelMin < 1) {
                if (world.func_204610_c(pos.func_177982_a(1, waterLevelMin, 0)).func_206884_a(FluidTags.field_206959_a)) {
                    return true;
                }
                if (world.func_204610_c(pos.func_177982_a(-1, waterLevelMin, 0)).func_206884_a(FluidTags.field_206959_a)) {
                    return true;
                }
                if (world.func_204610_c(pos.func_177982_a(0, waterLevelMin, 1)).func_206884_a(FluidTags.field_206959_a)) {
                    return true;
                }
                if (world.func_204610_c(pos.func_177982_a(1, waterLevelMin, -1)).func_206884_a(FluidTags.field_206959_a)) {
                    return true;
                }
                ++waterLevelMin;
            }
            return true;
        }
        return false;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        BlockState blockstate = context.func_195991_k().func_180495_p(blockpos);
        if (blockstate.func_177230_c() == this) {
            return this.ParentBlock.func_176223_P();
        }
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(blockpos);
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)SlabBlock.field_196505_a, (Comparable)SlabType.BOTTOM)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        BlockPos pos = useContext.func_195995_a();
        BlockState target = useContext.func_195991_k().func_180495_p(pos.func_177984_a());
        ItemStack itemstack = useContext.func_195996_i();
        if (itemstack.func_77973_b() == this.func_199767_j()) {
            return true;
        }
        if (itemstack.func_77973_b() == this.ParentBlock.func_199767_j() && target.func_177230_c().func_196253_a(target, useContext)) {
            useContext.func_195991_k().func_175656_a(pos.func_177984_a(), (BlockState)this.func_176223_P().func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(target.func_177230_c() == Blocks.field_150355_j)));
            return true;
        }
        return false;
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        worldIn.func_205220_G_().func_205360_a(pos, (Object)this, this.func_149738_a((IWorldReader)worldIn));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (worldIn.func_180495_p(currentPos.func_177984_a()).func_177230_c() == this) {
            worldIn.func_180501_a(currentPos.func_177984_a(), Blocks.field_150350_a.func_176223_P(), 3);
            return this.ParentBlock.func_176223_P();
        }
        worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, this.func_149738_a((IWorldReader)worldIn));
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void func_225534_a_(BlockState p_225534_1_, ServerWorld p_225534_2_, BlockPos p_225534_3_, Random p_225534_4_) {
        if (p_225534_2_.func_175623_d(p_225534_3_.func_177977_b()) || FallinglSlab.canFallThrough(p_225534_2_.func_180495_p(p_225534_3_.func_177977_b())) && p_225534_3_.func_177956_o() >= 0) {
            FallingSlabEntity fallingSlabEntity = new FallingSlabEntity((World)p_225534_2_, (double)p_225534_3_.func_177958_n() + 0.5, p_225534_3_.func_177956_o(), (double)p_225534_3_.func_177952_p() + 0.5, p_225534_2_.func_180495_p(p_225534_3_));
            this.onStartFalling(fallingSlabEntity);
            p_225534_2_.func_217376_c((Entity)fallingSlabEntity);
        }
    }

    protected void onStartFalling(FallingSlabEntity fallingEntity) {
    }

    public int func_149738_a(IWorldReader worldIn) {
        return 2;
    }

    public static boolean canFallThrough(BlockState state) {
        Block block = state.func_177230_c();
        Material material = state.func_185904_a();
        return state.func_196958_f() || block == Blocks.field_150480_ab || material.func_76224_d() || material.func_76222_j();
    }

    public void onEndFalling(World worldIn, BlockPos pos, BlockState fallingState, BlockState hitState) {
    }

    public void breakFall(World worldIn, BlockPos pos, BlockState fallingState, BlockState hitState, FallingSlabEntity entity) {
        if (worldIn.func_180495_p(pos).func_177230_c() == this) {
            worldIn.func_180501_a(pos, this.ParentBlock.func_176223_P(), 3);
        } else {
            entity.func_199703_a((IItemProvider)this.func_199767_j());
        }
    }

    public void onBroken(World worldIn, BlockPos pos) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        BlockPos blockpos;
        if (rand.nextInt(16) == 0 && (worldIn.func_175623_d(blockpos = pos.func_177977_b()) || FallinglSlab.canFallThrough(worldIn.func_180495_p(blockpos)))) {
            double d0 = (double)pos.func_177958_n() + (double)rand.nextFloat();
            double d1 = (double)pos.func_177956_o() - 0.05;
            double d2 = (double)pos.func_177952_p() + (double)rand.nextFloat();
            worldIn.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197628_u, stateIn), d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getDustColor(BlockState state) {
        return this.DustColor;
    }
}

