/*
 * Decompiled with CFR 0.152.
 */
package com.endlesnights.naturalslabsmod.events;

import com.endlesnights.naturalslabsmod.blocks.slabs.BlockSnowSlab;
import com.endlesnights.naturalslabsmod.blocks.slabs.BlockSnowStairs;
import com.endlesnights.naturalslabsmod.config.Config;
import com.endlesnights.naturalslabsmod.config.NaturalSlabsConfig;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.SnowBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.IProperty;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod.EventBusSubscriber
public class FallEvent {
    @SubscribeEvent
    public void onFall(LivingFallEvent event) {
        Config.loadConfig(Config.SERVER, FMLPaths.CONFIGDIR.get().resolve("naturalslabsmod-server.toml").toString());
        if (!((Boolean)NaturalSlabsConfig.softSnowLanding.get()).booleanValue()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof PlayerEntity)) {
            return;
        }
        World worldIn = event.getEntity().func_130014_f_();
        BlockPos blockPos = new BlockPos((double)entity.func_180425_c().func_177958_n(), Math.ceil(entity.func_213303_ch().field_72448_b) - 1.0, (double)entity.func_180425_c().func_177952_p());
        BlockPos playerPos = entity.func_180425_c();
        Block block = worldIn.func_180495_p(blockPos).func_177230_c();
        int snowLayers = 0;
        int blockIndex = 0;
        if (worldIn.func_180495_p(playerPos).func_177230_c() instanceof BlockSnowStairs) {
            event.setDistance(event.getDistance() - (float)((Integer)worldIn.func_180495_p(playerPos).func_177229_b((IProperty)BlockSnowSlab.LAYERS)).intValue() * ((Double)NaturalSlabsConfig.snowFallRatio.get()).floatValue());
            return;
        }
        if (worldIn.func_180495_p(blockPos).func_177230_c() instanceof BlockSnowStairs || worldIn.func_180495_p(blockPos).func_177230_c() instanceof BlockSnowSlab) {
            if (worldIn.func_180495_p(blockPos.func_177984_a()).func_177230_c() instanceof SnowBlock) {
                event.setDistance(event.getDistance() - (float)((Integer)worldIn.func_180495_p(blockPos).func_177229_b((IProperty)BlockSnowSlab.LAYERS) + 1) * ((Double)NaturalSlabsConfig.snowFallRatio.get()).floatValue());
            } else {
                event.setDistance(event.getDistance() - (float)((Integer)worldIn.func_180495_p(blockPos).func_177229_b((IProperty)BlockSnowSlab.LAYERS)).intValue() * ((Double)NaturalSlabsConfig.snowFallRatio.get()).floatValue());
            }
            return;
        }
        if (worldIn.func_180495_p(blockPos.func_177984_a()).func_177230_c() instanceof BlockSnowStairs || worldIn.func_180495_p(blockPos.func_177984_a()).func_177230_c() instanceof BlockSnowSlab) {
            event.setDistance(event.getDistance() - (float)((Integer)worldIn.func_180495_p(blockPos.func_177984_a()).func_177229_b((IProperty)BlockSnowSlab.LAYERS)).intValue() * ((Double)NaturalSlabsConfig.snowFallRatio.get()).floatValue());
            return;
        }
        if (worldIn.func_180495_p(playerPos).func_177230_c() instanceof SnowBlock && playerPos != blockPos && (Integer)worldIn.func_180495_p(playerPos).func_177229_b((IProperty)SnowBlock.field_176315_a) == 1) {
            ++snowLayers;
        }
        int maxLayers = (Integer)NaturalSlabsConfig.snowFallMaxLayers.get();
        boolean snowBlock = true;
        while (snowBlock) {
            if (snowLayers >= maxLayers) {
                snowLayers = maxLayers;
                break;
            }
            if (block instanceof SnowBlock) {
                if (blockIndex > 0 && (Integer)worldIn.func_180495_p(blockPos.func_177979_c(blockIndex)).func_177229_b((IProperty)SnowBlock.field_176315_a) < 8) break;
                snowLayers += ((Integer)worldIn.func_180495_p(blockPos.func_177979_c(blockIndex)).func_177229_b((IProperty)SnowBlock.field_176315_a)).intValue();
            } else if (block.getRegistryName() == Blocks.field_196604_cC.getRegistryName()) {
                snowLayers += 8;
            } else {
                if (block instanceof BlockSnowStairs || block instanceof BlockSnowSlab) {
                    if ((Integer)worldIn.func_180495_p(blockPos.func_177979_c(blockIndex)).func_177229_b((IProperty)BlockSnowSlab.LAYERS) != 12) break;
                    snowLayers += 12;
                    break;
                }
                snowBlock = false;
                break;
            }
            block = worldIn.func_180495_p(blockPos.func_177979_c(++blockIndex)).func_177230_c();
        }
        event.setDistance(event.getDistance() - (float)snowLayers * ((Double)NaturalSlabsConfig.snowFallRatio.get()).floatValue());
    }
}

