/*
 * Decompiled with CFR 0.152.
 */
package com.endlesnights.naturalslabsmod.placehandler;

import com.endlesnights.naturalslabsmod.init.ModBlocks;
import com.endlesnights.naturalslabsmod.placehandler.SlabHelper;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.DecoratedFeatureConfig;
import net.minecraft.world.gen.feature.FlowersFeature;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="naturalslabsmod")
public class BonemealPlaceHandler {
    private static final HashMap<ResourceLocation, Block> PLACE_ENTRIES = new HashMap();

    @SubscribeEvent
    public static void onBlockEntityPlace(PlayerInteractEvent.RightClickBlock event) {
        ItemStack itemStack = event.getItemStack();
        ResourceLocation rl = itemStack.func_77973_b().getRegistryName();
        if (PLACE_ENTRIES.containsKey(rl)) {
            BonemealPlaceHandler.placeBoneMeal(event, itemStack, PLACE_ENTRIES.get(rl));
        }
    }

    private static void placeBoneMeal(PlayerInteractEvent.RightClickBlock event, ItemStack itemStack, Block block) {
        BlockPos pos = event.getPos();
        World world = event.getWorld();
        if (world.func_180495_p(pos).func_177230_c() != ModBlocks.block_grass_slab && world.func_180495_p(pos).func_177230_c() != Blocks.field_196658_i) {
            return;
        }
        if (!world.func_201670_d()) {
            BonemealPlaceHandler.grassGrow((ServerWorld)world, new Random(), pos, world.func_180495_p(pos));
        }
        event.getPlayer().func_184609_a(event.getHand());
        if (!event.getPlayer().func_184812_l_()) {
            itemStack.func_190918_g(1);
        }
        event.setCanceled(true);
    }

    public static void grassGrow(ServerWorld worldIn, Random rand, BlockPos pos, BlockState blockState) {
        BlockPos blockpos = pos.func_177984_a();
        BlockState blockstate = Blocks.field_150349_c.func_176223_P();
        block0: for (int i = 0; i < 128; ++i) {
            BlockPos blockpos1 = blockpos;
            int j = 0;
            while (true) {
                if (j >= i / 16) {
                    BlockState blockstate1;
                    BlockState blockstate2 = worldIn.func_180495_p(blockpos1);
                    if (blockstate2.func_177230_c() == blockstate.func_177230_c() && rand.nextInt(10) == 0) {
                        ((IGrowable)blockstate.func_177230_c()).func_225535_a_(worldIn, rand, blockpos1, blockstate2);
                    } else if (blockstate2.func_177230_c() == ModBlocks.grass_slab && rand.nextInt(10) == 0) {
                        ((IGrowable)ModBlocks.grass_slab).func_225535_a_(worldIn, rand, blockpos1, blockstate2);
                    }
                    if (!blockstate2.func_196958_f()) continue block0;
                    if (rand.nextInt(8) == 0) {
                        List list = worldIn.func_226691_t_(blockpos1).func_201853_g();
                        if (list.isEmpty()) continue block0;
                        ConfiguredFeature configuredfeature = ((DecoratedFeatureConfig)((ConfiguredFeature)list.get((int)0)).field_222738_b).field_214689_a;
                        blockstate1 = ((FlowersFeature)configuredfeature.field_222737_a).func_225562_b_(rand, blockpos1, configuredfeature.field_222738_b);
                    } else {
                        blockstate1 = blockstate;
                    }
                    if (blockstate1.func_196955_c((IWorldReader)worldIn, blockpos1)) {
                        worldIn.func_180501_a(blockpos1, blockstate1, 3);
                        continue block0;
                    }
                    if (!SlabHelper.slabBottomFoliage(blockstate1).func_196955_c((IWorldReader)worldIn, blockpos1)) continue block0;
                    worldIn.func_180501_a(blockpos1, SlabHelper.slabBottomFoliage(blockstate1), 3);
                    continue block0;
                }
                if (worldIn.func_180495_p((blockpos1 = blockpos1.func_177982_a(rand.nextInt(3) - 1, (rand.nextInt(3) - 1) * rand.nextInt(3) / 2, rand.nextInt(3) - 1)).func_177977_b()).func_177230_c() != ModBlocks.block_grass_slab.getBlock() && worldIn.func_180495_p(blockpos1.func_177977_b()).func_177230_c() != Blocks.field_196658_i.getBlock() && worldIn.func_180495_p(blockpos1.func_177977_b()).func_177230_c() != ModBlocks.tutorial_block.getBlock() || worldIn.func_180495_p(blockpos1).func_224756_o((IBlockReader)worldIn, blockpos1)) continue block0;
                ++j;
            }
        }
    }

    public static void registerPlaceEntry(ResourceLocation itemName, Block block) {
        if (!PLACE_ENTRIES.containsKey(itemName)) {
            PLACE_ENTRIES.put(itemName, block);
        }
    }

    public static Collection<Block> getPlaceEntryBlocks() {
        return PLACE_ENTRIES.values();
    }
}

