/*
 * Decompiled with CFR 0.152.
 */
package com.endlesnights.naturalslabsmod.placehandler;

import com.endlesnights.naturalslabsmod.blocks.FenceSlabBlock;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.SlabType;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="naturalslabsmod")
public class FenceSlabPlaceHandler {
    private static final HashMap<ResourceLocation, Block> PLACE_ENTRIES = new HashMap();

    @SubscribeEvent
    public static void onBlockEntityPlace(PlayerInteractEvent.RightClickBlock event) {
        ItemStack itemStack = event.getItemStack();
        ResourceLocation rl = itemStack.func_77973_b().getRegistryName();
        if (PLACE_ENTRIES.containsKey(rl)) {
            FenceSlabPlaceHandler.placeBoneMeal(event, itemStack, PLACE_ENTRIES.get(rl));
        }
    }

    private static void placeBoneMeal(PlayerInteractEvent.RightClickBlock event, ItemStack itemStack, Block block) {
        BlockPos pos = event.getPos();
        Direction face = event.getFace();
        BlockPos placeAt = pos.func_177972_a(face);
        World world = event.getWorld();
        if (face == Direction.UP && world.func_180495_p(pos).func_177230_c() instanceof SlabBlock && world.func_180495_p(pos).func_177229_b((IProperty)SlabBlock.field_196505_a) == SlabType.BOTTOM || world.func_180495_p(pos).func_177230_c() instanceof FenceSlabBlock && (world.func_175623_d(placeAt) || world.func_204610_c(placeAt).func_206886_c() == Fluids.field_204546_a || world.func_204610_c(placeAt).func_206886_c() == Fluids.field_207212_b)) {
            if (Block.func_220055_a((IWorldReader)world, (BlockPos)placeAt.func_177977_b(), (Direction)Direction.UP) && !(world.func_180495_p(placeAt.func_177977_b()).func_177230_c() instanceof FenceSlabBlock)) {
                return;
            }
            if (block instanceof IWaterLoggable) {
                world.func_175656_a(placeAt, (BlockState)FenceSlabPlaceHandler.getStateForPlacement(placeAt, world, block).func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(world.func_204610_c(placeAt).func_206886_c() == Fluids.field_204546_a)));
            } else {
                world.func_175656_a(placeAt, FenceSlabPlaceHandler.getStateForPlacement(placeAt, world, block));
            }
            world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), block.func_220072_p(world.func_180495_p(pos)).func_185841_e(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            event.getPlayer().func_184609_a(event.getHand());
            if (!event.getPlayer().func_184812_l_()) {
                itemStack.func_190918_g(1);
            }
            event.setCanceled(true);
        }
    }

    public static BlockState getStateForPlacement(BlockPos currentPos, World worldIn, Block block) {
        BlockPos blockpos1 = currentPos.func_177978_c();
        BlockPos blockpos2 = currentPos.func_177974_f();
        BlockPos blockpos3 = currentPos.func_177968_d();
        BlockPos blockpos4 = currentPos.func_177976_e();
        BlockState blockstate = worldIn.func_180495_p(blockpos1);
        BlockState blockstate1 = worldIn.func_180495_p(blockpos2);
        BlockState blockstate2 = worldIn.func_180495_p(blockpos3);
        BlockState blockstate3 = worldIn.func_180495_p(blockpos4);
        BlockPos blockpos1Down = currentPos.func_177978_c().func_177977_b();
        BlockPos blockpos2Down = currentPos.func_177974_f().func_177977_b();
        BlockPos blockpos3Down = currentPos.func_177968_d().func_177977_b();
        BlockPos blockpos4Down = currentPos.func_177976_e().func_177977_b();
        BlockState blockstateDown = worldIn.func_180495_p(blockpos1Down);
        BlockState blockstate1Down = worldIn.func_180495_p(blockpos2Down);
        BlockState blockstate2Down = worldIn.func_180495_p(blockpos3Down);
        BlockState blockstate3Down = worldIn.func_180495_p(blockpos4Down);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)block.func_176223_P().func_206870_a((IProperty)FenceSlabBlock.NORTH, (Comparable)Boolean.valueOf(FenceSlabPlaceHandler.checkConnection(blockstate, blockstate.func_224755_d((IBlockReader)worldIn, blockpos1, Direction.SOUTH), Direction.SOUTH)))).func_206870_a((IProperty)FenceSlabBlock.EAST, (Comparable)Boolean.valueOf(FenceSlabPlaceHandler.checkConnection(blockstate1, blockstate1.func_224755_d((IBlockReader)worldIn, blockpos2, Direction.WEST), Direction.WEST)))).func_206870_a((IProperty)FenceSlabBlock.SOUTH, (Comparable)Boolean.valueOf(FenceSlabPlaceHandler.checkConnection(blockstate2, blockstate2.func_224755_d((IBlockReader)worldIn, blockpos3, Direction.NORTH), Direction.NORTH)))).func_206870_a((IProperty)FenceSlabBlock.WEST, (Comparable)Boolean.valueOf(FenceSlabPlaceHandler.checkConnection(blockstate3, blockstate3.func_224755_d((IBlockReader)worldIn, blockpos4, Direction.EAST), Direction.EAST)))).func_206870_a((IProperty)FenceSlabBlock.NORTH_UP, (Comparable)Boolean.valueOf(FenceSlabPlaceHandler.checkConnectionUpDown(blockstate)))).func_206870_a((IProperty)FenceSlabBlock.EAST_UP, (Comparable)Boolean.valueOf(FenceSlabPlaceHandler.checkConnectionUpDown(blockstate1)))).func_206870_a((IProperty)FenceSlabBlock.SOUTH_UP, (Comparable)Boolean.valueOf(FenceSlabPlaceHandler.checkConnectionUpDown(blockstate2)))).func_206870_a((IProperty)FenceSlabBlock.WEST_UP, (Comparable)Boolean.valueOf(FenceSlabPlaceHandler.checkConnectionUpDown(blockstate3)))).func_206870_a((IProperty)FenceSlabBlock.NORTH_DOWN, (Comparable)Boolean.valueOf(FenceSlabPlaceHandler.checkConnectionUpDown(blockstateDown)))).func_206870_a((IProperty)FenceSlabBlock.EAST_DOWN, (Comparable)Boolean.valueOf(FenceSlabPlaceHandler.checkConnectionUpDown(blockstate1Down)))).func_206870_a((IProperty)FenceSlabBlock.SOUTH_DOWN, (Comparable)Boolean.valueOf(FenceSlabPlaceHandler.checkConnectionUpDown(blockstate2Down)))).func_206870_a((IProperty)FenceSlabBlock.WEST_DOWN, (Comparable)Boolean.valueOf(FenceSlabPlaceHandler.checkConnectionUpDown(blockstate3Down)));
    }

    public static boolean checkConnection(BlockState blockState, boolean solidWall, Direction facing) {
        Block block = blockState.func_177230_c();
        boolean flag = block instanceof FenceSlabBlock;
        boolean flag1 = block instanceof FenceGateBlock && FenceGateBlock.func_220253_a((BlockState)blockState, (Direction)facing);
        return !Block.func_220073_a((Block)block) && solidWall || flag || flag1;
    }

    public static boolean checkConnectionUpDown(BlockState blockState) {
        Block block = blockState.func_177230_c();
        boolean flag = block.func_203417_a(BlockTags.field_219748_G) && blockState.func_185904_a() == Material.field_151575_d;
        return flag;
    }

    public static void registerPlaceEntry(ResourceLocation itemName, Block block) {
        if (!PLACE_ENTRIES.containsKey(itemName)) {
            PLACE_ENTRIES.put(itemName, block);
        }
    }

    public static Collection<Block> getPlaceEntryBlocks() {
        return PLACE_ENTRIES.values();
    }
}

