/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura;

import com.mojang.blaze3d.platform.GlStateManager;
import de.ellpeck.naturesaura.NaturesAura;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.container.IAuraContainer;
import de.ellpeck.naturesaura.api.aura.item.IAuraRecharge;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityImpl;
import de.ellpeck.naturesaura.chunk.AuraChunk;
import de.ellpeck.naturesaura.compat.Compat;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.lwjgl.opengl.GL11;
import top.theillusivec4.curios.api.CuriosAPI;

public final class Helper {
    public static boolean getTileEntitiesInArea(IWorld world, BlockPos pos, int radius, Function<TileEntity, Boolean> consumer) {
        for (int x = pos.func_177958_n() - radius >> 4; x <= pos.func_177958_n() + radius >> 4; ++x) {
            for (int z = pos.func_177952_p() - radius >> 4; z <= pos.func_177952_p() + radius >> 4; ++z) {
                Chunk chunk = Helper.getLoadedChunk(world, x, z);
                if (chunk == null) continue;
                for (BlockPos tilePos : chunk.func_203066_o()) {
                    if (!(tilePos.func_177951_i((Vec3i)pos) <= (double)(radius * radius)) || !consumer.apply(chunk.func_175625_s(tilePos)).booleanValue()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void getAuraChunksInArea(World world, BlockPos pos, int radius, Consumer<AuraChunk> consumer) {
        for (int x = pos.func_177958_n() - radius >> 4; x <= pos.func_177958_n() + radius >> 4; ++x) {
            for (int z = pos.func_177952_p() - radius >> 4; z <= pos.func_177952_p() + radius >> 4; ++z) {
                AuraChunk auraChunk;
                Chunk chunk = Helper.getLoadedChunk((IWorld)world, x, z);
                if (chunk == null || (auraChunk = (AuraChunk)chunk.getCapability(NaturesAuraAPI.capAuraChunk, null).orElse(null)) == null) continue;
                consumer.accept(auraChunk);
            }
        }
    }

    public static List<ItemFrameEntity> getAttachedItemFrames(World world, BlockPos pos) {
        List frames = world.func_217357_a(ItemFrameEntity.class, new AxisAlignedBB(pos).func_186662_g(0.25));
        for (int i = frames.size() - 1; i >= 0; --i) {
            ItemFrameEntity frame = (ItemFrameEntity)frames.get(i);
            BlockPos framePos = frame.func_174857_n().func_177972_a(frame.func_174811_aO().func_176734_d());
            if (pos.equals((Object)framePos)) continue;
            frames.remove(i);
        }
        return frames;
    }

    public static Chunk getLoadedChunk(IWorld world, int x, int z) {
        AbstractChunkProvider provider = world.func_72863_F();
        if (provider.func_222865_a(new ChunkPos(x, z))) {
            return provider.func_217205_a(x, z, false);
        }
        return null;
    }

    public static int blendColors(int c1, int c2, float ratio) {
        int a = (int)((float)(c1 >> 24 & 0xFF) * ratio + (float)(c2 >> 24 & 0xFF) * (1.0f - ratio));
        int r = (int)((float)(c1 >> 16 & 0xFF) * ratio + (float)(c2 >> 16 & 0xFF) * (1.0f - ratio));
        int g = (int)((float)(c1 >> 8 & 0xFF) * ratio + (float)(c2 >> 8 & 0xFF) * (1.0f - ratio));
        int b = (int)((float)(c1 & 0xFF) * ratio + (float)(c2 & 0xFF) * (1.0f - ratio));
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static boolean areItemsEqual(ItemStack first, ItemStack second, boolean nbt) {
        if (!ItemStack.func_179545_c((ItemStack)first, (ItemStack)second)) {
            return false;
        }
        return !nbt || ItemStack.func_77970_a((ItemStack)first, (ItemStack)second);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderItemInWorld(ItemStack stack) {
        if (!stack.func_190926_b()) {
            GlStateManager.pushMatrix();
            GlStateManager.disableLighting();
            RenderHelper.func_74519_b();
            Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
            RenderHelper.func_74518_a();
            GlStateManager.enableLighting();
            GlStateManager.popMatrix();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderItemInGui(ItemStack stack, int x, int y, float scale) {
        GlStateManager.pushMatrix();
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)770, (int)771);
        RenderHelper.func_74520_c();
        GlStateManager.enableDepthTest();
        GlStateManager.enableRescaleNormal();
        GlStateManager.translatef((float)x, (float)y, (float)0.0f);
        GlStateManager.scalef((float)scale, (float)scale, (float)scale);
        Minecraft.func_71410_x().func_175599_af().func_180450_b(stack, 0, 0);
        Minecraft.func_71410_x().func_175599_af().func_180453_a(Minecraft.func_71410_x().field_71466_p, stack, 0, 0, null);
        RenderHelper.func_74518_a();
        GlStateManager.popMatrix();
    }

    public static boolean putStackOnTile(PlayerEntity player, Hand hand, BlockPos pos, int slot, boolean sound) {
        IItemHandlerModifiable handler;
        TileEntity tile = player.field_70170_p.func_175625_s(pos);
        if (tile instanceof TileEntityImpl && (handler = ((TileEntityImpl)tile).getItemHandler(null)) != null) {
            ItemStack remain;
            ItemStack handStack = player.func_184586_b(hand);
            if (!handStack.func_190926_b() && !ItemStack.func_77989_b((ItemStack)(remain = handler.insertItem(slot, handStack, player.field_70170_p.field_72995_K)), (ItemStack)handStack)) {
                if (sound) {
                    player.field_70170_p.func_184148_a(player, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187620_cL, SoundCategory.PLAYERS, 0.75f, 1.0f);
                }
                if (!player.field_70170_p.field_72995_K) {
                    player.func_184611_a(hand, remain);
                }
                return true;
            }
            if (!handler.getStackInSlot(slot).func_190926_b()) {
                if (sound) {
                    player.field_70170_p.func_184148_a(player, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187629_cO, SoundCategory.PLAYERS, 0.75f, 1.0f);
                }
                if (!player.field_70170_p.field_72995_K) {
                    ItemStack stack = handler.getStackInSlot(slot);
                    if (!player.func_191521_c(stack)) {
                        ItemEntity item = new ItemEntity(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, stack);
                        player.field_70170_p.func_217376_c((Entity)item);
                    }
                    handler.setStackInSlot(slot, ItemStack.field_190927_a);
                }
                return true;
            }
        }
        return false;
    }

    public static ICapabilityProvider makeRechargeProvider(final ItemStack stack, final boolean needsSelected) {
        return new ICapabilityProvider(){
            private final IAuraRecharge recharge = (container, containerSlot, itemSlot, isSelected) -> {
                if (isSelected || !needsSelected) {
                    return Helper.rechargeAuraItem(stack, container, 300);
                }
                return false;
            };

            @Nullable
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
                if (capability == NaturesAuraAPI.capAuraRecharge) {
                    return LazyOptional.of(() -> this.recharge);
                }
                return LazyOptional.empty();
            }
        };
    }

    public static boolean rechargeAuraItem(ItemStack stack, IAuraContainer container, int toDrain) {
        if (stack.func_77952_i() > 0 && container.drainAura(toDrain, true) >= toDrain) {
            stack.func_196085_b(stack.func_77952_i() - 1);
            container.drainAura(toDrain, false);
            return true;
        }
        return false;
    }

    public static BlockState getStateFromString(String raw) {
        String[] split = raw.split("\\[");
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(split[0]));
        if (block != null) {
            BlockState state = block.func_176223_P();
            if (split.length > 1) {
                block0: for (String part : split[1].replace("]", "").split(",")) {
                    String[] keyValue = part.split("=");
                    for (IProperty prop : state.func_206869_a()) {
                        BlockState changed = Helper.findProperty(state, prop, keyValue[0], keyValue[1]);
                        if (changed == null) continue;
                        state = changed;
                        continue block0;
                    }
                }
            }
            return state;
        }
        return null;
    }

    private static <T extends Comparable<T>> BlockState findProperty(BlockState state, IProperty<T> prop, String key, String newValue) {
        if (key.equals(prop.func_177701_a())) {
            for (Comparable value : prop.func_177700_c()) {
                if (!prop.func_177702_a(value).equals(newValue)) continue;
                return (BlockState)state.func_206870_a(prop, value);
            }
        }
        return null;
    }

    public static <T> void registerCap(Class<T> type) {
        CapabilityManager.INSTANCE.register(type, new Capability.IStorage<T>(){

            public void readNBT(Capability<T> capability, T instance, Direction side, INBT nbt) {
            }

            @Nullable
            public INBT writeNBT(Capability capability, Object instance, Direction side) {
                return null;
            }
        }, () -> null);
    }

    public static void addAdvancement(PlayerEntity player, ResourceLocation advancement, String criterion) {
        if (!(player instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity playerMp = (ServerPlayerEntity)player;
        Advancement adv = playerMp.func_71121_q().func_73046_m().func_191949_aK().func_192778_a(advancement);
        if (adv != null) {
            playerMp.func_192039_O().func_192750_a(adv, criterion);
        }
    }

    public static int getIngredientAmount(Ingredient ingredient) {
        int highestAmount = 0;
        for (ItemStack stack : ingredient.func_193365_a()) {
            if (stack.func_190916_E() <= highestAmount) continue;
            highestAmount = stack.func_190916_E();
        }
        return highestAmount;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderWeirdBox(double x, double y, double z, double width, double height, double depth) {
        GL11.glVertex3d((double)x, (double)(y + height), (double)z);
        GL11.glVertex3d((double)(x + width), (double)(y + height), (double)z);
        GL11.glVertex3d((double)(x + width), (double)y, (double)z);
        GL11.glVertex3d((double)x, (double)y, (double)z);
        GL11.glVertex3d((double)(x + width), (double)y, (double)(z + depth));
        GL11.glVertex3d((double)(x + width), (double)y, (double)z);
        GL11.glVertex3d((double)(x + width), (double)(y + height), (double)z);
        GL11.glVertex3d((double)(x + width), (double)(y + height), (double)(z + depth));
        GL11.glVertex3d((double)(x + width), (double)(y + height), (double)(z + depth));
        GL11.glVertex3d((double)x, (double)(y + height), (double)(z + depth));
        GL11.glVertex3d((double)x, (double)y, (double)(z + depth));
        GL11.glVertex3d((double)(x + width), (double)y, (double)(z + depth));
        GL11.glVertex3d((double)x, (double)(y + height), (double)(z + depth));
        GL11.glVertex3d((double)x, (double)(y + height), (double)z);
        GL11.glVertex3d((double)x, (double)y, (double)z);
        GL11.glVertex3d((double)x, (double)y, (double)(z + depth));
        GL11.glVertex3d((double)x, (double)(y + height), (double)z);
        GL11.glVertex3d((double)x, (double)(y + height), (double)(z + depth));
        GL11.glVertex3d((double)(x + width), (double)(y + height), (double)(z + depth));
        GL11.glVertex3d((double)(x + width), (double)(y + height), (double)z);
        GL11.glVertex3d((double)(x + width), (double)y, (double)z);
        GL11.glVertex3d((double)(x + width), (double)y, (double)(z + depth));
        GL11.glVertex3d((double)x, (double)y, (double)(z + depth));
        GL11.glVertex3d((double)x, (double)y, (double)z);
    }

    public static boolean isHoldingItem(PlayerEntity player, Item item) {
        for (Hand hand : Hand.values()) {
            ItemStack stack = player.func_184586_b(hand);
            if (stack.func_190926_b() || stack.func_77973_b() != item) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmpty(IItemHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public static AxisAlignedBB aabb(Vec3d pos) {
        return new AxisAlignedBB(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
    }

    public static <T extends IForgeRegistryEntry<T>> void populateObjectHolders(Class clazz, IForgeRegistry<T> registry) {
        for (Field entry : clazz.getFields()) {
            if (!Modifier.isStatic(entry.getModifiers())) continue;
            ResourceLocation location = new ResourceLocation("naturesaura", entry.getName().toLowerCase(Locale.ROOT));
            if (!registry.containsKey(location)) {
                NaturesAura.LOGGER.fatal("Couldn't find entry named " + location + " in registry " + registry.getRegistryName());
                continue;
            }
            try {
                entry.set(null, registry.getValue(location));
            }
            catch (IllegalAccessException e) {
                NaturesAura.LOGGER.error((Object)e);
            }
        }
    }

    public static Block getWool(DyeColor color) {
        switch (color) {
            case ORANGE: {
                return Blocks.field_196557_aM;
            }
            case MAGENTA: {
                return Blocks.field_196558_aN;
            }
            case LIGHT_BLUE: {
                return Blocks.field_196559_aO;
            }
            case YELLOW: {
                return Blocks.field_196560_aP;
            }
            case LIME: {
                return Blocks.field_196561_aQ;
            }
            case PINK: {
                return Blocks.field_196562_aR;
            }
            case GRAY: {
                return Blocks.field_196563_aS;
            }
            case LIGHT_GRAY: {
                return Blocks.field_196564_aT;
            }
            case CYAN: {
                return Blocks.field_196565_aU;
            }
            case PURPLE: {
                return Blocks.field_196566_aV;
            }
            case BLUE: {
                return Blocks.field_196567_aW;
            }
            case BROWN: {
                return Blocks.field_196568_aX;
            }
            case GREEN: {
                return Blocks.field_196569_aY;
            }
            case RED: {
                return Blocks.field_196570_aZ;
            }
            case BLACK: {
                return Blocks.field_196602_ba;
            }
        }
        return Blocks.field_196556_aL;
    }

    public static ItemStack getEquippedItem(Predicate<ItemStack> predicate, PlayerEntity player) {
        Optional<ItemStack> stack;
        if (Compat.hasCompat("curios") && (stack = CuriosAPI.getCurioEquipped(predicate, (LivingEntity)player).map(ImmutableTriple::getRight)).isPresent()) {
            return stack.get();
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack slot = player.field_71071_by.func_70301_a(i);
            if (slot.func_190926_b() || !predicate.test(slot)) continue;
            return slot;
        }
        return ItemStack.field_190927_a;
    }
}

