/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.blocks.tiles.TileEntityImpl;
import de.ellpeck.naturesaura.reg.IModItem;
import de.ellpeck.naturesaura.reg.IModelProvider;
import de.ellpeck.naturesaura.reg.ModRegistry;
import de.ellpeck.naturesaura.reg.ModTileType;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;

public class BlockContainerImpl
extends ContainerBlock
implements IModItem,
IModelProvider {
    private final String baseName;
    private final ModTileType<? extends TileEntity> tileType;

    public BlockContainerImpl(String baseName, Supplier<TileEntity> tileSupplier, Block.Properties properties) {
        super(properties);
        this.baseName = baseName;
        this.tileType = new ModTileType<TileEntity>(tileSupplier, this);
        ModRegistry.add(this);
        ModRegistry.add(this.tileType);
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return this.tileType.type.func_200968_a();
    }

    @Override
    public String getBaseName() {
        return this.baseName;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public void func_176206_d(IWorld worldIn, BlockPos pos, BlockState state) {
        super.func_176206_d(worldIn, pos, state);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        List drops = super.func_220076_a(state, builder);
        TileEntity tile = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (tile instanceof TileEntityImpl) {
            for (ItemStack stack : drops) {
                if (stack.func_77973_b() != this.func_199767_j()) continue;
                ((TileEntityImpl)tile).modifyDrop(stack);
                break;
            }
        }
        return drops;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tile;
        if (state.func_177230_c() != newState.func_177230_c() && (tile = worldIn.func_175625_s(pos)) instanceof TileEntityImpl) {
            ((TileEntityImpl)tile).dropInventory();
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityImpl) {
            ((TileEntityImpl)tile).loadDataOnPlace(stack);
        }
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.updateRedstoneState(worldIn, pos);
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        this.updateRedstoneState(worldIn, pos);
    }

    private void updateRedstoneState(World world, BlockPos pos) {
        TileEntity tile;
        if (!world.field_72995_K && (tile = world.func_175625_s(pos)) instanceof TileEntityImpl) {
            TileEntityImpl impl = (TileEntityImpl)tile;
            int newPower = world.func_175687_A(pos);
            if (impl.redstonePower != newPower) {
                world.func_205220_G_().func_205360_a(pos, (Object)this, this.func_149738_a((IWorldReader)world));
            }
        }
    }

    public int func_149738_a(IWorldReader worldIn) {
        return 4;
    }

    public void func_196267_b(BlockState state, World worldIn, BlockPos pos, Random random) {
        TileEntity tile;
        if (!worldIn.field_72995_K && (tile = worldIn.func_175625_s(pos)) instanceof TileEntityImpl) {
            TileEntityImpl impl = (TileEntityImpl)tile;
            int newPower = worldIn.func_175687_A(pos);
            if (impl.redstonePower != newPower) {
                impl.onRedstonePowerChange(newPower);
            }
        }
    }
}

