/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.blocks.ModBlocks;
import de.ellpeck.naturesaura.items.ModItems;
import de.ellpeck.naturesaura.packet.PacketClient;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import de.ellpeck.naturesaura.reg.IModItem;
import de.ellpeck.naturesaura.reg.IModelProvider;
import de.ellpeck.naturesaura.reg.ModRegistry;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.RailShape;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;

public class BlockDimensionRail
extends AbstractRailBlock
implements IModItem,
IModelProvider {
    public static final EnumProperty<RailShape> SHAPE = BlockStateProperties.field_208165_R;
    private final String name;
    private final int goalDim;
    private final DimensionType[] canUseDims;

    public BlockDimensionRail(String name, DimensionType goalDim, DimensionType ... canUseDims) {
        super(false, ModBlocks.prop(Blocks.field_150448_aq));
        this.name = name;
        this.goalDim = goalDim.func_186068_a();
        this.canUseDims = canUseDims;
        ModRegistry.add(this);
    }

    private boolean canUseHere(DimensionType dimension) {
        for (DimensionType dim : this.canUseDims) {
            if (dim != dimension) continue;
            return true;
        }
        return false;
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == ModItems.RANGE_VISUALIZER) {
            if (!worldIn.field_72995_K) {
                BlockPos goalPos = this.getGoalCoords(worldIn, pos);
                PacketHandler.sendTo(player, new PacketClient(0, this.goalDim, goalPos.func_177958_n(), goalPos.func_177956_o(), goalPos.func_177952_p()));
            }
            return true;
        }
        return false;
    }

    public void onMinecartPass(BlockState state, World world, BlockPos pos, AbstractMinecartEntity cart) {
        if (world.field_72995_K) {
            return;
        }
        if (cart.func_184207_aI()) {
            return;
        }
        if (!this.canUseHere(world.func_201675_m().func_186058_p())) {
            return;
        }
        AxisAlignedBB box = cart.func_174813_aQ();
        PacketHandler.sendToAllAround((IWorld)world, pos, 32, new PacketParticles((float)box.field_72340_a, (float)box.field_72338_b, (float)box.field_72339_c, PacketParticles.Type.DIMENSION_RAIL, (int)((box.field_72336_d - box.field_72340_a) * 100.0), (int)((box.field_72337_e - box.field_72338_b) * 100.0), (int)((box.field_72334_f - box.field_72339_c) * 100.0)));
        world.func_184133_a(null, pos, SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 1.0f, 1.0f);
        BlockPos goalCoords = this.getGoalCoords(world, pos);
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(new StringTextComponent("CURRENTLY UNIMPLEMENTED - Waiting for a Forge change").func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
    }

    private BlockPos getGoalCoords(World world, BlockPos pos) {
        MinecraftServer server = world.func_73046_m();
        DimensionType goalDimType = DimensionType.func_186069_a((int)this.goalDim);
        if (this == ModBlocks.DIMENSION_RAIL_NETHER) {
            return new BlockPos(pos.func_177958_n() / 8, pos.func_177956_o() / 2, pos.func_177952_p() / 8);
        }
        if (this == ModBlocks.DIMENSION_RAIL_END) {
            ServerWorld end = server.func_71218_a(goalDimType);
            return end.func_180504_m().func_177981_b(8);
        }
        if (world.func_201675_m().func_186058_p() == DimensionType.field_223228_b_) {
            return new BlockPos(pos.func_177958_n() * 8, pos.func_177956_o() * 2, pos.func_177952_p() * 8);
        }
        ServerWorld overworld = server.func_71218_a(goalDimType);
        BlockPos spawn = overworld.func_175694_M();
        BlockPos ret = new BlockPos(spawn.func_177958_n(), 0, spawn.func_177952_p());
        return ret.func_177981_b(overworld.func_201676_a(Heightmap.Type.WORLD_SURFACE, spawn.func_177958_n(), spawn.func_177952_p()));
    }

    public IProperty<RailShape> func_176560_l() {
        return SHAPE;
    }

    public boolean isFlexibleRail(BlockState state, IBlockReader world, BlockPos pos) {
        return false;
    }

    public boolean canMakeSlopes(BlockState state, IBlockReader world, BlockPos pos) {
        return false;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{SHAPE});
    }

    @Override
    public String getBaseName() {
        return "dimension_rail_" + this.name;
    }
}

