/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.blocks.BlockContainerImpl;
import de.ellpeck.naturesaura.blocks.ModBlocks;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityGratedChute;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.HopperBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.IHopper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandlerModifiable;

public class BlockGratedChute
extends BlockContainerImpl {
    public static final DirectionProperty FACING = HopperBlock.field_176430_a;
    private static final VoxelShape INPUT_SHAPE = Block.func_208617_a((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape MIDDLE_SHAPE = Block.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0);
    private static final VoxelShape INPUT_MIDDLE_SHAPE = VoxelShapes.func_197872_a((VoxelShape)MIDDLE_SHAPE, (VoxelShape)INPUT_SHAPE);
    private static final VoxelShape COMBINED_SHAPE = VoxelShapes.func_197878_a((VoxelShape)INPUT_MIDDLE_SHAPE, (VoxelShape)IHopper.field_200101_a, (IBooleanFunction)IBooleanFunction.field_223234_e_);
    private static final VoxelShape DOWN_SHAPE = VoxelShapes.func_197872_a((VoxelShape)COMBINED_SHAPE, (VoxelShape)Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0));
    private static final VoxelShape EAST_SHAPE = VoxelShapes.func_197872_a((VoxelShape)COMBINED_SHAPE, (VoxelShape)Block.func_208617_a((double)12.0, (double)4.0, (double)6.0, (double)16.0, (double)8.0, (double)10.0));
    private static final VoxelShape NORTH_SHAPE = VoxelShapes.func_197872_a((VoxelShape)COMBINED_SHAPE, (VoxelShape)Block.func_208617_a((double)6.0, (double)4.0, (double)0.0, (double)10.0, (double)8.0, (double)4.0));
    private static final VoxelShape SOUTH_SHAPE = VoxelShapes.func_197872_a((VoxelShape)COMBINED_SHAPE, (VoxelShape)Block.func_208617_a((double)6.0, (double)4.0, (double)12.0, (double)10.0, (double)8.0, (double)16.0));
    private static final VoxelShape WEST_SHAPE = VoxelShapes.func_197872_a((VoxelShape)COMBINED_SHAPE, (VoxelShape)Block.func_208617_a((double)0.0, (double)4.0, (double)6.0, (double)4.0, (double)8.0, (double)10.0));
    private static final VoxelShape DOWN_RAYTRACE_SHAPE = IHopper.field_200101_a;
    private static final VoxelShape EAST_RAYTRACE_SHAPE = VoxelShapes.func_197872_a((VoxelShape)IHopper.field_200101_a, (VoxelShape)Block.func_208617_a((double)12.0, (double)8.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0));
    private static final VoxelShape NORTH_RAYTRACE_SHAPE = VoxelShapes.func_197872_a((VoxelShape)IHopper.field_200101_a, (VoxelShape)Block.func_208617_a((double)6.0, (double)8.0, (double)0.0, (double)10.0, (double)10.0, (double)4.0));
    private static final VoxelShape SOUTH_RAYTRACE_SHAPE = VoxelShapes.func_197872_a((VoxelShape)IHopper.field_200101_a, (VoxelShape)Block.func_208617_a((double)6.0, (double)8.0, (double)12.0, (double)10.0, (double)10.0, (double)16.0));
    private static final VoxelShape WEST_RAYTRACE_SHAPE = VoxelShapes.func_197872_a((VoxelShape)IHopper.field_200101_a, (VoxelShape)Block.func_208617_a((double)0.0, (double)8.0, (double)6.0, (double)4.0, (double)10.0, (double)10.0));

    public BlockGratedChute() {
        super("grated_chute", TileEntityGratedChute::new, ModBlocks.prop(Material.field_151573_f).func_200948_a(3.0f, 8.0f).func_200947_a(SoundType.field_185852_e));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((IProperty)FACING)) {
            case DOWN: {
                return DOWN_SHAPE;
            }
            case NORTH: {
                return NORTH_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
            case EAST: {
                return EAST_SHAPE;
            }
        }
        return COMBINED_SHAPE;
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        switch ((Direction)state.func_177229_b((IProperty)FACING)) {
            case DOWN: {
                return DOWN_RAYTRACE_SHAPE;
            }
            case NORTH: {
                return NORTH_RAYTRACE_SHAPE;
            }
            case SOUTH: {
                return SOUTH_RAYTRACE_SHAPE;
            }
            case WEST: {
                return WEST_RAYTRACE_SHAPE;
            }
            case EAST: {
                return EAST_RAYTRACE_SHAPE;
            }
        }
        return IHopper.field_200101_a;
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!player.func_70093_af()) {
            return false;
        }
        TileEntity tile = worldIn.func_175625_s(pos);
        if (!(tile instanceof TileEntityGratedChute)) {
            return false;
        }
        if (!worldIn.field_72995_K) {
            TileEntityGratedChute chute = (TileEntityGratedChute)tile;
            chute.isBlacklist = !chute.isBlacklist;
            chute.sendToClients();
        }
        return true;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction newFacing = context.func_196000_l().func_176734_d();
        if (newFacing == Direction.UP) {
            newFacing = Direction.DOWN;
        }
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)newFacing);
    }

    @Override
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityGratedChute) {
            IItemHandlerModifiable handler = ((TileEntityGratedChute)tile).getItemHandler(null);
            ItemStack stack = handler.getStackInSlot(0);
            if (stack.func_190926_b()) {
                return 0;
            }
            return MathHelper.func_76123_f((float)((float)stack.func_190916_E() / (float)stack.func_77976_d() * 15.0f));
        }
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
    }
}

