/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.api.render.IVisualizable;
import de.ellpeck.naturesaura.blocks.BlockContainerImpl;
import de.ellpeck.naturesaura.blocks.ModBlocks;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityOakGenerator;
import java.util.Random;
import net.minecraft.block.SaplingBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.SaplingGrowTreeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BlockOakGenerator
extends BlockContainerImpl
implements IVisualizable {
    public BlockOakGenerator() {
        super("oak_generator", TileEntityOakGenerator::new, ModBlocks.prop(Material.field_151575_d).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onTreeGrow(SaplingGrowTreeEvent event) {
        IWorld world = event.getWorld();
        BlockPos pos = event.getPos();
        if (!world.func_201670_d() && IAuraType.forWorld(world).isSimilar(NaturesAuraAPI.TYPE_OVERWORLD) && world.func_180495_p(pos).func_177230_c() instanceof SaplingBlock) {
            Helper.getTileEntitiesInArea(world, pos, 10, tile -> {
                long seed;
                if (!(tile instanceof TileEntityOakGenerator)) {
                    return false;
                }
                Random rand = event.getRand();
                if (rand.nextInt(10) == 0) {
                    ((TileEntityOakGenerator)tile).scheduledBigTrees.add(pos);
                }
                do {
                    seed = rand.nextLong();
                    rand.setSeed(seed);
                } while (rand.nextInt(10) == 0);
                rand.setSeed(seed);
                return true;
            });
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getVisualizationBounds(World world, BlockPos pos) {
        return new AxisAlignedBB(pos).func_186662_g(10.0);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getVisualizationColor(World world, BlockPos pos) {
        return 3045905;
    }
}

