/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.blocks.BlockContainerImpl;
import de.ellpeck.naturesaura.blocks.ModBlocks;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityProjectileGenerator;
import de.ellpeck.naturesaura.blocks.tiles.render.RenderProjectileGenerator;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import de.ellpeck.naturesaura.reg.ITESRProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BlockProjectileGenerator
extends BlockContainerImpl
implements ITESRProvider {
    public BlockProjectileGenerator() {
        super("projectile_generator", TileEntityProjectileGenerator::new, ModBlocks.prop(Material.field_151576_e).func_200943_b(2.5f).func_200947_a(SoundType.field_185851_d));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onProjectileImpact(ProjectileImpactEvent event) {
        Entity entity = event.getEntity();
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        RayTraceResult ray = event.getRayTraceResult();
        if (!(ray instanceof BlockRayTraceResult)) {
            return;
        }
        BlockRayTraceResult blockRay = (BlockRayTraceResult)ray;
        BlockPos pos = blockRay.func_216350_a();
        if (pos == null) {
            return;
        }
        TileEntity tile = entity.field_70170_p.func_175625_s(pos);
        if (!(tile instanceof TileEntityProjectileGenerator)) {
            return;
        }
        TileEntityProjectileGenerator generator = (TileEntityProjectileGenerator)tile;
        if (generator.nextSide != blockRay.func_216354_b()) {
            return;
        }
        Integer amount = NaturesAuraAPI.PROJECTILE_GENERATIONS.get(entity.func_200600_R());
        if (amount == null || amount <= 0) {
            return;
        }
        if (!generator.canGenerateRightNow(35, amount)) {
            return;
        }
        BlockPos spot = IAuraChunk.getLowestSpot((IWorld)entity.field_70170_p, pos, 35, pos);
        IAuraChunk.getAuraChunk((IWorld)entity.field_70170_p, spot).storeAura(spot, amount);
        PacketHandler.sendToAllAround((IWorld)entity.field_70170_p, pos, 32, new PacketParticles((float)entity.field_70165_t, (float)entity.field_70163_u, (float)entity.field_70161_v, PacketParticles.Type.PROJECTILE_GEN, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
        entity.field_70170_p.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187528_aR, SoundCategory.BLOCKS, 0.8f, 1.0f);
        generator.nextSide = generator.nextSide.func_176746_e();
        generator.sendToClients();
        entity.func_70106_y();
        event.setCanceled(true);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Tuple<Class, TileEntityRenderer> getTESR() {
        return new Tuple(TileEntityProjectileGenerator.class, (Object)new RenderProjectileGenerator());
    }
}

