/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.render.IVisualizable;
import de.ellpeck.naturesaura.blocks.BlockContainerImpl;
import de.ellpeck.naturesaura.blocks.ModBlocks;
import de.ellpeck.naturesaura.blocks.tiles.TileEntitySpawnLamp;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.MobEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BlockSpawnLamp
extends BlockContainerImpl
implements IVisualizable {
    private static final VoxelShape SHAPE = VoxelShapes.func_197873_a((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.8125, (double)0.75);

    public BlockSpawnLamp() {
        super("spawn_lamp", TileEntitySpawnLamp::new, ModBlocks.prop(Material.field_151573_f).func_200943_b(3.0f).func_200951_a(15).func_200947_a(SoundType.field_185852_e));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (event.getSpawner() != null) {
            return;
        }
        IWorld world = event.getWorld();
        BlockPos pos = new BlockPos(event.getX(), event.getY(), event.getZ());
        Helper.getTileEntitiesInArea(world, pos, 48, tile -> {
            if (!(tile instanceof TileEntitySpawnLamp)) {
                return false;
            }
            TileEntitySpawnLamp lamp = (TileEntitySpawnLamp)((Object)tile);
            int range = lamp.getRadius();
            if (range <= 0) {
                return false;
            }
            BlockPos lampPos = lamp.func_174877_v();
            if (!new AxisAlignedBB(lampPos).func_186662_g((double)range).func_72318_a(new Vec3d((Vec3i)pos))) {
                return false;
            }
            MobEntity entity = (MobEntity)event.getEntityLiving();
            if (entity.func_213380_a(world, event.getSpawnReason()) && entity.func_205019_a((IWorldReader)world)) {
                BlockPos spot = IAuraChunk.getHighestSpot(world, lampPos, 32, lampPos);
                IAuraChunk.getAuraChunk(world, spot).drainAura(spot, 200);
                PacketHandler.sendToAllAround(world, lampPos, 32, new PacketParticles(lampPos.func_177958_n(), lampPos.func_177956_o(), lampPos.func_177952_p(), PacketParticles.Type.SPAWN_LAMP, new int[0]));
            }
            event.setResult(Event.Result.DENY);
            return true;
        });
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getVisualizationBounds(World world, BlockPos pos) {
        int radius;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntitySpawnLamp && (radius = ((TileEntitySpawnLamp)tile).getRadius()) > 0) {
            return new AxisAlignedBB(pos).func_186662_g((double)radius);
        }
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getVisualizationColor(World world, BlockPos pos) {
        return 8543973;
    }
}

