/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.multiblock.Matcher;
import de.ellpeck.naturesaura.api.recipes.TreeRitualRecipe;
import de.ellpeck.naturesaura.blocks.BlockContainerImpl;
import de.ellpeck.naturesaura.blocks.ModBlocks;
import de.ellpeck.naturesaura.blocks.multi.Multiblocks;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityWoodStand;
import de.ellpeck.naturesaura.blocks.tiles.render.RenderWoodStand;
import de.ellpeck.naturesaura.reg.ITESRProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.world.SaplingGrowTreeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.mutable.MutableObject;

public class BlockWoodStand
extends BlockContainerImpl
implements ITESRProvider {
    private static final VoxelShape SHAPE = VoxelShapes.func_197873_a((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)0.8125, (double)0.8125);

    public BlockWoodStand() {
        super("wood_stand", TileEntityWoodStand::new, ModBlocks.prop(Material.field_151575_d).func_200943_b(1.5f).func_200947_a(SoundType.field_185848_a).harvestLevel(0).harvestTool(ToolType.AXE));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    @SubscribeEvent
    public void onTreeGrow(SaplingGrowTreeEvent event) {
        BlockState sapling;
        ItemStack saplingStack;
        IWorld world = event.getWorld();
        BlockPos pos = event.getPos();
        if (!world.func_201670_d() && Multiblocks.TREE_RITUAL.isComplete(world, pos) && !(saplingStack = (sapling = world.func_180495_p(pos)).func_177230_c().func_185473_a((IBlockReader)world, pos, sapling)).func_190926_b()) {
            for (TreeRitualRecipe recipe : NaturesAuraAPI.TREE_RITUAL_RECIPES.values()) {
                MutableObject toPick;
                ArrayList<Ingredient> required;
                boolean fine;
                if (!recipe.saplingType.test(saplingStack) || !(fine = Multiblocks.TREE_RITUAL.forEach(pos, 'W', (arg_0, arg_1) -> BlockWoodStand.lambda$onTreeGrow$0(world, required = new ArrayList<Ingredient>(Arrays.asList(recipe.ingredients)), toPick = new MutableObject(), arg_0, arg_1))) || !required.isEmpty()) continue;
                ((TileEntityWoodStand)((Object)toPick.getValue())).setRitual(pos, recipe);
                break;
            }
        }
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        return Helper.putStackOnTile(player, handIn, pos, 0, true);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Tuple<Class, TileEntityRenderer> getTESR() {
        return new Tuple(TileEntityWoodStand.class, (Object)new RenderWoodStand());
    }

    private static /* synthetic */ Boolean lambda$onTreeGrow$0(IWorld world, List required, MutableObject toPick, BlockPos tilePos, Matcher matcher) {
        TileEntity tile = world.func_175625_s(tilePos);
        if (tile instanceof TileEntityWoodStand) {
            TileEntityWoodStand stand = (TileEntityWoodStand)tile;
            ItemStack stack = stand.items.getStackInSlot(0);
            if (!stack.func_190926_b()) {
                for (int i = required.size() - 1; i >= 0; --i) {
                    Ingredient req = (Ingredient)required.get(i);
                    if (!req.test(stack)) continue;
                    required.remove(i);
                    if (toPick.getValue() == null) {
                        toPick.setValue((Object)stand);
                    }
                    return true;
                }
                return false;
            }
        }
        return true;
    }
}

