/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.NaturesAura;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.blocks.BlockFurnaceHeater;
import de.ellpeck.naturesaura.blocks.tiles.ModTileEntities;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityImpl;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticleStream;
import java.lang.reflect.Field;
import net.minecraft.block.AbstractFurnaceBlock;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.tileentity.BlastFurnaceTileEntity;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.SmokerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class TileEntityFurnaceHeater
extends TileEntityImpl
implements ITickableTileEntity {
    private static final Field FURNACE_DATA_FIELD = ObfuscationReflectionHelper.findField(AbstractFurnaceTileEntity.class, (String)"field_214013_b");
    public boolean isActive;

    public TileEntityFurnaceHeater() {
        super(ModTileEntities.FURNACE_HEATER);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 5L == 0L) {
            AbstractFurnaceTileEntity furnace;
            boolean did = false;
            Direction facing = (Direction)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockFurnaceHeater.FACING);
            BlockPos tilePos = this.field_174879_c.func_177972_a(facing.func_176734_d());
            TileEntity tile = this.field_145850_b.func_175625_s(tilePos);
            if (tile instanceof AbstractFurnaceTileEntity && this.isReady(furnace = (AbstractFurnaceTileEntity)tile)) {
                IIntArray data = TileEntityFurnaceHeater.getFurnaceData(furnace);
                int burnTime = data.func_221476_a(0);
                if (burnTime <= 0) {
                    this.field_145850_b.func_175656_a(tilePos, (BlockState)this.field_145850_b.func_180495_p(tilePos).func_206870_a((IProperty)AbstractFurnaceBlock.field_220091_b, (Comparable)Boolean.valueOf(true)));
                }
                data.func_221477_a(0, 200);
                data.func_221477_a(2, Math.min(data.func_221476_a(3) - 1, data.func_221476_a(2) + 5));
                BlockPos spot = IAuraChunk.getHighestSpot((IWorld)this.field_145850_b, this.field_174879_c, 20, this.field_174879_c);
                IAuraChunk chunk = IAuraChunk.getAuraChunk((IWorld)this.field_145850_b, spot);
                chunk.drainAura(spot, MathHelper.func_76123_f((float)((float)(200 - burnTime) * 16.6f)));
                did = true;
                if (this.field_145850_b.func_82737_E() % 15L == 0L) {
                    PacketHandler.sendToAllAround((IWorld)this.field_145850_b, this.field_174879_c, 32, new PacketParticleStream((float)this.field_174879_c.func_177958_n() + (float)this.field_145850_b.field_73012_v.nextGaussian() * 5.0f, (float)(this.field_174879_c.func_177956_o() + 1) + this.field_145850_b.field_73012_v.nextFloat() * 5.0f, (float)this.field_174879_c.func_177952_p() + (float)this.field_145850_b.field_73012_v.nextGaussian() * 5.0f, (float)tilePos.func_177958_n() + this.field_145850_b.field_73012_v.nextFloat(), (float)tilePos.func_177956_o() + this.field_145850_b.field_73012_v.nextFloat(), (float)tilePos.func_177952_p() + this.field_145850_b.field_73012_v.nextFloat(), this.field_145850_b.field_73012_v.nextFloat() * 0.07f + 0.07f, IAuraType.forWorld((IWorld)this.field_145850_b).getColor(), this.field_145850_b.field_73012_v.nextFloat() + 0.5f));
                }
            }
            if (did != this.isActive) {
                this.isActive = did;
                this.sendToClients();
            }
        }
    }

    public static IIntArray getFurnaceData(AbstractFurnaceTileEntity tile) {
        try {
            return (IIntArray)FURNACE_DATA_FIELD.get(tile);
        }
        catch (IllegalAccessException e) {
            NaturesAura.LOGGER.fatal("Couldn't reflect furnace field", (Throwable)e);
            return null;
        }
    }

    private boolean isReady(AbstractFurnaceTileEntity furnace) {
        if (!furnace.func_70301_a(1).func_190926_b()) {
            return false;
        }
        ItemStack input = furnace.func_70301_a(0);
        if (!input.func_190926_b()) {
            AbstractCookingRecipe recipe = this.field_145850_b.func_199532_z().func_215371_a(TileEntityFurnaceHeater.getRecipeType(furnace), (IInventory)furnace, this.field_145850_b).orElse(null);
            if (recipe == null) {
                return false;
            }
            ItemStack output = recipe.func_77571_b();
            ItemStack currOutput = furnace.func_70301_a(2);
            return currOutput.func_190926_b() || Helper.areItemsEqual(currOutput, output, true) && currOutput.func_190916_E() + output.func_190916_E() <= output.func_77976_d();
        }
        return false;
    }

    public static IRecipeType<? extends AbstractCookingRecipe> getRecipeType(AbstractFurnaceTileEntity furnace) {
        if (furnace instanceof BlastFurnaceTileEntity) {
            return IRecipeType.field_222151_c;
        }
        if (furnace instanceof SmokerTileEntity) {
            return IRecipeType.field_222152_d;
        }
        return IRecipeType.field_222150_b;
    }

    @Override
    public void writeNBT(CompoundNBT compound, TileEntityImpl.SaveType type) {
        super.writeNBT(compound, type);
        if (type == TileEntityImpl.SaveType.SYNC) {
            compound.func_74757_a("active", this.isActive);
        }
    }

    @Override
    public void readNBT(CompoundNBT compound, TileEntityImpl.SaveType type) {
        super.readNBT(compound, type);
        if (type == TileEntityImpl.SaveType.SYNC) {
            this.isActive = compound.func_74767_n("active");
        }
    }
}

