/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.container.BasicAuraContainer;
import de.ellpeck.naturesaura.api.aura.container.IAuraContainer;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.api.recipes.AltarRecipe;
import de.ellpeck.naturesaura.blocks.multi.Multiblocks;
import de.ellpeck.naturesaura.blocks.tiles.ItemStackHandlerNA;
import de.ellpeck.naturesaura.blocks.tiles.ModTileEntities;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityImpl;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticleStream;
import de.ellpeck.naturesaura.packet.PacketParticles;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityNatureAltar
extends TileEntityImpl
implements ITickableTileEntity {
    public final ItemStackHandler items = new ItemStackHandlerNA(1, this, true){

        public int getSlotLimit(int slot) {
            return 1;
        }

        @Override
        protected boolean canInsert(ItemStack stack, int slot) {
            return TileEntityNatureAltar.this.getRecipeForInput(stack) != null || stack.getCapability(NaturesAuraAPI.capAuraContainer, null).isPresent();
        }

        @Override
        protected boolean canExtract(ItemStack stack, int slot, int amount) {
            IAuraContainer cap = (IAuraContainer)stack.getCapability(NaturesAuraAPI.capAuraContainer, null).orElse(null);
            if (cap != null) {
                return cap.storeAura(1, true) <= 0;
            }
            return TileEntityNatureAltar.this.getRecipeForInput(stack) == null;
        }
    };
    @OnlyIn(value=Dist.CLIENT)
    public int bobTimer;
    private final BasicAuraContainer container = new BasicAuraContainer(NaturesAuraAPI.TYPE_OVERWORLD, 500000);
    private final ItemStack[] catalysts = new ItemStack[4];
    public boolean structureFine;
    private AltarRecipe currentRecipe;
    private int timer;
    private int lastAura;

    public TileEntityNatureAltar() {
        super(ModTileEntities.NATURE_ALTAR);
    }

    public void func_73660_a() {
        Random rand = this.field_145850_b.field_73012_v;
        if (this.field_145850_b.func_82737_E() % 40L == 0L) {
            int index = 0;
            for (int x = -2; x <= 2; x += 4) {
                for (int z = -2; z <= 2; z += 4) {
                    BlockPos offset = this.field_174879_c.func_177982_a(x, 1, z);
                    BlockState state = this.field_145850_b.func_180495_p(offset);
                    this.catalysts[index] = state.func_177230_c().func_185473_a((IBlockReader)this.field_145850_b, offset, state);
                    ++index;
                }
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            boolean fine;
            if (this.field_145850_b.func_82737_E() % 40L == 0L && (fine = Multiblocks.ALTAR.isComplete((IWorld)this.field_145850_b, this.field_174879_c)) != this.structureFine) {
                this.structureFine = fine;
                this.sendToClients();
            }
            if (this.structureFine) {
                int toStore;
                int space = this.container.storeAura(300, true);
                if (space > 0 && this.container.isAcceptableType(IAuraType.forWorld((IWorld)this.field_145850_b)) && (toStore = Math.min(IAuraChunk.getAuraInArea((IWorld)this.field_145850_b, this.field_174879_c, 20), space)) > 0) {
                    BlockPos spot = IAuraChunk.getHighestSpot((IWorld)this.field_145850_b, this.field_174879_c, 20, this.field_174879_c);
                    IAuraChunk chunk = IAuraChunk.getAuraChunk((IWorld)this.field_145850_b, spot);
                    chunk.drainAura(spot, toStore);
                    this.container.storeAura(toStore, false);
                    if (this.field_145850_b.func_82737_E() % 3L == 0L) {
                        PacketHandler.sendToAllAround((IWorld)this.field_145850_b, this.field_174879_c, 32, new PacketParticleStream((float)this.field_174879_c.func_177958_n() + (float)rand.nextGaussian() * 10.0f, (float)this.field_174879_c.func_177956_o() + rand.nextFloat() * 10.0f, (float)this.field_174879_c.func_177952_p() + (float)rand.nextGaussian() * 10.0f, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 0.5f, (float)this.field_174879_c.func_177952_p() + 0.5f, rand.nextFloat() * 0.1f + 0.1f, 9030711, rand.nextFloat() * 1.0f + 1.0f));
                    }
                }
                ItemStack stack = this.items.getStackInSlot(0);
                IAuraContainer container = (IAuraContainer)stack.getCapability(NaturesAuraAPI.capAuraContainer, null).orElse(null);
                if (!stack.func_190926_b() && container != null) {
                    int stored;
                    int theoreticalDrain = this.container.drainAura(1000, true);
                    if (theoreticalDrain > 0 && (stored = container.storeAura(theoreticalDrain, false)) > 0) {
                        this.container.drainAura(stored, false);
                        if (this.field_145850_b.func_82737_E() % 4L == 0L) {
                            PacketHandler.sendToAllAround((IWorld)this.field_145850_b, this.field_174879_c, 32, new PacketParticles(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), PacketParticles.Type.ALTAR_CONVERSION, new int[0]));
                        }
                    }
                } else if (this.currentRecipe == null) {
                    if (!stack.func_190926_b()) {
                        this.currentRecipe = this.getRecipeForInput(stack);
                    }
                } else if (stack.func_190926_b() || !this.currentRecipe.input.test(stack)) {
                    this.currentRecipe = null;
                    this.timer = 0;
                } else {
                    int req = MathHelper.func_76143_f((double)((double)this.currentRecipe.aura / (double)this.currentRecipe.time));
                    if (this.container.getStoredAura() >= req) {
                        this.container.drainAura(req, false);
                        if (this.timer % 4 == 0) {
                            PacketHandler.sendToAllAround((IWorld)this.field_145850_b, this.field_174879_c, 32, new PacketParticles(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), PacketParticles.Type.ALTAR_CONVERSION, new int[0]));
                        }
                        ++this.timer;
                        if (this.timer >= this.currentRecipe.time) {
                            this.items.setStackInSlot(0, this.currentRecipe.output.func_77946_l());
                            this.currentRecipe = null;
                            this.timer = 0;
                            this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, SoundEvents.field_187734_u, SoundCategory.BLOCKS, 0.65f, 1.0f);
                        }
                    }
                }
            }
            if (this.field_145850_b.func_82737_E() % 10L == 0L && this.lastAura != this.container.getStoredAura()) {
                this.lastAura = this.container.getStoredAura();
                this.sendToClients();
            }
        } else {
            if (this.structureFine && rand.nextFloat() >= 0.7f) {
                int fourths = this.container.getMaxAura() / 4;
                if (this.container.getStoredAura() > 0) {
                    NaturesAuraAPI.instance().spawnMagicParticle((float)this.field_174879_c.func_177958_n() - 4.0f + rand.nextFloat(), (float)this.field_174879_c.func_177956_o() + 3.0f, (float)this.field_174879_c.func_177952_p() + rand.nextFloat(), 0.0, 0.0, 0.0, this.container.getAuraColor(), rand.nextFloat() * 3.0f + 1.0f, rand.nextInt(100) + 50, -0.05f, true, true);
                }
                if (this.container.getStoredAura() >= fourths) {
                    NaturesAuraAPI.instance().spawnMagicParticle((float)this.field_174879_c.func_177958_n() + 4.0f + rand.nextFloat(), (float)this.field_174879_c.func_177956_o() + 3.0f, (float)this.field_174879_c.func_177952_p() + rand.nextFloat(), 0.0, 0.0, 0.0, this.container.getAuraColor(), rand.nextFloat() * 3.0f + 1.0f, rand.nextInt(100) + 50, -0.05f, true, true);
                }
                if (this.container.getStoredAura() >= fourths * 2) {
                    NaturesAuraAPI.instance().spawnMagicParticle((float)this.field_174879_c.func_177958_n() + rand.nextFloat(), (float)this.field_174879_c.func_177956_o() + 3.0f, (float)this.field_174879_c.func_177952_p() - 4.0f + rand.nextFloat(), 0.0, 0.0, 0.0, this.container.getAuraColor(), rand.nextFloat() * 3.0f + 1.0f, rand.nextInt(100) + 50, -0.05f, true, true);
                }
                if (this.container.getStoredAura() >= fourths * 3) {
                    NaturesAuraAPI.instance().spawnMagicParticle((float)this.field_174879_c.func_177958_n() + rand.nextFloat(), (float)this.field_174879_c.func_177956_o() + 3.0f, (float)this.field_174879_c.func_177952_p() + 4.0f + rand.nextFloat(), 0.0, 0.0, 0.0, this.container.getAuraColor(), rand.nextFloat() * 3.0f + 1.0f, rand.nextInt(100) + 50, -0.05f, true, true);
                }
            }
            ++this.bobTimer;
        }
    }

    private AltarRecipe getRecipeForInput(ItemStack input) {
        for (AltarRecipe recipe : NaturesAuraAPI.ALTAR_RECIPES.values()) {
            if (!recipe.input.test(input)) continue;
            if (recipe.catalyst == Ingredient.field_193370_a) {
                return recipe;
            }
            for (ItemStack stack : this.catalysts) {
                if (!recipe.catalyst.test(stack)) continue;
                return recipe;
            }
        }
        return null;
    }

    @Override
    public void writeNBT(CompoundNBT compound, TileEntityImpl.SaveType type) {
        super.writeNBT(compound, type);
        if (type != TileEntityImpl.SaveType.BLOCK) {
            compound.func_218657_a("items", (INBT)this.items.serializeNBT());
            compound.func_74757_a("fine", this.structureFine);
            this.container.writeNBT(compound);
        }
        if (type == TileEntityImpl.SaveType.TILE && this.currentRecipe != null) {
            compound.func_74778_a("recipe", this.currentRecipe.name.toString());
            compound.func_74768_a("timer", this.timer);
        }
    }

    @Override
    public void readNBT(CompoundNBT compound, TileEntityImpl.SaveType type) {
        super.readNBT(compound, type);
        if (type != TileEntityImpl.SaveType.BLOCK) {
            this.items.deserializeNBT(compound.func_74775_l("items"));
            this.structureFine = compound.func_74767_n("fine");
            this.container.readNBT(compound);
        }
        if (type == TileEntityImpl.SaveType.TILE && compound.func_74764_b("recipe")) {
            this.currentRecipe = NaturesAuraAPI.ALTAR_RECIPES.get(new ResourceLocation(compound.func_74779_i("recipe")));
            this.timer = compound.func_74762_e("timer");
        }
    }

    @Override
    public IAuraContainer getAuraContainer(Direction facing) {
        return this.container;
    }

    @Override
    public IItemHandlerModifiable getItemHandler(Direction facing) {
        return this.items;
    }
}

