/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.recipes.TreeRitualRecipe;
import de.ellpeck.naturesaura.blocks.multi.Multiblocks;
import de.ellpeck.naturesaura.blocks.tiles.ItemStackHandlerNA;
import de.ellpeck.naturesaura.blocks.tiles.ModTileEntities;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityImpl;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticleStream;
import de.ellpeck.naturesaura.packet.PacketParticles;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.LogBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityWoodStand
extends TileEntityImpl
implements ITickableTileEntity {
    public final ItemStackHandler items = new ItemStackHandlerNA(1, this, true){

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    private TreeRitualRecipe recipe;
    private BlockPos ritualPos;
    private int timer;

    public TileEntityWoodStand() {
        super(ModTileEntities.WOOD_STAND);
    }

    public void setRitual(BlockPos pos, TreeRitualRecipe recipe) {
        this.ritualPos = pos;
        this.recipe = recipe;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.ritualPos != null && this.recipe != null && this.field_145850_b.func_82737_E() % 5L == 0L) {
            if (this.isRitualOkay()) {
                boolean isOverHalf;
                boolean wasOverHalf = this.timer >= this.recipe.time / 2;
                this.timer += 5;
                boolean bl = isOverHalf = this.timer >= this.recipe.time / 2;
                if (!isOverHalf) {
                    Multiblocks.TREE_RITUAL.forEach(this.ritualPos, 'W', (pos, matcher) -> {
                        TileEntity tile = this.field_145850_b.func_175625_s(pos);
                        if (tile instanceof TileEntityWoodStand && !((TileEntityWoodStand)tile).items.getStackInSlot(0).func_190926_b()) {
                            PacketHandler.sendToAllAround((IWorld)this.field_145850_b, this.field_174879_c, 32, new PacketParticleStream((float)pos.func_177958_n() + 0.2f + this.field_145850_b.field_73012_v.nextFloat() * 0.6f, (float)pos.func_177956_o() + 0.85f, (float)pos.func_177952_p() + 0.2f + this.field_145850_b.field_73012_v.nextFloat() * 0.6f, (float)this.ritualPos.func_177958_n() + 0.5f, (float)this.ritualPos.func_177956_o() + this.field_145850_b.field_73012_v.nextFloat() * 3.0f + 2.0f, (float)this.ritualPos.func_177952_p() + 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.04f + 0.04f, 9030711, this.field_145850_b.field_73012_v.nextFloat() * 1.0f + 1.0f));
                        }
                        return true;
                    });
                }
                PacketHandler.sendToAllAround((IWorld)this.field_145850_b, this.ritualPos, 32, new PacketParticles(this.ritualPos.func_177958_n(), this.ritualPos.func_177956_o(), this.ritualPos.func_177952_p(), PacketParticles.Type.TR_GOLD_POWDER, new int[0]));
                if (this.timer >= this.recipe.time) {
                    this.recurseTreeDestruction(this.ritualPos, this.ritualPos);
                    Multiblocks.TREE_RITUAL.forEach(this.ritualPos, 'G', (pos, matcher) -> {
                        this.field_145850_b.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                        return true;
                    });
                    ItemEntity item = new ItemEntity(this.field_145850_b, (double)this.ritualPos.func_177958_n() + 0.5, (double)this.ritualPos.func_177956_o() + 4.5, (double)this.ritualPos.func_177952_p() + 0.5, this.recipe.result.func_77946_l());
                    this.field_145850_b.func_217376_c((Entity)item);
                    PacketHandler.sendToAllAround((IWorld)this.field_145850_b, this.field_174879_c, 32, new PacketParticles((float)item.field_70165_t, (float)item.field_70163_u, (float)item.field_70161_v, PacketParticles.Type.TR_SPAWN_RESULT, new int[0]));
                    this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 0.65f, 1.0f);
                    this.ritualPos = null;
                    this.recipe = null;
                    this.timer = 0;
                } else if (isOverHalf && !wasOverHalf) {
                    Multiblocks.TREE_RITUAL.forEach(this.ritualPos, 'W', (pos, matcher) -> {
                        TileEntity tile = this.field_145850_b.func_175625_s(pos);
                        if (tile instanceof TileEntityWoodStand) {
                            TileEntityWoodStand stand = (TileEntityWoodStand)tile;
                            if (!stand.items.getStackInSlot(0).func_190926_b()) {
                                PacketHandler.sendToAllAround((IWorld)this.field_145850_b, this.field_174879_c, 32, new PacketParticles(stand.field_174879_c.func_177958_n(), stand.field_174879_c.func_177956_o(), stand.field_174879_c.func_177952_p(), PacketParticles.Type.TR_CONSUME_ITEM, new int[0]));
                                this.field_145850_b.func_184148_a(null, (double)stand.field_174879_c.func_177958_n() + 0.5, (double)stand.field_174879_c.func_177956_o() + 0.5, (double)stand.field_174879_c.func_177952_p() + 0.5, SoundEvents.field_187897_gY, SoundCategory.BLOCKS, 0.5f, 1.0f);
                                stand.items.setStackInSlot(0, ItemStack.field_190927_a);
                                stand.sendToClients();
                            }
                        }
                        return true;
                    });
                }
            } else {
                this.ritualPos = null;
                this.recipe = null;
                this.timer = 0;
            }
        }
    }

    private void recurseTreeDestruction(BlockPos pos, BlockPos start) {
        if (Math.abs(pos.func_177958_n() - start.func_177958_n()) >= 6 || Math.abs(pos.func_177952_p() - start.func_177952_p()) >= 6 || Math.abs(pos.func_177956_o() - start.func_177956_o()) >= 16) {
            return;
        }
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos offset = pos.func_177982_a(x, y, z);
                    BlockState state = this.field_145850_b.func_180495_p(offset);
                    if (!(state.func_177230_c() instanceof LogBlock) && !(state.func_177230_c() instanceof LeavesBlock)) continue;
                    this.field_145850_b.func_175656_a(offset, Blocks.field_150350_a.func_176223_P());
                    PacketHandler.sendToAllAround((IWorld)this.field_145850_b, this.field_174879_c, 32, new PacketParticles(offset.func_177958_n(), offset.func_177956_o(), offset.func_177952_p(), PacketParticles.Type.TR_DISAPPEAR, new int[0]));
                    this.recurseTreeDestruction(offset, start);
                }
            }
        }
    }

    private boolean isRitualOkay() {
        if (!Multiblocks.TREE_RITUAL.isComplete((IWorld)this.field_145850_b, this.ritualPos)) {
            return false;
        }
        for (int i = 0; i < 2; ++i) {
            BlockState state = this.field_145850_b.func_180495_p(this.ritualPos.func_177981_b(i));
            if (state.func_177230_c() instanceof LogBlock) continue;
            return false;
        }
        if (this.timer < this.recipe.time / 2) {
            ArrayList<Ingredient> required = new ArrayList<Ingredient>(Arrays.asList(this.recipe.ingredients));
            boolean fine = Multiblocks.TREE_RITUAL.forEach(this.ritualPos, 'W', (pos, matcher) -> {
                ItemStack stack;
                TileEntity tile = this.field_145850_b.func_175625_s(pos);
                if (tile instanceof TileEntityWoodStand && !(stack = ((TileEntityWoodStand)tile).items.getStackInSlot(0)).func_190926_b()) {
                    for (int i = required.size() - 1; i >= 0; --i) {
                        Ingredient req = (Ingredient)required.get(i);
                        if (!req.test(stack)) continue;
                        required.remove(i);
                        return true;
                    }
                    return false;
                }
                return true;
            });
            return fine && required.isEmpty();
        }
        return true;
    }

    @Override
    public void writeNBT(CompoundNBT compound, TileEntityImpl.SaveType type) {
        super.writeNBT(compound, type);
        if (type != TileEntityImpl.SaveType.BLOCK) {
            compound.func_218657_a("items", (INBT)this.items.serializeNBT());
        }
        if (type == TileEntityImpl.SaveType.TILE && this.ritualPos != null && this.recipe != null) {
            compound.func_74772_a("ritual_pos", this.ritualPos.func_218275_a());
            compound.func_74768_a("timer", this.timer);
            compound.func_74778_a("recipe", this.recipe.name.toString());
        }
    }

    @Override
    public void readNBT(CompoundNBT compound, TileEntityImpl.SaveType type) {
        super.readNBT(compound, type);
        if (type != TileEntityImpl.SaveType.BLOCK) {
            this.items.deserializeNBT(compound.func_74775_l("items"));
        }
        if (type == TileEntityImpl.SaveType.TILE && compound.func_74764_b("recipe")) {
            this.ritualPos = BlockPos.func_218283_e((long)compound.func_74763_f("ritual_pos"));
            this.timer = compound.func_74762_e("timer");
            this.recipe = NaturesAuraAPI.TREE_RITUAL_RECIPES.get(new ResourceLocation(compound.func_74779_i("recipe")));
        }
    }

    @Override
    public IItemHandlerModifiable getItemHandler(Direction facing) {
        return this.items;
    }
}

