/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles.render;

import com.mojang.blaze3d.platform.GlStateManager;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityEnderCrate;
import java.nio.FloatBuffer;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderEnderCrate
extends TileEntityRenderer<TileEntityEnderCrate> {
    private static final ResourceLocation END_SKY_TEXTURE = new ResourceLocation("textures/environment/end_sky.png");
    private static final ResourceLocation END_PORTAL_TEXTURE = new ResourceLocation("textures/entity/end_portal.png");
    private static final Random RANDOM = new Random(31100L);
    private static final FloatBuffer MODELVIEW = GLAllocation.func_74529_h((int)16);
    private static final FloatBuffer PROJECTION = GLAllocation.func_74529_h((int)16);
    private final FloatBuffer buffer = GLAllocation.func_74529_h((int)16);

    public void render(TileEntityEnderCrate tileEntityIn, double x, double y, double z, float partialTicks, int destroyStage) {
        GlStateManager.disableLighting();
        RANDOM.setSeed(31100L);
        GlStateManager.getMatrix((int)2982, (FloatBuffer)MODELVIEW);
        GlStateManager.getMatrix((int)2983, (FloatBuffer)PROJECTION);
        double d0 = x * x + y * y + z * z;
        int i = this.getPasses(d0);
        float f = this.getOffset();
        boolean flag = false;
        GameRenderer gamerenderer = Minecraft.func_71410_x().field_71460_t;
        for (int j = 0; j < i; ++j) {
            GlStateManager.pushMatrix();
            float f1 = 2.0f / (float)(18 - j);
            if (j == 0) {
                this.func_147499_a(END_SKY_TEXTURE);
                f1 = 0.15f;
                GlStateManager.enableBlend();
                GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            }
            if (j >= 1) {
                this.func_147499_a(END_PORTAL_TEXTURE);
                flag = true;
                gamerenderer.func_191514_d(true);
            }
            if (j == 1) {
                GlStateManager.enableBlend();
                GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            }
            GlStateManager.texGenMode((GlStateManager.TexGen)GlStateManager.TexGen.S, (int)9216);
            GlStateManager.texGenMode((GlStateManager.TexGen)GlStateManager.TexGen.T, (int)9216);
            GlStateManager.texGenMode((GlStateManager.TexGen)GlStateManager.TexGen.R, (int)9216);
            GlStateManager.texGenParam((GlStateManager.TexGen)GlStateManager.TexGen.S, (int)9474, (FloatBuffer)this.getBuffer(1.0f, 0.0f, 0.0f, 0.0f));
            GlStateManager.texGenParam((GlStateManager.TexGen)GlStateManager.TexGen.T, (int)9474, (FloatBuffer)this.getBuffer(0.0f, 1.0f, 0.0f, 0.0f));
            GlStateManager.texGenParam((GlStateManager.TexGen)GlStateManager.TexGen.R, (int)9474, (FloatBuffer)this.getBuffer(0.0f, 0.0f, 1.0f, 0.0f));
            GlStateManager.enableTexGen((GlStateManager.TexGen)GlStateManager.TexGen.S);
            GlStateManager.enableTexGen((GlStateManager.TexGen)GlStateManager.TexGen.T);
            GlStateManager.enableTexGen((GlStateManager.TexGen)GlStateManager.TexGen.R);
            GlStateManager.popMatrix();
            GlStateManager.matrixMode((int)5890);
            GlStateManager.pushMatrix();
            GlStateManager.loadIdentity();
            GlStateManager.translatef((float)0.5f, (float)0.5f, (float)0.0f);
            GlStateManager.scalef((float)0.5f, (float)0.5f, (float)1.0f);
            float f2 = j + 1;
            GlStateManager.translatef((float)(17.0f / f2), (float)((2.0f + f2 / 1.5f) * ((float)System.currentTimeMillis() % 800000.0f / 800000.0f)), (float)0.0f);
            GlStateManager.rotatef((float)((f2 * f2 * 4321.0f + f2 * 9.0f) * 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.scalef((float)(4.5f - f2 / 4.0f), (float)(4.5f - f2 / 4.0f), (float)1.0f);
            GlStateManager.multMatrix((FloatBuffer)PROJECTION);
            GlStateManager.multMatrix((FloatBuffer)MODELVIEW);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            float f3 = (RANDOM.nextFloat() * 0.5f + 0.1f) * f1;
            float f4 = (RANDOM.nextFloat() * 0.5f + 0.4f) * f1;
            float f5 = (RANDOM.nextFloat() * 0.5f + 0.5f) * f1;
            float indent = 0.121875f;
            bufferbuilder.func_181662_b(x + (double)indent, y + (double)f, z - (double)indent + 1.0).func_181666_a(f3, f4, f5, 1.0f).func_181675_d();
            bufferbuilder.func_181662_b(x - (double)indent + 1.0, y + (double)f, z - (double)indent + 1.0).func_181666_a(f3, f4, f5, 1.0f).func_181675_d();
            bufferbuilder.func_181662_b(x - (double)indent + 1.0, y + (double)f, z + (double)indent).func_181666_a(f3, f4, f5, 1.0f).func_181675_d();
            bufferbuilder.func_181662_b(x + (double)indent, y + (double)f, z + (double)indent).func_181666_a(f3, f4, f5, 1.0f).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.popMatrix();
            GlStateManager.matrixMode((int)5888);
            this.func_147499_a(END_SKY_TEXTURE);
        }
        GlStateManager.disableBlend();
        GlStateManager.disableTexGen((GlStateManager.TexGen)GlStateManager.TexGen.S);
        GlStateManager.disableTexGen((GlStateManager.TexGen)GlStateManager.TexGen.T);
        GlStateManager.disableTexGen((GlStateManager.TexGen)GlStateManager.TexGen.R);
        GlStateManager.enableLighting();
        if (flag) {
            gamerenderer.func_191514_d(false);
        }
    }

    protected int getPasses(double dist) {
        int i = dist > 36864.0 ? 1 : (dist > 25600.0 ? 3 : (dist > 16384.0 ? 5 : (dist > 9216.0 ? 7 : (dist > 4096.0 ? 9 : (dist > 1024.0 ? 11 : (dist > 576.0 ? 13 : (dist > 256.0 ? 14 : 15)))))));
        return i;
    }

    protected float getOffset() {
        return 1.001f;
    }

    private FloatBuffer getBuffer(float a, float b, float c, float d) {
        this.buffer.clear();
        this.buffer.put(a).put(b).put(c).put(d);
        this.buffer.flip();
        return this.buffer;
    }
}

