/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles.render;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityGeneratorLimitRemover;
import de.ellpeck.naturesaura.blocks.tiles.TileEntityImpl;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.model.RendererModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderGeneratorLimitRemover
extends TileEntityRenderer<TileEntityGeneratorLimitRemover> {
    private static final ResourceLocation RES = new ResourceLocation("naturesaura", "textures/models/generator_limit_remover_glint.png");
    private final ModelLimitRemoverGlint model = new ModelLimitRemoverGlint();

    public void render(TileEntityGeneratorLimitRemover te, double x, double y, double z, float partialTicks, int destroyStage) {
        TileEntity above = te.func_145831_w().func_175625_s(te.func_174877_v().func_177984_a());
        if (above instanceof TileEntityImpl && ((TileEntityImpl)above).wantsLimitRemover()) {
            this.renderGlint(x, y + 1.0, z);
            this.renderGlint(x, y, z);
        }
    }

    private void renderGlint(double x, double y, double z) {
        GlStateManager.pushMatrix();
        RenderHelper.func_74519_b();
        GlStateManager.enableAlphaTest();
        GlStateManager.enableBlend();
        GlStateManager.alphaFunc((int)516, (float)0.003921569f);
        GlStateManager.depthMask((boolean)false);
        int brightness = 0xF000F0;
        int j = brightness % 65536;
        int k = brightness / 65536;
        GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)j, (float)k);
        float alpha = ((float)Math.sin((double)System.currentTimeMillis() / 800.0) + 1.0f) / 2.0f;
        GlStateManager.color4f((float)alpha, (float)alpha, (float)alpha, (float)alpha);
        GlStateManager.translated((double)(x - (double)0.001f), (double)(y + 1.0 + (double)0.001f), (double)(z + 1.0 + (double)0.001f));
        GlStateManager.rotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.scalef((float)1.002f, (float)1.002f, (float)1.002f);
        this.func_147499_a(RES);
        this.model.render();
        GlStateManager.depthMask((boolean)true);
        GlStateManager.alphaFunc((int)516, (float)0.1f);
        GlStateManager.disableAlphaTest();
        GlStateManager.disableBlend();
        GlStateManager.popMatrix();
    }

    private static class ModelLimitRemoverGlint
    extends Model {
        private final RendererModel box = new RendererModel((Model)this, 0, 0);

        public ModelLimitRemoverGlint() {
            this.box.func_78787_b(64, 64);
            this.box.func_78789_a(0.0f, 0.0f, 0.0f, 16, 16, 16);
        }

        public void render() {
            this.box.func_78785_a(0.0625f);
        }
    }
}

