/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.chunk.effect;

import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.chunk.IDrainSpotEffect;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.blocks.ModBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.GrassBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class GrassDieEffect
implements IDrainSpotEffect {
    public static final ResourceLocation NAME = new ResourceLocation("naturesaura", "grass_die");
    private int amount;
    private int dist;

    private boolean calcValues(World world, BlockPos pos, Integer spot) {
        int aura;
        if (spot < 0 && (aura = IAuraChunk.getAuraInArea((IWorld)world, pos, 50)) < 0) {
            this.amount = Math.min(300, MathHelper.func_76123_f((float)((float)Math.abs(aura) / 100000.0f / (float)IAuraChunk.getSpotAmountInArea((IWorld)world, pos, 50))));
            if (this.amount > 1) {
                this.dist = MathHelper.func_76125_a((int)(Math.abs(aura) / 75000), (int)5, (int)75);
                return true;
            }
        }
        return false;
    }

    @Override
    public IDrainSpotEffect.ActiveType isActiveHere(PlayerEntity player, Chunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        if (!this.calcValues(player.field_70170_p, pos, spot)) {
            return IDrainSpotEffect.ActiveType.INACTIVE;
        }
        if (player.func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) > (double)(this.dist * this.dist)) {
            return IDrainSpotEffect.ActiveType.INACTIVE;
        }
        return IDrainSpotEffect.ActiveType.ACTIVE;
    }

    @Override
    public ItemStack getDisplayIcon() {
        return new ItemStack((IItemProvider)ModBlocks.DECAYED_LEAVES);
    }

    @Override
    public void update(World world, Chunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        if (!this.calcValues(world, pos, spot)) {
            return;
        }
        for (int i = this.amount / 2 + world.field_73012_v.nextInt(this.amount / 2); i >= 0; --i) {
            BlockPos grassPos = new BlockPos((double)pos.func_177958_n() + world.field_73012_v.nextGaussian() * (double)this.dist, (double)pos.func_177956_o() + world.field_73012_v.nextGaussian() * (double)this.dist, (double)pos.func_177952_p() + world.field_73012_v.nextGaussian() * (double)this.dist);
            if (!(grassPos.func_177951_i((Vec3i)pos) <= (double)(this.dist * this.dist)) || !world.func_175667_e(grassPos)) continue;
            BlockState state = world.func_180495_p(grassPos);
            Block block = state.func_177230_c();
            BlockState newState = null;
            if (block instanceof LeavesBlock) {
                newState = ModBlocks.DECAYED_LEAVES.func_176223_P();
            } else if (block instanceof GrassBlock) {
                newState = Blocks.field_196660_k.func_176223_P();
            } else if (block instanceof BushBlock) {
                newState = Blocks.field_150350_a.func_176223_P();
            }
            if (newState == null) continue;
            world.func_175656_a(grassPos, newState);
        }
    }

    @Override
    public boolean appliesHere(Chunk chunk, IAuraChunk auraChunk, IAuraType type) {
        return (Boolean)ModConfig.instance.grassDieEffect.get() != false && type.isSimilar(NaturesAuraAPI.TYPE_OVERWORLD);
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }
}

