/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.compat;

import com.google.common.collect.ImmutableMap;
import de.ellpeck.naturesaura.NaturesAura;
import de.ellpeck.naturesaura.compat.CuriosCompat;
import de.ellpeck.naturesaura.compat.ICompat;
import de.ellpeck.naturesaura.compat.crafttweaker.CraftTweakerCompat;
import de.ellpeck.naturesaura.compat.patchouli.PatchouliCompat;
import de.ellpeck.naturesaura.misc.ItemTagProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraftforge.fml.ModList;

public final class Compat {
    private static final Map<String, Supplier<ICompat>> MODULE_TYPES = ImmutableMap.builder().put((Object)"patchouli", PatchouliCompat::new).put((Object)"curios", CuriosCompat::new).put((Object)"crafttweaker", CraftTweakerCompat::new).build();
    private static final Map<String, ICompat> MODULES = new HashMap<String, ICompat>();

    public static void preInit() {
        Compat.populateModules(arg_0 -> ((ModList)ModList.get()).isLoaded(arg_0));
        MODULES.values().forEach(ICompat::preInit);
    }

    public static void preInitClient() {
        MODULES.values().forEach(ICompat::preInitClient);
    }

    public static void postInit() {
        MODULES.values().forEach(ICompat::postInit);
    }

    public static boolean hasCompat(String mod) {
        return MODULES.containsKey(mod);
    }

    public static void addItemTags(ItemTagProvider provider) {
        Compat.populateModules(s -> true);
        MODULES.values().forEach(m -> m.addItemTags(provider));
    }

    private static void populateModules(Predicate<String> isLoaded) {
        for (Map.Entry<String, Supplier<ICompat>> entry : MODULE_TYPES.entrySet()) {
            String id = entry.getKey();
            if (!isLoaded.test(id)) continue;
            MODULES.put(id, entry.getValue().get());
            NaturesAura.LOGGER.info("Loading compat module for mod " + id);
        }
    }
}

