/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.compat.jei;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import de.ellpeck.naturesaura.api.recipes.AnimalSpawnerRecipe;
import de.ellpeck.naturesaura.compat.jei.JEINaturesAuraPlugin;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class AnimalSpawnerCategory
implements IRecipeCategory<AnimalSpawnerRecipe> {
    private final IDrawable background;
    private final Map<EntityType, Entity> entityCache = new HashMap<EntityType, Entity>();

    public AnimalSpawnerCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(new ResourceLocation("naturesaura", "textures/gui/jei/animal_spawner.png"), 0, 0, 72, 86);
    }

    public ResourceLocation getUid() {
        return JEINaturesAuraPlugin.SPAWNER;
    }

    public Class<? extends AnimalSpawnerRecipe> getRecipeClass() {
        return AnimalSpawnerRecipe.class;
    }

    public String getTitle() {
        return I18n.func_135052_a((String)("container." + JEINaturesAuraPlugin.SPAWNER + ".name"), (Object[])new Object[0]);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return null;
    }

    public void setIngredients(AnimalSpawnerRecipe animalSpawnerRecipe, IIngredients iIngredients) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Ingredient ing : animalSpawnerRecipe.ingredients) {
            builder.add((Object[])ing.func_193365_a());
        }
        iIngredients.setInputs(VanillaTypes.ITEM, (List)builder.build());
        iIngredients.setOutput(VanillaTypes.ITEM, (Object)new ItemStack((IItemProvider)SpawnEggItem.func_200889_b((EntityType)animalSpawnerRecipe.entity)));
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, AnimalSpawnerRecipe recipe, IIngredients iIngredients) {
        IGuiItemStackGroup group = iRecipeLayout.getItemStacks();
        for (int i = 0; i < recipe.ingredients.length; ++i) {
            group.init(i, true, i * 18, 68);
            group.set(i, Arrays.asList(recipe.ingredients[i].func_193365_a()));
        }
    }

    public void draw(AnimalSpawnerRecipe recipe, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.func_71410_x();
        Entity entity = this.entityCache.get(recipe.entity);
        if (entity == null) {
            entity = recipe.makeEntity((World)minecraft.field_71441_e, 0.0, 0.0, 0.0);
            this.entityCache.put(recipe.entity, entity);
        }
        float size = Math.max(1.0f, Math.max(recipe.entity.func_220333_h(), recipe.entity.func_220344_i()));
        float rot = ((float)minecraft.field_71441_e.func_82737_E() + minecraft.func_184121_ak()) % 360.0f;
        AnimalSpawnerCategory.renderEntity(entity, 35.0f, 28.0f, rot, 100.0f / size * 0.4f, size * 0.5f);
        String name = recipe.entity.func_212546_e().func_150254_d();
        minecraft.field_71466_p.func_175063_a(name, 36.0f - (float)minecraft.field_71466_p.func_78256_a(name) / 2.0f, 55.0f, 0xFFFFFF);
    }

    private static void renderEntity(Entity entity, float x, float y, float rotation, float renderScale, float offset) {
        GlStateManager.enableColorMaterial();
        GlStateManager.pushMatrix();
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.translatef((float)x, (float)y, (float)50.0f);
        GlStateManager.scalef((float)(-renderScale), (float)renderScale, (float)renderScale);
        GlStateManager.translatef((float)0.0f, (float)offset, (float)0.0f);
        GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.rotatef((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        Minecraft.func_71410_x().func_175598_ae().field_78735_i = 180.0f;
        Minecraft.func_71410_x().func_175598_ae().func_188391_a(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        GlStateManager.popMatrix();
        RenderHelper.func_74518_a();
        GlStateManager.disableRescaleNormal();
        GlStateManager.activeTexture((int)GLX.GL_TEXTURE1);
        GlStateManager.disableTexture();
        GlStateManager.activeTexture((int)GLX.GL_TEXTURE0);
    }
}

