/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.compat.jei;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.container.IAuraContainer;
import de.ellpeck.naturesaura.blocks.ModBlocks;
import de.ellpeck.naturesaura.compat.jei.AltarCategory;
import de.ellpeck.naturesaura.compat.jei.AnimalSpawnerCategory;
import de.ellpeck.naturesaura.compat.jei.OfferingCategory;
import de.ellpeck.naturesaura.compat.jei.TreeRitualCategory;
import de.ellpeck.naturesaura.items.ItemAuraBottle;
import de.ellpeck.naturesaura.items.ItemEffectPowder;
import de.ellpeck.naturesaura.items.ModItems;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class JEINaturesAuraPlugin
implements IModPlugin {
    public static final ResourceLocation TREE_RITUAL = new ResourceLocation("naturesaura", "tree_ritual");
    public static final ResourceLocation ALTAR = new ResourceLocation("naturesaura", "altar");
    public static final ResourceLocation OFFERING = new ResourceLocation("naturesaura", "offering");
    public static final ResourceLocation SPAWNER = new ResourceLocation("naturesaura", "animal_spawner");

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("naturesaura", "jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper helper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new TreeRitualCategory(helper), new AltarCategory(helper), new OfferingCategory(helper), new AnimalSpawnerCategory(helper)});
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter(ModItems.EFFECT_POWDER, stack -> ItemEffectPowder.getEffect(stack).toString());
        registration.registerSubtypeInterpreter(ModItems.AURA_BOTTLE, stack -> ItemAuraBottle.getType(stack).getName().toString());
        ISubtypeInterpreter auraInterpreter = stack -> {
            IAuraContainer container = (IAuraContainer)stack.getCapability(NaturesAuraAPI.capAuraContainer).orElse(null);
            if (container != null) {
                return String.valueOf(container.getStoredAura());
            }
            return "";
        };
        registration.registerSubtypeInterpreter(ModItems.AURA_CACHE, auraInterpreter);
        registration.registerSubtypeInterpreter(ModItems.AURA_TROVE, auraInterpreter);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.GOLD_POWDER), new ResourceLocation[]{TREE_RITUAL});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.WOOD_STAND), new ResourceLocation[]{TREE_RITUAL});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.NATURE_ALTAR), new ResourceLocation[]{ALTAR});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.CONVERSION_CATALYST), new ResourceLocation[]{ALTAR});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.OFFERING_TABLE), new ResourceLocation[]{OFFERING});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.ANIMAL_SPAWNER), new ResourceLocation[]{SPAWNER});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(NaturesAuraAPI.TREE_RITUAL_RECIPES.values(), TREE_RITUAL);
        registration.addRecipes(NaturesAuraAPI.ALTAR_RECIPES.values(), ALTAR);
        registration.addRecipes(NaturesAuraAPI.OFFERING_RECIPES.values(), OFFERING);
        registration.addRecipes(NaturesAuraAPI.ANIMAL_SPAWNER_RECIPES.values(), SPAWNER);
    }
}

