/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.compat.patchouli;

import com.mojang.blaze3d.platform.GlStateManager;
import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.multiblock.Matcher;
import de.ellpeck.naturesaura.compat.ICompat;
import de.ellpeck.naturesaura.events.ClientEvents;
import de.ellpeck.naturesaura.misc.ItemTagProvider;
import de.ellpeck.naturesaura.renderers.SupporterFancyHandler;
import java.time.LocalDateTime;
import java.time.Month;
import java.util.Collections;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.config.GuiUtils;
import vazkii.patchouli.api.BookDrawScreenEvent;
import vazkii.patchouli.api.PatchouliAPI;

public class PatchouliCompat
implements ICompat {
    private static final ResourceLocation BOOK = new ResourceLocation("naturesaura", "book");

    @Override
    public void preInit() {
        PatchouliAPI.instance.setConfigFlag("naturesaura:rf_converter", ((Boolean)ModConfig.instance.rfConverter.get()).booleanValue());
        PatchouliAPI.instance.setConfigFlag("naturesaura:chunk_loader", ((Boolean)ModConfig.instance.chunkLoader.get()).booleanValue());
    }

    @Override
    public void preInitClient() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void addItemTags(ItemTagProvider provider) {
    }

    @Override
    public void postInit() {
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onBookDraw(BookDrawScreenEvent event) {
        String name;
        SupporterFancyHandler.FancyInfo info;
        if (event.book == null || !event.book.equals((Object)BOOK)) {
            return;
        }
        LocalDateTime now = LocalDateTime.now();
        if (now.getMonth() == Month.MAY && now.getDayOfMonth() == 21) {
            int x = event.gui.width / 2 + 136 - 16;
            int y = event.gui.height / 2 - 90 - 26;
            RenderHelper.func_74518_a();
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            event.gui.getMinecraft().func_110434_K().func_110577_a(ClientEvents.BOOK_GUI);
            AbstractGui.blit((int)x, (int)y, (float)469.0f, (float)0.0f, (int)43, (int)42, (int)512, (int)256);
            if (event.mouseX >= x && event.mouseY >= y && event.mouseX < x + 43 && event.mouseY < y + 42) {
                GuiUtils.drawHoveringText(Collections.singletonList(TextFormatting.GOLD + "It's the author Ellpeck's birthday!"), (int)event.mouseX, (int)event.mouseY, (int)event.gui.width, (int)event.gui.height, (int)0, (FontRenderer)event.gui.getMinecraft().field_71466_p);
            }
        }
        if ((info = SupporterFancyHandler.FANCY_INFOS.get(name = event.gui.getMinecraft().field_71439_g.func_200200_C_().func_150254_d())) != null) {
            int x = event.gui.width / 2 - 136 + 20;
            int y = event.gui.height / 2 + 90;
            RenderHelper.func_74518_a();
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            event.gui.getMinecraft().func_110434_K().func_110577_a(ClientEvents.BOOK_GUI);
            AbstractGui.blit((int)x, (int)y, (float)496.0f, (float)44.0f, (int)16, (int)18, (int)512, (int)256);
            if (info.tier == 1) {
                AbstractGui.blit((int)x, (int)y, (float)480.0f, (float)44.0f, (int)16, (int)18, (int)512, (int)256);
            } else {
                float r = (float)(info.color >> 16 & 0xFF) / 255.0f;
                float g = (float)(info.color >> 8 & 0xFF) / 255.0f;
                float b = (float)(info.color & 0xFF) / 255.0f;
                GlStateManager.color3f((float)r, (float)g, (float)b);
                AbstractGui.blit((int)x, (int)y, (float)464.0f, (float)44.0f, (int)16, (int)18, (int)512, (int)256);
            }
            if (event.mouseX >= x && event.mouseY >= y && event.mouseX < x + 16 && event.mouseY < y + 18) {
                GuiUtils.drawHoveringText(Collections.singletonList(TextFormatting.YELLOW + "Thanks for your support, " + name + "!"), (int)event.mouseX, (int)event.mouseY, (int)event.gui.width, (int)event.gui.height, (int)0, (FontRenderer)event.gui.getMinecraft().field_71466_p);
            }
        }
    }

    public static void addPatchouliMultiblock(ResourceLocation name, String[][] pattern, Object ... rawMatchers) {
        for (int i = 1; i < rawMatchers.length; i += 2) {
            if (!(rawMatchers[i] instanceof Matcher)) continue;
            Matcher matcher = (Matcher)rawMatchers[i];
            Matcher.ICheck check = matcher.getCheck();
            rawMatchers[i] = check == null ? PatchouliAPI.instance.anyMatcher() : PatchouliAPI.instance.predicateMatcher(matcher.getDefaultState(), state -> check.matches(null, null, null, null, (BlockState)state, '\u0000'));
        }
        PatchouliAPI.instance.registerMultiblock(name, PatchouliAPI.instance.makeMultiblock(pattern, rawMatchers));
    }

    public static <T> T getRecipe(Map<ResourceLocation, T> recipes, String name) {
        ResourceLocation res = new ResourceLocation(name);
        T recipe = recipes.get(res);
        if (recipe == null) {
            recipe = recipes.get(new ResourceLocation("crafttweaker", res.func_110623_a()));
        }
        return recipe;
    }
}

