/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.compat.patchouli;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.recipes.AnimalSpawnerRecipe;
import de.ellpeck.naturesaura.compat.patchouli.PatchouliCompat;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.util.IItemProvider;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariableProvider;
import vazkii.patchouli.api.PatchouliAPI;

public class ProcessorAnimalSpawner
implements IComponentProcessor {
    private AnimalSpawnerRecipe recipe;

    public void setup(IVariableProvider<String> provider) {
        this.recipe = PatchouliCompat.getRecipe(NaturesAuraAPI.ANIMAL_SPAWNER_RECIPES, (String)provider.get("recipe"));
    }

    public String process(String key) {
        if (this.recipe == null) {
            return null;
        }
        if (key.startsWith("input")) {
            int id = Integer.parseInt(key.substring(5)) - 1;
            if (this.recipe.ingredients.length > id) {
                return PatchouliAPI.instance.serializeIngredient(this.recipe.ingredients[id]);
            }
            return null;
        }
        switch (key) {
            case "name": {
                return this.recipe.entity.func_212546_e().func_150254_d();
            }
            case "entity": {
                return this.recipe.entity.getRegistryName().toString();
            }
            case "egg": {
                ItemStack egg = new ItemStack((IItemProvider)SpawnEggItem.func_200889_b((EntityType)this.recipe.entity));
                return PatchouliAPI.instance.serializeItemStack(egg);
            }
        }
        return null;
    }

    public boolean allowRender(String group) {
        return !"seekrit".equals(group);
    }
}

