/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.entities.render;

import com.mojang.blaze3d.platform.GlStateManager;
import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.entities.EntityEffectInhibitor;
import de.ellpeck.naturesaura.items.ItemEffectPowder;
import de.ellpeck.naturesaura.items.ModItems;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderEffectInhibitor
extends EntityRenderer<EntityEffectInhibitor> {
    private final Map<ResourceLocation, ItemStack> items = new HashMap<ResourceLocation, ItemStack>();

    public RenderEffectInhibitor(EntityRendererManager renderManager) {
        super(renderManager);
    }

    @Nullable
    protected ResourceLocation getEntityTexture(EntityEffectInhibitor entity) {
        return AtlasTexture.field_110575_b;
    }

    public void doRender(EntityEffectInhibitor entity, double x, double y, double z, float entityYaw, float partialTicks) {
        GlStateManager.pushMatrix();
        float time = (float)(entity.renderTicks + entity.func_145782_y()) + partialTicks;
        float bob = (float)Math.sin(time / 10.0f) * 0.05f;
        GlStateManager.translated((double)x, (double)(y + (double)0.15f + (double)bob), (double)z);
        GlStateManager.rotatef((float)(time * 3.0f % 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
        ResourceLocation effect = entity.getInhibitedEffect();
        Helper.renderItemInWorld(this.items.computeIfAbsent(effect, res -> ItemEffectPowder.setEffect(new ItemStack((IItemProvider)ModItems.EFFECT_POWDER), effect)));
        GlStateManager.popMatrix();
    }
}

