/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.events;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.NaturesAura;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.chunk.AuraChunk;
import de.ellpeck.naturesaura.chunk.AuraChunkProvider;
import de.ellpeck.naturesaura.misc.WorldData;
import de.ellpeck.naturesaura.packet.PacketHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class CommonEvents {
    private static final Method GET_LOADED_CHUNKS_METHOD = ObfuscationReflectionHelper.findMethod(ChunkManager.class, (String)"func_223491_f", (Class[])new Class[0]);

    @SubscribeEvent
    public void onChunkCapsAttach(AttachCapabilitiesEvent<Chunk> event) {
        Chunk chunk = (Chunk)event.getObject();
        event.addCapability(new ResourceLocation("naturesaura", "aura"), (ICapabilityProvider)new AuraChunkProvider(chunk));
    }

    @SubscribeEvent
    public void onWorldCapsAttach(AttachCapabilitiesEvent<World> event) {
        event.addCapability(new ResourceLocation("naturesaura", "data"), (ICapabilityProvider)new WorldData());
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (!event.world.field_72995_K && event.phase == TickEvent.Phase.END && event.world.func_82737_E() % 20L == 0L) {
            event.world.func_217381_Z().func_76320_a("naturesaura:onWorldTick");
            try {
                ChunkManager manager = ((ServerChunkProvider)event.world.func_72863_F()).field_217237_a;
                Iterable chunks = (Iterable)GET_LOADED_CHUNKS_METHOD.invoke((Object)manager, new Object[0]);
                for (ChunkHolder holder : chunks) {
                    AuraChunk auraChunk;
                    Chunk chunk = holder.func_219298_c();
                    if (chunk == null || (auraChunk = (AuraChunk)chunk.getCapability(NaturesAuraAPI.capAuraChunk, null).orElse(null)) == null) continue;
                    auraChunk.update();
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                NaturesAura.LOGGER.fatal((Object)e);
            }
            event.world.func_217381_Z().func_76319_b();
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!event.player.field_70170_p.field_72995_K && event.phase == TickEvent.Phase.END) {
            if (event.player.field_70170_p.func_82737_E() % 200L != 0L) {
                return;
            }
            int aura = IAuraChunk.triangulateAuraInArea((IWorld)event.player.field_70170_p, event.player.func_180425_c(), 25);
            if (aura <= 0) {
                Helper.addAdvancement(event.player, new ResourceLocation("naturesaura", "negative_imbalance"), "triggered_in_code");
            } else if (aura >= 1500000) {
                Helper.addAdvancement(event.player, new ResourceLocation("naturesaura", "positive_imbalance"), "triggered_in_code");
            }
        }
    }

    @SubscribeEvent
    public void onChunkWatch(ChunkWatchEvent.Watch event) {
        AuraChunk auraChunk;
        Chunk chunk = event.getWorld().func_212866_a_(event.getPos().field_77276_a, event.getPos().field_77275_b);
        if (!chunk.func_177412_p().field_72995_K && (auraChunk = (AuraChunk)chunk.getCapability(NaturesAuraAPI.capAuraChunk, null).orElse(null)) != null) {
            PacketHandler.sendTo((PlayerEntity)event.getPlayer(), auraChunk.makePacket());
        }
    }
}

