/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.gen;

import de.ellpeck.naturesaura.blocks.ModBlocks;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LogBlock;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class WorldGenAncientTree
extends AbstractTreeFeature<NoFeatureConfig> {
    public WorldGenAncientTree(boolean notify) {
        super(NoFeatureConfig::func_214639_a, notify);
    }

    protected boolean func_208519_a(Set changedBlocks, IWorldGenerationReader world, Random rand, BlockPos pos, MutableBoundingBox box) {
        int height = rand.nextInt(3) + 5;
        BlockPos trunkTop = pos.func_177981_b(height);
        int rootsAmount = rand.nextInt(4) + 5;
        for (int i = 0; i < rootsAmount; ++i) {
            int length = rand.nextInt(3) + 3;
            float angle = (float)Math.PI * 2 * ((float)i / (float)rootsAmount);
            float x = (float)Math.sin(angle) * (float)length;
            float z = (float)Math.cos(angle) * (float)length;
            BlockPos goal = pos.func_177963_a((double)x, 0.0, (double)z);
            while (!world.func_217375_a(goal, state -> state.func_185904_a().func_76222_j()) && !((goal = goal.func_177977_b()).func_177951_i((Vec3i)pos) >= 100.0)) {
            }
            this.makeBranch(changedBlocks, world, pos.func_177981_b(rand.nextInt(1)), goal, ModBlocks.ANCIENT_BARK.func_176223_P(), false);
        }
        for (int x = 0; x <= 1; ++x) {
            for (int z = 0; z <= 1; ++z) {
                for (int i = height - (x + z) * (rand.nextInt(2) + 2); i >= 0; --i) {
                    BlockPos goal = pos.func_177982_a(x, i, z);
                    if (!WorldGenAncientTree.func_214587_a((IWorldGenerationBaseReader)world, (BlockPos)goal)) continue;
                    this.func_202278_a((IWorldWriter)world, goal, (BlockState)ModBlocks.ANCIENT_LOG.func_176223_P().func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)Direction.Axis.Y));
                    changedBlocks.add(goal);
                }
            }
        }
        this.makeLeaves(changedBlocks, world, trunkTop.func_177981_b(rand.nextInt(2) - 1), ModBlocks.ANCIENT_LEAVES.func_176223_P(), rand.nextInt(2) + 3, rand);
        int branchAmount = rand.nextInt(3) + 4;
        for (int i = 0; i < branchAmount; ++i) {
            int length = rand.nextInt(2) + 3;
            float angle = (float)Math.PI * 2 * ((float)i / (float)branchAmount);
            float x = (float)Math.sin(angle) * (float)length;
            float z = (float)Math.cos(angle) * (float)length;
            BlockPos goal = trunkTop.func_177963_a((double)x, (double)(rand.nextInt(3) + 1), (double)z);
            this.makeBranch(changedBlocks, world, trunkTop, goal, ModBlocks.ANCIENT_LOG.func_176223_P(), true);
            this.makeLeaves(changedBlocks, world, goal, ModBlocks.ANCIENT_LEAVES.func_176223_P(), rand.nextInt(2) + 2, rand);
        }
        return true;
    }

    private void makeBranch(Set changedBlocks, IWorldGenerationReader world, BlockPos first, BlockPos second, BlockState state, boolean hasAxis) {
        BlockPos pos = second.func_177982_a(-first.func_177958_n(), -first.func_177956_o(), -first.func_177952_p());
        int length = this.getHighestCoord(pos);
        float stepX = (float)pos.func_177958_n() / (float)length;
        float stepY = (float)pos.func_177956_o() / (float)length;
        float stepZ = (float)pos.func_177952_p() / (float)length;
        for (int i = 0; i <= length; ++i) {
            BlockPos goal = first.func_177963_a((double)(0.5f + (float)i * stepX), (double)(0.5f + (float)i * stepY), (double)(0.5f + (float)i * stepZ));
            if (!WorldGenAncientTree.func_214587_a((IWorldGenerationBaseReader)world, (BlockPos)goal)) continue;
            if (hasAxis) {
                Direction.Axis axis = this.getLogAxis(first, goal);
                this.func_202278_a((IWorldWriter)world, goal, (BlockState)state.func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)axis));
            } else {
                this.func_202278_a((IWorldWriter)world, goal, state);
            }
            changedBlocks.add(goal);
        }
    }

    private void makeLeaves(Set changedBlocks, IWorldGenerationReader world, BlockPos pos, BlockState state, int radius, Random rand) {
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos goal = pos.func_177982_a(x, y, z);
                    if (!(pos.func_177951_i((Vec3i)goal) <= (double)(radius * radius + rand.nextInt(3) - 1)) || !WorldGenAncientTree.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)goal) || !world.func_217375_a(goal, st -> {
                        Block block = st.func_177230_c();
                        return !(block instanceof LogBlock) && block != Blocks.field_150346_d && block != Blocks.field_150349_c;
                    })) continue;
                    this.func_202278_a((IWorldWriter)world, goal, state);
                    changedBlocks.add(goal);
                }
            }
        }
    }

    private int getHighestCoord(BlockPos pos) {
        return Math.max(MathHelper.func_76130_a((int)pos.func_177958_n()), Math.max(MathHelper.func_76130_a((int)pos.func_177956_o()), MathHelper.func_76130_a((int)pos.func_177952_p())));
    }

    private Direction.Axis getLogAxis(BlockPos pos, BlockPos goal) {
        int y;
        Direction.Axis axis = Direction.Axis.Y;
        int x = Math.abs(goal.func_177958_n() - pos.func_177958_n());
        int highest = Math.max(x, y = Math.abs(goal.func_177952_p() - pos.func_177952_p()));
        if (highest > 0) {
            if (x == highest) {
                axis = Direction.Axis.X;
            } else if (y == highest) {
                axis = Direction.Axis.Z;
            }
        }
        return axis;
    }
}

