/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items;

import com.mojang.blaze3d.platform.GlStateManager;
import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.NaturesAura;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.container.IAuraContainer;
import de.ellpeck.naturesaura.api.aura.container.ItemAuraContainer;
import de.ellpeck.naturesaura.api.aura.item.IAuraRecharge;
import de.ellpeck.naturesaura.api.render.ITrinketItem;
import de.ellpeck.naturesaura.enchant.ModEnchantments;
import de.ellpeck.naturesaura.items.ItemImpl;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class ItemAuraCache
extends ItemImpl
implements ITrinketItem {
    private final int capacity;

    public ItemAuraCache(String name, int capacity) {
        super(name, new Item.Properties().func_200917_a(1).func_200916_a(NaturesAura.CREATIVE_TAB));
        this.capacity = capacity;
    }

    public void func_77663_a(ItemStack stackIn, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        PlayerEntity player;
        if (!worldIn.field_72995_K && entityIn instanceof PlayerEntity && (player = (PlayerEntity)entityIn).func_70093_af() && stackIn.getCapability(NaturesAuraAPI.capAuraContainer).isPresent()) {
            IAuraContainer container = (IAuraContainer)stackIn.getCapability(NaturesAuraAPI.capAuraContainer).orElse(null);
            if (container.getStoredAura() <= 0) {
                return;
            }
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                boolean isArmor;
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                IAuraRecharge recharge = (IAuraRecharge)stack.getCapability(NaturesAuraAPI.capAuraRecharge).orElse(null);
                if (recharge != null) {
                    if (!recharge.rechargeFromContainer(container, itemSlot, i, player.field_71071_by.field_70461_c == i)) continue;
                    break;
                }
                if (EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.AURA_MENDING, (ItemStack)stack) <= 0) continue;
                int mainSize = player.field_71071_by.field_70462_a.size();
                boolean bl = isArmor = i >= mainSize && i < mainSize + player.field_71071_by.field_70460_b.size();
                if ((isArmor || player.field_71071_by.field_70461_c == i) && Helper.rechargeAuraItem(stack, container, 1000)) break;
            }
        }
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((IItemProvider)this));
            ItemStack stack = new ItemStack((IItemProvider)this);
            stack.getCapability(NaturesAuraAPI.capAuraContainer).ifPresent(container -> {
                container.storeAura(container.getMaxAura(), false);
                items.add((Object)stack);
            });
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.getCapability(NaturesAuraAPI.capAuraContainer).isPresent()) {
            IAuraContainer container = (IAuraContainer)stack.getCapability(NaturesAuraAPI.capAuraContainer).orElse(null);
            return 1.0 - (double)container.getStoredAura() / (double)container.getMaxAura();
        }
        return 0.0;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundNBT nbt) {
        return new ICapabilityProvider(){
            private final ItemAuraContainer container;
            {
                this.container = new ItemAuraContainer(stack, null, ItemAuraCache.this.capacity);
            }

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
                if (capability == NaturesAuraAPI.capAuraContainer) {
                    return LazyOptional.of(() -> this.container);
                }
                return LazyOptional.empty();
            }
        };
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(ItemStack stack, PlayerEntity player, ITrinketItem.RenderType type, boolean isHolding) {
        if (type == ITrinketItem.RenderType.BODY && !isHolding) {
            boolean legs;
            boolean chest = !((ItemStack)player.field_71071_by.field_70460_b.get(EquipmentSlotType.CHEST.func_188454_b())).func_190926_b();
            boolean bl = legs = !((ItemStack)player.field_71071_by.field_70460_b.get(EquipmentSlotType.LEGS.func_188454_b())).func_190926_b();
            GlStateManager.translatef((float)-0.15f, (float)0.65f, (float)(chest ? -0.195f : (legs ? -0.165f : -0.1475f)));
            GlStateManager.scalef((float)0.25f, (float)0.25f, (float)0.25f);
            GlStateManager.rotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            Helper.renderItemInWorld(stack);
        }
    }
}

