/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items;

import com.google.common.base.Strings;
import de.ellpeck.naturesaura.NaturesAura;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.misc.IWorldData;
import de.ellpeck.naturesaura.blocks.BlockEnderCrate;
import de.ellpeck.naturesaura.gui.ContainerEnderCrate;
import de.ellpeck.naturesaura.gui.ModContainers;
import de.ellpeck.naturesaura.items.ItemImpl;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ItemEnderAccess
extends ItemImpl {
    public ItemEnderAccess() {
        super("ender_access", new Item.Properties().func_200916_a(NaturesAura.CREATIVE_TAB));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (handIn != Hand.MAIN_HAND) {
            return new ActionResult(ActionResultType.PASS, (Object)playerIn.func_184586_b(handIn));
        }
        ItemStack stack = playerIn.func_184614_ca();
        final String name = BlockEnderCrate.getEnderName(stack);
        if (!Strings.isNullOrEmpty((String)name)) {
            if (!worldIn.field_72995_K && NaturesAuraAPI.instance().extractAuraFromPlayer(playerIn, 10000, false)) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerIn), (INamedContainerProvider)new INamedContainerProvider(){

                    public ITextComponent func_145748_c_() {
                        return new TranslationTextComponent("info.naturesaura.ender_access", new Object[]{TextFormatting.ITALIC + name + TextFormatting.RESET});
                    }

                    @Nullable
                    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
                        IItemHandlerModifiable handler = IWorldData.getOverworldData(inv.field_70458_d.field_70170_p).getEnderStorage(name);
                        return new ContainerEnderCrate(ModContainers.ENDER_ACCESS, windowId, player, (IItemHandler)handler);
                    }
                }, buffer -> buffer.func_180714_a(name));
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return new ActionResult(ActionResultType.FAIL, (Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        BlockEnderCrate.addEnderNameInfo(stack, tooltip);
    }
}

