/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items;

import de.ellpeck.naturesaura.NaturesAura;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.multiblock.IMultiblock;
import de.ellpeck.naturesaura.items.ItemImpl;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class ItemMultiblockMaker
extends ItemImpl {
    private static List<IMultiblock> multiblocks;

    public ItemMultiblockMaker() {
        super("multiblock_maker", new Item.Properties().func_200916_a(NaturesAura.CREATIVE_TAB));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K && playerIn.func_184812_l_()) {
            int curr = ItemMultiblockMaker.getMultiblock(stack);
            int next = (curr + 1) % ItemMultiblockMaker.multiblocks().size();
            stack.func_196082_o().func_74768_a("multiblock", next);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player.func_184812_l_()) {
            int id = ItemMultiblockMaker.getMultiblock(player.func_184586_b(context.func_221531_n()));
            if (id < 0) {
                return ActionResultType.PASS;
            }
            IMultiblock multi = ItemMultiblockMaker.multiblocks().get(id);
            if (multi == null) {
                return ActionResultType.PASS;
            }
            if (!context.func_195991_k().field_72995_K) {
                multi.forEach(context.func_195995_a().func_177984_a(), '\u0000', (blockPos, matcher) -> {
                    context.func_195991_k().func_175656_a(blockPos, matcher.getDefaultState());
                    return true;
                });
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        ITextComponent name = super.func_200295_i(stack);
        int id = ItemMultiblockMaker.getMultiblock(stack);
        if (id < 0) {
            return name;
        }
        IMultiblock multi = ItemMultiblockMaker.multiblocks().get(id);
        return multi == null ? name : name.func_150258_a(" (" + multi.getName() + ")");
    }

    private static int getMultiblock(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return -1;
        }
        return stack.func_77978_p().func_74762_e("multiblock");
    }

    private static List<IMultiblock> multiblocks() {
        if (multiblocks == null) {
            multiblocks = new ArrayList<IMultiblock>();
            multiblocks.addAll(NaturesAuraAPI.MULTIBLOCKS.values());
        }
        return multiblocks;
    }
}

