/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items.tools;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.NaturesAura;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.misc.IWorldData;
import de.ellpeck.naturesaura.items.ModItems;
import de.ellpeck.naturesaura.misc.WorldData;
import de.ellpeck.naturesaura.reg.IModItem;
import de.ellpeck.naturesaura.reg.IModelProvider;
import de.ellpeck.naturesaura.reg.ModRegistry;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.PickaxeItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemPickaxe
extends PickaxeItem
implements IModItem,
IModelProvider {
    private final String baseName;

    public ItemPickaxe(String baseName, IItemTier material, int damage, float speed) {
        super(material, damage, speed, new Item.Properties().func_200916_a(NaturesAura.CREATIVE_TAB));
        this.baseName = baseName;
        ModRegistry.add(this);
    }

    @Override
    public String getBaseName() {
        return this.baseName;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (this == ModItems.INFUSED_IRON_PICKAXE) {
            PlayerEntity player = context.func_195999_j();
            World world = context.func_195991_k();
            BlockPos pos = context.func_195995_a();
            ItemStack stack = player.func_184586_b(context.func_221531_n());
            BlockState state = world.func_180495_p(pos);
            BlockState result = (BlockState)NaturesAuraAPI.BOTANIST_PICKAXE_CONVERSIONS.get((Object)state);
            if (result != null) {
                if (!world.field_72995_K) {
                    world.func_175656_a(pos, result);
                    WorldData data = (WorldData)IWorldData.getWorldData(world);
                    data.recentlyConvertedMossStones.add(pos);
                    if (data.recentlyConvertedMossStones.size() > 512) {
                        data.recentlyConvertedMossStones.remove(0);
                    }
                }
                world.func_184133_a(player, pos, SoundEvents.field_187845_fY, SoundCategory.BLOCKS, 1.0f, 1.0f);
                stack.func_222118_a(15, (LivingEntity)player, playerEntity -> playerEntity.func_213334_d(context.func_221531_n()));
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        if (this == ModItems.INFUSED_IRON_PICKAXE) {
            return Helper.makeRechargeProvider(stack, true);
        }
        return null;
    }
}

