/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.misc;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import de.ellpeck.naturesaura.blocks.BlockGoldenLeaves;
import de.ellpeck.naturesaura.blocks.ModBlocks;
import de.ellpeck.naturesaura.blocks.Slab;
import de.ellpeck.naturesaura.items.ModItems;
import de.ellpeck.naturesaura.reg.IModItem;
import de.ellpeck.naturesaura.reg.ModRegistry;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.state.IProperty;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.ConstantRange;
import net.minecraft.world.storage.loot.ILootConditionConsumer;
import net.minecraft.world.storage.loot.IRandomRange;
import net.minecraft.world.storage.loot.ItemLootEntry;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.StandaloneLootEntry;
import net.minecraft.world.storage.loot.conditions.BlockStateProperty;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraft.world.storage.loot.conditions.RandomChance;

public class BlockLootProvider
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;
    private final Map<Block, Function<Block, LootTable.Builder>> lootFunctions = new HashMap<Block, Function<Block, LootTable.Builder>>();

    public BlockLootProvider(DataGenerator generator) {
        this.generator = generator;
        for (IModItem item : ModRegistry.ALL_ITEMS) {
            if (!(item instanceof Block)) continue;
            Block block = (Block)item;
            if (block instanceof Slab) {
                this.lootFunctions.put(block, LootTableHooks::genSlab);
                continue;
            }
            this.lootFunctions.put(block, LootTableHooks::genRegular);
        }
        this.lootFunctions.put(ModBlocks.ANCIENT_LEAVES, b -> LootTableHooks.genLeaves(b, ModBlocks.ANCIENT_SAPLING));
        this.lootFunctions.put(ModBlocks.DECAYED_LEAVES, LootTableHooks::genSilkOnly);
        this.lootFunctions.put(ModBlocks.GOLDEN_LEAVES, b -> LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(((StandaloneLootEntry.Builder)LootTableHooks.survivesExplosion(b, ItemLootEntry.func_216168_a((IItemProvider)ModItems.GOLD_LEAF))).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)b).func_216299_a((IProperty)BlockGoldenLeaves.STAGE, (Comparable)Integer.valueOf(3)))).func_212840_b_(RandomChance.func_216004_a((float)0.75f))));
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        for (Map.Entry<Block, Function<Block, LootTable.Builder>> function : this.lootFunctions.entrySet()) {
            Block block = function.getKey();
            Function<Block, LootTable.Builder> func = function.getValue();
            LootTable table = func.apply(block).func_216039_a(LootParameterSets.field_216267_h).func_216038_b();
            Path path = BlockLootProvider.getPath(this.generator.func_200391_b(), block.getRegistryName());
            IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)LootTableManager.func_215301_a((LootTable)table), (Path)path);
        }
    }

    private static Path getPath(Path root, ResourceLocation res) {
        return root.resolve("data/" + res.func_110624_b() + "/loot_tables/blocks/" + res.func_110623_a() + ".json");
    }

    @Nonnull
    public String func_200397_b() {
        return "Nature's Aura Loot";
    }

    private static class LootTableHooks
    extends BlockLootTables {
        private LootTableHooks() {
        }

        public static LootTable.Builder genLeaves(Block block, Block drop) {
            return LootTableHooks.func_218540_a((Block)block, (Block)drop, (float[])new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f});
        }

        public static LootTable.Builder genSlab(Block block) {
            return LootTableHooks.func_218513_d((Block)block);
        }

        public static LootTable.Builder genRegular(Block block) {
            return LootTableHooks.func_218546_a((IItemProvider)block);
        }

        public static LootTable.Builder genSilkOnly(Block block) {
            return LootTableHooks.func_218561_b((IItemProvider)block);
        }

        public static <T> T survivesExplosion(Block block, ILootConditionConsumer<T> then) {
            return (T)LootTableHooks.func_218560_a((IItemProvider)block, then);
        }
    }
}

