/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.misc;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.misc.IWorldData;
import de.ellpeck.naturesaura.blocks.tiles.ItemStackHandlerNA;
import de.ellpeck.naturesaura.items.ModItems;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class WorldData
implements IWorldData {
    private final Map<String, ItemStackHandlerNA> enderStorages = new HashMap<String, ItemStackHandlerNA>();
    public final ListMultimap<ResourceLocation, Tuple<Vec3d, Integer>> effectPowders = ArrayListMultimap.create();
    public final List<BlockPos> recentlyConvertedMossStones = new ArrayList<BlockPos>();

    @Nullable
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        return capability == NaturesAuraAPI.capWorldData ? LazyOptional.of(() -> this) : LazyOptional.empty();
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT compound = new CompoundNBT();
        ListNBT storages = new ListNBT();
        for (Map.Entry<String, ItemStackHandlerNA> entry : this.enderStorages.entrySet()) {
            ItemStackHandlerNA handler = entry.getValue();
            if (Helper.isEmpty((IItemHandler)handler)) continue;
            CompoundNBT storageComp = handler.serializeNBT();
            storageComp.func_74778_a("name", entry.getKey());
            storages.add((Object)storageComp);
        }
        compound.func_218657_a("storages", (INBT)storages);
        ListNBT moss = new ListNBT();
        for (BlockPos pos : this.recentlyConvertedMossStones) {
            moss.add((Object)new LongNBT(pos.func_218275_a()));
        }
        compound.func_218657_a("converted_moss", (INBT)moss);
        return compound;
    }

    public void deserializeNBT(CompoundNBT compound) {
        this.enderStorages.clear();
        for (INBT base : compound.func_150295_c("storages", 10)) {
            CompoundNBT storageComp = (CompoundNBT)base;
            ItemStackHandlerNA storage = this.getEnderStorage(storageComp.func_74779_i("name"));
            storage.deserializeNBT(storageComp);
        }
        this.recentlyConvertedMossStones.clear();
        for (INBT base : compound.func_150295_c("converted_moss", 4)) {
            this.recentlyConvertedMossStones.add(BlockPos.func_218283_e((long)((LongNBT)base).func_150291_c()));
        }
    }

    public ItemStackHandlerNA getEnderStorage(String name) {
        return this.enderStorages.computeIfAbsent(name, n -> new ItemStackHandlerNA(27));
    }

    @Override
    public boolean isEnderStorageLocked(String name) {
        ItemStackHandlerNA handler = this.getEnderStorage(name);
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.func_190926_b() || stack.func_77973_b() != ModItems.TOKEN_TERROR) continue;
            return true;
        }
        return false;
    }
}

