/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.particles;

import com.mojang.blaze3d.platform.GlStateManager;
import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.particles.ParticleMagic;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.ParticleStatus;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class ParticleHandler {
    public static boolean depthEnabled = true;
    public static int range = 32;
    private static final List<Particle> PARTICLES = new ArrayList<Particle>();
    private static final List<Particle> PARTICLES_NO_DEPTH = new ArrayList<Particle>();

    public static void spawnParticle(Supplier<Particle> particle, double x, double y, double z) {
        if (Minecraft.func_71410_x().field_71439_g.func_70092_e(x, y, z) <= (double)(range * range)) {
            ParticleStatus setting;
            Minecraft mc = Minecraft.func_71410_x();
            if (!(!((Boolean)ModConfig.instance.respectVanillaParticleSettings.get()).booleanValue() || (setting = mc.field_71474_y.field_74362_aa) == ParticleStatus.ALL || setting == ParticleStatus.DECREASED && mc.field_71441_e.field_73012_v.nextInt(3) == 0 || setting == ParticleStatus.MINIMAL && mc.field_71441_e.field_73012_v.nextInt(10) == 0)) {
                return;
            }
            double setting2 = (Double)ModConfig.instance.particleAmount.get();
            if (setting2 < 1.0 && mc.field_71441_e.field_73012_v.nextDouble() > setting2) {
                return;
            }
            if (depthEnabled) {
                PARTICLES.add(particle.get());
            } else {
                PARTICLES_NO_DEPTH.add(particle.get());
            }
        }
    }

    public static void updateParticles() {
        ParticleHandler.updateList(PARTICLES);
        ParticleHandler.updateList(PARTICLES_NO_DEPTH);
        depthEnabled = true;
        range = 32;
    }

    private static void updateList(List<Particle> particles) {
        for (int i = particles.size() - 1; i >= 0; --i) {
            Particle particle = particles.get(i);
            particle.func_189213_a();
            if (particle.func_187113_k()) continue;
            particles.remove(i);
        }
    }

    public static void renderParticles(float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (player != null) {
            ActiveRenderInfo info = mc.field_71460_t.func_215316_n();
            float f = MathHelper.func_76134_b((float)(info.func_216778_f() * ((float)Math.PI / 180)));
            float f1 = MathHelper.func_76126_a((float)(info.func_216778_f() * ((float)Math.PI / 180)));
            float f2 = -f1 * MathHelper.func_76126_a((float)(info.func_216777_e() * ((float)Math.PI / 180)));
            float f3 = f * MathHelper.func_76126_a((float)(info.func_216777_e() * ((float)Math.PI / 180)));
            float f4 = MathHelper.func_76134_b((float)(info.func_216777_e() * ((float)Math.PI / 180)));
            Particle.field_70556_an = info.func_216785_c().field_72450_a;
            Particle.field_70554_ao = info.func_216785_c().field_72448_b;
            Particle.field_70555_ap = info.func_216785_c().field_72449_c;
            GlStateManager.pushMatrix();
            GlStateManager.enableAlphaTest();
            GlStateManager.enableBlend();
            GlStateManager.alphaFunc((int)516, (float)0.003921569f);
            GlStateManager.disableCull();
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            GlStateManager.depthMask((boolean)false);
            mc.func_110434_K().func_110577_a(ParticleMagic.TEXTURE);
            Tessellator tessy = Tessellator.func_178181_a();
            BufferBuilder buffer = tessy.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
            for (Particle particle : PARTICLES) {
                particle.func_180434_a(buffer, info, partialTicks, f, f4, f1, f2, f3);
            }
            tessy.func_78381_a();
            GlStateManager.disableDepthTest();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
            for (Particle particle : PARTICLES_NO_DEPTH) {
                particle.func_180434_a(buffer, info, partialTicks, f, f4, f1, f2, f3);
            }
            tessy.func_78381_a();
            GlStateManager.enableDepthTest();
            GlStateManager.enableCull();
            GlStateManager.depthMask((boolean)true);
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.disableBlend();
            GlStateManager.alphaFunc((int)516, (float)0.1f);
            GlStateManager.popMatrix();
        }
    }

    public static int getParticleAmount(boolean depth) {
        return depth ? PARTICLES.size() : PARTICLES_NO_DEPTH.size();
    }

    public static void clearParticles() {
        if (!PARTICLES.isEmpty()) {
            PARTICLES.clear();
        }
        if (!PARTICLES_NO_DEPTH.isEmpty()) {
            PARTICLES_NO_DEPTH.clear();
        }
    }
}

