/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.proxy;

import de.ellpeck.naturesaura.compat.Compat;
import de.ellpeck.naturesaura.events.ClientEvents;
import de.ellpeck.naturesaura.gui.GuiEnderCrate;
import de.ellpeck.naturesaura.gui.ModContainers;
import de.ellpeck.naturesaura.particles.ParticleHandler;
import de.ellpeck.naturesaura.particles.ParticleMagic;
import de.ellpeck.naturesaura.proxy.IProxy;
import de.ellpeck.naturesaura.reg.IColorProvidingBlock;
import de.ellpeck.naturesaura.reg.IColorProvidingItem;
import de.ellpeck.naturesaura.reg.ITESRProvider;
import de.ellpeck.naturesaura.renderers.PlayerLayerTrinkets;
import de.ellpeck.naturesaura.renderers.SupporterFancyHandler;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Tuple;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

public class ClientProxy
implements IProxy {
    @Override
    public void preInit(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ClientEvents());
        Compat.preInitClient();
        ScreenManager.func_216911_a(ModContainers.ENDER_CRATE, GuiEnderCrate::new);
        ScreenManager.func_216911_a(ModContainers.ENDER_ACCESS, GuiEnderCrate::new);
    }

    @Override
    public void init(FMLCommonSetupEvent event) {
        Map skinMap = Minecraft.func_71410_x().func_175598_ae().getSkinMap();
        for (PlayerRenderer render : new PlayerRenderer[]{(PlayerRenderer)skinMap.get("default"), (PlayerRenderer)skinMap.get("slim")}) {
            render.func_177094_a((LayerRenderer)new PlayerLayerTrinkets((IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>)render));
        }
        new SupporterFancyHandler();
    }

    @Override
    public void postInit(FMLCommonSetupEvent event) {
    }

    @Override
    public void addColorProvidingItem(IColorProvidingItem item) {
        ItemColors colors = Minecraft.func_71410_x().getItemColors();
        IItemColor color = item.getItemColor();
        if (item instanceof Item) {
            colors.func_199877_a(color, new IItemProvider[]{(Item)item});
        } else if (item instanceof Block) {
            colors.func_199877_a(color, new IItemProvider[]{(Block)item});
        }
    }

    @Override
    public void addColorProvidingBlock(IColorProvidingBlock block) {
        if (block instanceof Block) {
            Minecraft.func_71410_x().func_184125_al().func_186722_a(block.getBlockColor(), new Block[]{(Block)block});
        }
    }

    @Override
    public void registerTESR(ITESRProvider provider) {
        Tuple<Class, TileEntityRenderer> tesr = provider.getTESR();
        ClientRegistry.bindTileEntitySpecialRenderer((Class)((Class)tesr.func_76341_a()), (TileEntityRenderer)((TileEntityRenderer)tesr.func_76340_b()));
    }

    @Override
    public void spawnMagicParticle(double posX, double posY, double posZ, double motionX, double motionY, double motionZ, int color, float scale, int maxAge, float gravity, boolean collision, boolean fade) {
        ParticleHandler.spawnParticle(() -> new ParticleMagic((World)Minecraft.func_71410_x().field_71441_e, posX, posY, posZ, motionX, motionY, motionZ, color, scale, maxAge, gravity, collision, fade), posX, posY, posZ);
    }

    @Override
    public void setParticleDepth(boolean depth) {
        ParticleHandler.depthEnabled = depth;
    }

    @Override
    public void setParticleSpawnRange(int range) {
        ParticleHandler.range = range;
    }

    @Override
    public <T extends Entity> void registerEntityRenderer(Class<T> entityClass, Supplier<IRenderFactory<T>> renderFactory) {
        RenderingRegistry.registerEntityRenderingHandler(entityClass, renderFactory.get());
    }
}

