/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.recipes;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.recipes.AltarRecipe;
import de.ellpeck.naturesaura.api.recipes.AnimalSpawnerRecipe;
import de.ellpeck.naturesaura.api.recipes.OfferingRecipe;
import de.ellpeck.naturesaura.api.recipes.TreeRitualRecipe;
import de.ellpeck.naturesaura.api.recipes.WeightedOre;
import de.ellpeck.naturesaura.api.recipes.ing.AmountIngredient;
import de.ellpeck.naturesaura.api.recipes.ing.NBTIngredient;
import de.ellpeck.naturesaura.blocks.ModBlocks;
import de.ellpeck.naturesaura.chunk.effect.AnimalEffect;
import de.ellpeck.naturesaura.chunk.effect.CacheRechargeEffect;
import de.ellpeck.naturesaura.chunk.effect.OreSpawnEffect;
import de.ellpeck.naturesaura.chunk.effect.PlantBoostEffect;
import de.ellpeck.naturesaura.items.ItemAuraBottle;
import de.ellpeck.naturesaura.items.ItemEffectPowder;
import de.ellpeck.naturesaura.items.ModItems;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowerBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;

public final class ModRecipes {
    public static void init() {
        new TreeRitualRecipe(ModRecipes.res("eye"), ModRecipes.ing(new ItemStack((IItemProvider)Blocks.field_196674_t)), new ItemStack((IItemProvider)ModItems.EYE), 250, ModRecipes.ing(Items.field_151070_bp), ModRecipes.ing(Items.field_151043_k), ModRecipes.ing(ModItems.GOLD_LEAF), ModRecipes.ing(ModItems.GOLD_LEAF)).register();
        new TreeRitualRecipe(ModRecipes.res("eye_improved"), ModRecipes.ing(new ItemStack((IItemProvider)Blocks.field_196674_t)), new ItemStack((IItemProvider)ModItems.EYE_IMPROVED), 500, ModRecipes.ing(ModItems.EYE), ModRecipes.ing(ModItems.SKY_INGOT), ModRecipes.ing(ModItems.SKY_INGOT), ModRecipes.ing(ModBlocks.END_FLOWER), ModRecipes.ing(ModItems.GOLD_LEAF), ModRecipes.ing(ModItems.GOLD_LEAF)).register();
        new TreeRitualRecipe(ModRecipes.res("nature_altar"), ModRecipes.ing(Blocks.field_196674_t), new ItemStack((IItemProvider)ModBlocks.NATURE_ALTAR), 500, ModRecipes.ing(Blocks.field_150348_b), ModRecipes.ing(Blocks.field_150348_b), ModRecipes.ing(Blocks.field_150348_b), ModRecipes.ing(ModItems.GOLD_LEAF), ModRecipes.ing(Items.field_151043_k), ModRecipes.ing(ModItems.TOKEN_JOY)).register();
        new TreeRitualRecipe(ModRecipes.res("ancient_sapling"), ModRecipes.ing(Blocks.field_196674_t), new ItemStack((IItemProvider)ModBlocks.ANCIENT_SAPLING), 200, ModRecipes.ing(Blocks.field_196674_t), ModRecipes.ing(Blocks.field_196605_bc), ModRecipes.ing(Blocks.field_196606_bd), ModRecipes.ing(Items.field_151014_N), ModRecipes.ing(Items.field_222065_kN), ModRecipes.ing(ModItems.GOLD_LEAF)).register();
        new TreeRitualRecipe(ModRecipes.res("furnace_heater"), ModRecipes.ing(Blocks.field_196674_t), new ItemStack((IItemProvider)ModBlocks.FURNACE_HEATER), 600, ModRecipes.ing(ModBlocks.INFUSED_STONE), ModRecipes.ing(ModBlocks.INFUSED_STONE), ModRecipes.ing(ModItems.INFUSED_IRON), ModRecipes.ing(ModItems.INFUSED_IRON), ModRecipes.ing(Items.field_151059_bz), ModRecipes.ing(Items.field_151145_ak), ModRecipes.ing(Blocks.field_196814_hQ), ModRecipes.ing(ModItems.TOKEN_FEAR)).register();
        new TreeRitualRecipe(ModRecipes.res("conversion_catalyst"), ModRecipes.ing(Blocks.field_196678_w), new ItemStack((IItemProvider)ModBlocks.CONVERSION_CATALYST), 600, ModRecipes.ing(ModBlocks.GOLD_BRICK), ModRecipes.ing(ModBlocks.INFUSED_STONE), ModRecipes.ing(Items.field_222088_mr), ModRecipes.ing(ModItems.SKY_INGOT), ModRecipes.ing(ModItems.GOLD_LEAF), ModRecipes.ing(Blocks.field_150426_aN)).register();
        new TreeRitualRecipe(ModRecipes.res("crushing_catalyst"), ModRecipes.ing(Blocks.field_196674_t), new ItemStack((IItemProvider)ModBlocks.CRUSHING_CATALYST), 600, ModRecipes.ing(ModBlocks.GOLD_BRICK), ModRecipes.ing(ModBlocks.INFUSED_STONE), ModRecipes.ing(Blocks.field_150331_J), ModRecipes.ing(Items.field_151145_ak), ModRecipes.ing(ModItems.TOKEN_ANGER)).register();
        new TreeRitualRecipe(ModRecipes.res("plant_powder"), ModRecipes.ing(new ItemStack((IItemProvider)Blocks.field_196674_t)), ItemEffectPowder.setEffect(new ItemStack((IItemProvider)ModItems.EFFECT_POWDER, 24), PlantBoostEffect.NAME), 400, ModRecipes.ing(ModBlocks.GOLD_POWDER), ModRecipes.ing(ModBlocks.GOLD_POWDER), ModRecipes.ing(ModItems.SKY_INGOT), ModRecipes.ing(Items.field_151015_O)).register();
        new TreeRitualRecipe(ModRecipes.res("cache_powder"), ModRecipes.ing(new ItemStack((IItemProvider)Blocks.field_196674_t)), ItemEffectPowder.setEffect(new ItemStack((IItemProvider)ModItems.EFFECT_POWDER, 32), CacheRechargeEffect.NAME), 400, ModRecipes.ing(ModBlocks.GOLD_POWDER), ModRecipes.ing(ModBlocks.GOLD_POWDER), ModRecipes.ing(ModItems.SKY_INGOT), ModRecipes.ing(ModItems.AURA_CACHE)).register();
        new TreeRitualRecipe(ModRecipes.res("animal_powder"), ModRecipes.ing(Blocks.field_196678_w), ItemEffectPowder.setEffect(new ItemStack((IItemProvider)ModItems.EFFECT_POWDER, 8), AnimalEffect.NAME), 400, ModRecipes.ing(ModBlocks.GOLD_POWDER), ModRecipes.ing(ModBlocks.GOLD_POWDER), ModRecipes.ing(ModItems.SKY_INGOT), ModRecipes.ing(Items.field_151110_aK)).register();
        new TreeRitualRecipe(ModRecipes.res("ore_spawn_powder"), ModRecipes.ing(Blocks.field_196674_t), ItemEffectPowder.setEffect(new ItemStack((IItemProvider)ModItems.EFFECT_POWDER, 4), OreSpawnEffect.NAME), 400, ModRecipes.ing(ModBlocks.GOLD_POWDER), ModRecipes.ing(ModBlocks.GOLD_POWDER), ModRecipes.ing(Blocks.field_150482_ag), ModRecipes.ing(Blocks.field_150450_ax)).register();
        new TreeRitualRecipe(ModRecipes.res("token_joy"), ModRecipes.ing(Blocks.field_196674_t), new ItemStack((IItemProvider)ModItems.TOKEN_JOY, 2), 200, ModRecipes.nbtIng(ItemAuraBottle.setType(new ItemStack((IItemProvider)ModItems.AURA_BOTTLE), NaturesAuraAPI.TYPE_OVERWORLD)), ModRecipes.ing(ModItems.GOLD_LEAF), ModRecipes.ing((Tag<Item>)ItemTags.field_219770_E), ModRecipes.ing(Items.field_151034_e), ModRecipes.ing(Blocks.field_150478_aa), ModRecipes.ing(Items.field_151042_j)).register();
        new TreeRitualRecipe(ModRecipes.res("token_anger"), ModRecipes.ing(Blocks.field_196674_t), new ItemStack((IItemProvider)ModItems.TOKEN_ANGER, 2), 200, ModRecipes.nbtIng(ItemAuraBottle.setType(new ItemStack((IItemProvider)ModItems.AURA_BOTTLE), NaturesAuraAPI.TYPE_NETHER)), ModRecipes.ing(ModItems.GOLD_LEAF), ModRecipes.ing(Blocks.field_196814_hQ), ModRecipes.ing(Items.field_151065_br), ModRecipes.ing(Items.field_151016_H), ModRecipes.ing(Items.field_151079_bi)).register();
        new TreeRitualRecipe(ModRecipes.res("token_sorrow"), ModRecipes.ing(Blocks.field_196674_t), new ItemStack((IItemProvider)ModItems.TOKEN_SORROW, 2), 200, ModRecipes.nbtIng(ItemAuraBottle.setType(new ItemStack((IItemProvider)ModItems.AURA_BOTTLE), NaturesAuraAPI.TYPE_OVERWORLD)), ModRecipes.ing(ModItems.GOLD_LEAF), ModRecipes.ing(Items.field_151073_bk), ModRecipes.ing(Items.field_151082_bd, Items.field_179561_bm, Items.field_151076_bf, Items.field_151147_al), ModRecipes.ing(Blocks.field_150359_w), ModRecipes.ing((Tag<Item>)ItemTags.field_206964_G)).register();
        new TreeRitualRecipe(ModRecipes.res("token_fear"), ModRecipes.ing(Blocks.field_196674_t), new ItemStack((IItemProvider)ModItems.TOKEN_FEAR, 2), 200, ModRecipes.nbtIng(ItemAuraBottle.setType(new ItemStack((IItemProvider)ModItems.AURA_BOTTLE), NaturesAuraAPI.TYPE_NETHER)), ModRecipes.ing(ModItems.GOLD_LEAF), ModRecipes.ing(Items.field_151078_bh), ModRecipes.ing(Items.field_151008_G), ModRecipes.ing(Items.field_151103_aS), ModRecipes.ing(Blocks.field_150425_aM)).register();
        new AltarRecipe(ModRecipes.res("infused_iron"), ModRecipes.ing(Items.field_151042_j), new ItemStack((IItemProvider)ModItems.INFUSED_IRON), Ingredient.field_193370_a, 15000, 80).register();
        new AltarRecipe(ModRecipes.res("infused_iron_block"), ModRecipes.ing(Blocks.field_150339_S), new ItemStack((IItemProvider)ModBlocks.INFUSED_IRON_BLOCK), Ingredient.field_193370_a, 135000, 700).register();
        new AltarRecipe(ModRecipes.res("infused_stone"), ModRecipes.ing(Blocks.field_150348_b), new ItemStack((IItemProvider)ModBlocks.INFUSED_STONE), Ingredient.field_193370_a, 7500, 40).register();
        Ingredient conversion = ModRecipes.ing(ModBlocks.CONVERSION_CATALYST);
        new AltarRecipe(ModRecipes.res("breath"), ModRecipes.nbtIng(ItemAuraBottle.setType(new ItemStack((IItemProvider)ModItems.AURA_BOTTLE), NaturesAuraAPI.TYPE_END)), new ItemStack((IItemProvider)Items.field_185157_bK), conversion, 20000, 80).register();
        new AltarRecipe(ModRecipes.res("leather"), ModRecipes.ing(Items.field_151078_bh), new ItemStack((IItemProvider)Items.field_151116_aA), conversion, 10000, 50).register();
        new AltarRecipe(ModRecipes.res("soul_sand"), ModRecipes.ing(Blocks.field_150354_m), new ItemStack((IItemProvider)Blocks.field_150425_aM), conversion, 5000, 100).register();
        new AltarRecipe(ModRecipes.res("nether_wart"), ModRecipes.ing(Blocks.field_150337_Q), new ItemStack((IItemProvider)Items.field_151075_bm), conversion, 30000, 250).register();
        new AltarRecipe(ModRecipes.res("prismarine"), ModRecipes.ing(Items.field_151128_bU), new ItemStack((IItemProvider)Items.field_179562_cC), conversion, 55000, 200).register();
        new AltarRecipe(ModRecipes.res("water"), ModRecipes.ing(Items.field_151069_bo), PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185230_b), conversion, 25000, 200).register();
        new AltarRecipe(ModRecipes.res("coal"), ModRecipes.ing((Tag<Item>)ItemTags.field_219775_L), new ItemStack((IItemProvider)Items.field_151044_h), conversion, 30000, 250).register();
        Ingredient crushing = ModRecipes.ing(ModBlocks.CRUSHING_CATALYST);
        new AltarRecipe(ModRecipes.res("bone"), ModRecipes.ing(Items.field_151103_aS), new ItemStack((IItemProvider)Items.field_196106_bc, 6), crushing, 3000, 40).register();
        new AltarRecipe(ModRecipes.res("sugar"), ModRecipes.ing(Items.field_222065_kN), new ItemStack((IItemProvider)Items.field_151102_aT, 3), crushing, 3000, 40).register();
        new AltarRecipe(ModRecipes.res("blaze"), ModRecipes.ing(Items.field_151072_bj), new ItemStack((IItemProvider)Items.field_151065_br, 4), crushing, 5000, 60).register();
        new AltarRecipe(ModRecipes.res("glowstone"), ModRecipes.ing(Blocks.field_150426_aN), new ItemStack((IItemProvider)Items.field_151114_aO, 4), crushing, 3000, 40).register();
        new AltarRecipe(ModRecipes.res("sand"), ModRecipes.ing(Blocks.field_150347_e), new ItemStack((IItemProvider)Blocks.field_150354_m), crushing, 3000, 40).register();
        new OfferingRecipe(ModRecipes.res("sky_ingot"), ModRecipes.amountIng(new ItemStack((IItemProvider)ModItems.INFUSED_IRON, 3)), ModRecipes.ing(ModItems.CALLING_SPIRIT), new ItemStack((IItemProvider)ModItems.SKY_INGOT)).register();
        new OfferingRecipe(ModRecipes.res("clock_hand"), ModRecipes.ing(Items.field_151156_bN), ModRecipes.ing(ModItems.CALLING_SPIRIT), new ItemStack((IItemProvider)ModItems.CLOCK_HAND)).register();
        new OfferingRecipe(ModRecipes.res("token_euphoria"), ModRecipes.ing(ModItems.TOKEN_JOY), ModRecipes.ing(ModItems.CALLING_SPIRIT), new ItemStack((IItemProvider)ModItems.TOKEN_EUPHORIA)).register();
        new OfferingRecipe(ModRecipes.res("token_rage"), ModRecipes.ing(ModItems.TOKEN_ANGER), ModRecipes.ing(ModItems.CALLING_SPIRIT), new ItemStack((IItemProvider)ModItems.TOKEN_RAGE)).register();
        new OfferingRecipe(ModRecipes.res("token_grief"), ModRecipes.ing(ModItems.TOKEN_SORROW), ModRecipes.ing(ModItems.CALLING_SPIRIT), new ItemStack((IItemProvider)ModItems.TOKEN_GRIEF)).register();
        new OfferingRecipe(ModRecipes.res("token_terror"), ModRecipes.ing(ModItems.TOKEN_FEAR), ModRecipes.ing(ModItems.CALLING_SPIRIT), new ItemStack((IItemProvider)ModItems.TOKEN_TERROR)).register();
        NaturesAuraAPI.BOTANIST_PICKAXE_CONVERSIONS.put((Object)Blocks.field_150347_e.func_176223_P(), (Object)Blocks.field_150341_Y.func_176223_P());
        NaturesAuraAPI.BOTANIST_PICKAXE_CONVERSIONS.put((Object)Blocks.field_196696_di.func_176223_P(), (Object)Blocks.field_196698_dj.func_176223_P());
        NaturesAuraAPI.BOTANIST_PICKAXE_CONVERSIONS.put((Object)Blocks.field_150463_bK.func_176223_P(), (Object)Blocks.field_196723_eg.func_176223_P());
        NaturesAuraAPI.BOTANIST_PICKAXE_CONVERSIONS.put((Object)Blocks.field_222413_lB.func_176223_P(), (Object)Blocks.field_222462_lz.func_176223_P());
        for (Block block : ForgeRegistries.BLOCKS) {
            if (!(block instanceof FlowerBlock)) continue;
            NaturesAuraAPI.FLOWERS.addAll((Collection<BlockState>)block.func_176194_O().func_177619_a());
        }
        for (final DyeColor color : DyeColor.values()) {
            new AnimalSpawnerRecipe(ModRecipes.res("sheep_" + color.func_176610_l()), EntityType.field_200737_ac, 500, 60, new Ingredient[]{ModRecipes.ing(ModItems.BIRTH_SPIRIT), ModRecipes.ing(Items.field_179561_bm), ModRecipes.ing(Helper.getWool(color))}){

                @Override
                public Entity makeEntity(World world, double x, double y, double z) {
                    SheepEntity sheep = (SheepEntity)super.makeEntity(world, x, y, z);
                    sheep.func_175512_b(color);
                    return sheep;
                }
            }.register();
        }
        ModRecipes.spawner("cow", EntityType.field_200796_j, 50000, 60, ModRecipes.ing(Items.field_151082_bd), ModRecipes.ing(Items.field_151116_aA));
        ModRecipes.spawner("chicken", EntityType.field_200795_i, 30000, 40, ModRecipes.ing(Items.field_151008_G), ModRecipes.ing(Items.field_151110_aK));
        ModRecipes.spawner("pig", EntityType.field_200784_X, 50000, 60, ModRecipes.ing(Items.field_151147_al));
        ModRecipes.spawner("blaze", EntityType.field_200792_f, 150000, 120, ModRecipes.ing(Items.field_151072_bj), ModRecipes.ing(Items.field_151065_br));
        ModRecipes.spawner("ghast", EntityType.field_200811_y, 120000, 150, ModRecipes.ing(Items.field_151016_H), ModRecipes.ing(Items.field_151073_bk));
        ModRecipes.spawner("ocelot", EntityType.field_200781_U, 80000, 60, ModRecipes.ing(Items.field_196086_aW), ModRecipes.ing((Tag<Item>)ItemTags.field_199904_a));
        ModRecipes.spawner("mule", EntityType.field_200779_S, 100000, 100, ModRecipes.ing(Items.field_151116_aA), ModRecipes.ing(Blocks.field_150486_ae), ModRecipes.ing(Items.field_151034_e));
        ModRecipes.spawner("bat", EntityType.field_200791_e, 30000, 40, ModRecipes.ing(Items.field_151008_G));
        ModRecipes.spawner("endermite", EntityType.field_200804_r, 30000, 40, ModRecipes.ing(Items.field_151079_bi), ModRecipes.ing(Blocks.field_150348_b));
        ModRecipes.spawner("parrot", EntityType.field_200783_W, 50000, 60, ModRecipes.ing(Items.field_151008_G), ModRecipes.ing(Items.field_151106_aX));
        ModRecipes.spawner("slime", EntityType.field_200743_ai, 30000, 40, ModRecipes.ing(Items.field_151123_aH));
        ModRecipes.spawner("spider", EntityType.field_200748_an, 100000, 120, ModRecipes.ing(Items.field_151007_F), ModRecipes.ing(Items.field_151070_bp));
        ModRecipes.spawner("skeleton", EntityType.field_200741_ag, 100000, 120, ModRecipes.ing(Items.field_151103_aS), ModRecipes.ing(Items.field_151032_g));
        ModRecipes.spawner("enderman", EntityType.field_200803_q, 120000, 120, ModRecipes.ing(Items.field_151079_bi));
        ModRecipes.spawner("silverfish", EntityType.field_200740_af, 30000, 40, ModRecipes.ing(Blocks.field_150348_b));
        ModRecipes.spawner("squid", EntityType.field_200749_ao, 50000, 40, ModRecipes.ing(Items.field_196136_br));
        ModRecipes.spawner("stray", EntityType.field_200750_ap, 100000, 120, ModRecipes.ing(Items.field_151103_aS), ModRecipes.ing(Blocks.field_150432_aD));
        ModRecipes.spawner("shulker", EntityType.field_200738_ad, 150000, 100, ModRecipes.ing(Items.field_190930_cZ));
        ModRecipes.spawner("husk", EntityType.field_200763_C, 100000, 120, ModRecipes.ing(Items.field_151078_bh), ModRecipes.ing(Blocks.field_150354_m));
        ModRecipes.spawner("llama", EntityType.field_200769_I, 60000, 80, ModRecipes.ing((Tag<Item>)ItemTags.field_199904_a));
        ModRecipes.spawner("rabbit", EntityType.field_200736_ab, 30000, 40, ModRecipes.ing(Items.field_179555_bs));
        ModRecipes.spawner("magma_cube", EntityType.field_200771_K, 100000, 100, ModRecipes.ing(Items.field_151064_bs));
        ModRecipes.spawner("zombie_pigman", EntityType.field_200785_Y, 120000, 150, ModRecipes.ing(Items.field_151078_bh), ModRecipes.ing(Items.field_151074_bl));
        ModRecipes.spawner("polar_bear", EntityType.field_200786_Z, 50000, 60, ModRecipes.ing(Items.field_196086_aW), ModRecipes.ing(Blocks.field_150432_aD));
        ModRecipes.spawner("mooshroom", EntityType.field_200780_T, 40000, 60, ModRecipes.ing(Items.field_151116_aA), ModRecipes.ing(Blocks.field_150337_Q));
        ModRecipes.spawner("guardian", EntityType.field_200761_A, 150000, 150, ModRecipes.ing(Items.field_179562_cC), ModRecipes.ing(Items.field_179563_cD));
        ModRecipes.spawner("horse", EntityType.field_200762_B, 100000, 100, ModRecipes.ing(Items.field_151116_aA));
        ModRecipes.spawner("donkey", EntityType.field_200798_l, 100000, 100, ModRecipes.ing(Items.field_151116_aA), ModRecipes.ing(Blocks.field_150486_ae));
        ModRecipes.spawner("cave_spider", EntityType.field_200794_h, 100000, 120, ModRecipes.ing(Items.field_151007_F), ModRecipes.ing(Items.field_151071_bq));
        ModRecipes.spawner("creeper", EntityType.field_200797_k, 100000, 120, ModRecipes.ing(Items.field_151016_H));
        ModRecipes.spawner("witch", EntityType.field_200759_ay, 150000, 150, ModRecipes.ing(Items.field_151069_bo), ModRecipes.ing(Items.field_151114_aO));
        ModRecipes.spawner("wither_skeleton", EntityType.field_200722_aA, 150000, 150, ModRecipes.ing(Items.field_151103_aS), ModRecipes.ing(Blocks.field_150343_Z));
        ModRecipes.spawner("wolf", EntityType.field_200724_aC, 50000, 60, ModRecipes.ing(Items.field_151116_aA), ModRecipes.ing(Items.field_151103_aS));
        ModRecipes.spawner("zombie", EntityType.field_200725_aD, 100000, 100, ModRecipes.ing(Items.field_151078_bh));
        NaturesAuraAPI.OVERWORLD_ORES.add(new WeightedOre((Tag<Block>)Tags.Blocks.ORES_COAL, 5000));
        NaturesAuraAPI.OVERWORLD_ORES.add(new WeightedOre((Tag<Block>)Tags.Blocks.ORES_IRON, 3000));
        NaturesAuraAPI.OVERWORLD_ORES.add(new WeightedOre((Tag<Block>)Tags.Blocks.ORES_GOLD, 500));
        NaturesAuraAPI.OVERWORLD_ORES.add(new WeightedOre((Tag<Block>)Tags.Blocks.ORES_DIAMOND, 50));
        NaturesAuraAPI.OVERWORLD_ORES.add(new WeightedOre((Tag<Block>)Tags.Blocks.ORES_LAPIS, 250));
        NaturesAuraAPI.OVERWORLD_ORES.add(new WeightedOre((Tag<Block>)Tags.Blocks.ORES_REDSTONE, 200));
        NaturesAuraAPI.OVERWORLD_ORES.add(new WeightedOre((Tag<Block>)Tags.Blocks.ORES_EMERALD, 30));
        NaturesAuraAPI.NETHER_ORES.add(new WeightedOre((Tag<Block>)Tags.Blocks.ORES_QUARTZ, 3000));
        NaturesAuraAPI.PROJECTILE_GENERATIONS.put(EntityType.field_200751_aq, 2500);
        NaturesAuraAPI.PROJECTILE_GENERATIONS.put(EntityType.field_200746_al, 3500);
        NaturesAuraAPI.PROJECTILE_GENERATIONS.put(EntityType.field_200744_aj, 15000);
        NaturesAuraAPI.PROJECTILE_GENERATIONS.put(EntityType.field_200752_ar, 30000);
        NaturesAuraAPI.PROJECTILE_GENERATIONS.put(EntityType.field_200753_as, 75000);
        NaturesAuraAPI.PROJECTILE_GENERATIONS.put(EntityType.field_200790_d, 10000);
        NaturesAuraAPI.PROJECTILE_GENERATIONS.put(EntityType.field_200747_am, 15000);
        NaturesAuraAPI.PROJECTILE_GENERATIONS.put(EntityType.field_200739_ae, 250000);
        NaturesAuraAPI.PROJECTILE_GENERATIONS.put(EntityType.field_200770_J, 80000);
        NaturesAuraAPI.PROJECTILE_GENERATIONS.put(EntityType.field_203098_aL, 3000000);
    }

    private static void spawner(String name, EntityType entity, int aura, int time, Ingredient ... ings) {
        Ingredient[] actualIngs = new Ingredient[ings.length + 1];
        actualIngs[0] = ModRecipes.ing(ModItems.BIRTH_SPIRIT);
        System.arraycopy(ings, 0, actualIngs, 1, ings.length);
        new AnimalSpawnerRecipe(ModRecipes.res(name), entity, aura, time, actualIngs).register();
    }

    private static Ingredient ing(Block ... blocks) {
        return ModRecipes.ing((ItemStack[])Arrays.stream(blocks).map(ItemStack::new).toArray(ItemStack[]::new));
    }

    private static Ingredient ing(Item ... items) {
        return ModRecipes.ing((ItemStack[])Arrays.stream(items).map(ItemStack::new).toArray(ItemStack[]::new));
    }

    private static Ingredient ing(ItemStack ... stacks) {
        return Ingredient.func_193369_a((ItemStack[])stacks);
    }

    private static Ingredient ing(Tag<Item> tag) {
        return Ingredient.func_199805_a(tag);
    }

    private static Ingredient nbtIng(ItemStack stack) {
        return new NBTIngredient(stack);
    }

    private static Ingredient amountIng(ItemStack stack) {
        return new AmountIngredient(stack);
    }

    private static ResourceLocation res(String name) {
        return new ResourceLocation("naturesaura", name);
    }
}

