/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.renderers;

import com.mojang.blaze3d.platform.GlStateManager;
import de.ellpeck.naturesaura.api.render.ITrinketItem;
import de.ellpeck.naturesaura.compat.Compat;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import top.theillusivec4.curios.api.CuriosAPI;
import top.theillusivec4.curios.api.capability.ICurioItemHandler;

@OnlyIn(value=Dist.CLIENT)
public class PlayerLayerTrinkets
extends LayerRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> {
    private final Set<Item> alreadyRendered = new HashSet<Item>();

    public PlayerLayerTrinkets(IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> entityRendererIn) {
        super(entityRendererIn);
    }

    public void render(@Nonnull AbstractClientPlayerEntity player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (player.func_70660_b(Effects.field_76441_p) != null) {
            return;
        }
        ItemStack main = player.func_184614_ca();
        ItemStack second = player.func_184592_cb();
        this.alreadyRendered.clear();
        GlStateManager.pushMatrix();
        GlStateManager.pushLightingAttributes();
        GlStateManager.pushTextureAttributes();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.render((PlayerEntity)player, ITrinketItem.RenderType.BODY, main, second);
        float yaw = player.field_70758_at + (player.field_70759_as - player.field_70758_at) * partialTicks;
        float yawOffset = player.field_70760_ar + (player.field_70761_aq - player.field_70760_ar) * partialTicks;
        float pitch = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * partialTicks;
        GlStateManager.rotatef((float)yawOffset, (float)0.0f, (float)-1.0f, (float)0.0f);
        GlStateManager.rotatef((float)(yaw - 270.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)pitch, (float)0.0f, (float)0.0f, (float)1.0f);
        this.render((PlayerEntity)player, ITrinketItem.RenderType.HEAD, main, second);
        GlStateManager.popAttributes();
        GlStateManager.popAttributes();
        GlStateManager.popMatrix();
    }

    private void render(PlayerEntity player, ITrinketItem.RenderType type, ItemStack main, ItemStack second) {
        ICurioItemHandler handler;
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            this.renderStack(player.field_71071_by.func_70301_a(i), player, type, main, second);
        }
        if (Compat.hasCompat("curios") && (handler = (ICurioItemHandler)CuriosAPI.getCuriosHandler((LivingEntity)player).orElse(null)) != null) {
            for (IItemHandler items : handler.getCurioMap().values()) {
                for (int i = 0; i < items.getSlots(); ++i) {
                    this.renderStack(items.getStackInSlot(i), player, type, main, second);
                }
            }
        }
    }

    private void renderStack(ItemStack stack, PlayerEntity player, ITrinketItem.RenderType type, ItemStack main, ItemStack second) {
        Item item;
        if (!stack.func_190926_b() && (item = stack.func_77973_b()) instanceof ITrinketItem && !this.alreadyRendered.contains(item)) {
            GlStateManager.pushMatrix();
            if (type == ITrinketItem.RenderType.BODY && player.func_70093_af()) {
                GlStateManager.translatef((float)0.0f, (float)0.2f, (float)0.0f);
                GlStateManager.rotatef((float)28.647888f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            ((ITrinketItem)item).render(stack, player, type, stack == main || stack == second);
            GlStateManager.popMatrix();
            this.alreadyRendered.add(item);
        }
    }

    public boolean func_177142_b() {
        return false;
    }
}

